#ifndef	_CLASS_LISTBOX_H_
#define	_CLASS_LISTBOX_H_

//vim: ts=8
//   File : class_listbox.h
//   Creation date : Sat Oct 2 03:40:28 CET 2004 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2004 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//


#include "class_widget.h"

class QListBox;
class QListBoxItem;

class KviScriptListBoxObject : public KviScriptWidgetObject
{
	Q_OBJECT
public:
	KviScriptListBoxObject(KviScriptObjectClass *, KviScriptObject *, \
		const char *);
	~KviScriptListBoxObject();

	static void registerSelf();
	static void unregisterSelf();
	
protected:
	virtual bool init(KviCommand *);
	bool functionInsertList(KviCommand *, KviParameterList *, KviStr &);
	bool functionInsertItem(KviCommand *, KviParameterList *, KviStr &);
	bool functionChangeItem(KviCommand *, KviParameterList *, KviStr &);
	bool functionRemoveItem(KviCommand *, KviParameterList *, KviStr &);
	bool functionCount(KviCommand *, KviParameterList *, KviStr &);
	bool functionCurrentText(KviCommand *, KviParameterList *, KviStr &);
	bool functionCurrentItem(KviCommand *, KviParameterList *, KviStr &);
	bool functionTextAt(KviCommand *, KviParameterList *, KviStr &);
	bool functionSetCurrentItem(KviCommand *, KviParameterList *, KviStr &);
	bool functionClear(KviCommand *,KviParameterList *,KviStr &);
	bool functionSetSelectionMode(KviCommand *,KviParameterList *,KviStr &);
	bool functionSelectionMode(KviCommand *,KviParameterList *,KviStr &);
	bool functionSetSelected(KviCommand *,KviParameterList *,KviStr &);
	bool functionIsSelected(KviCommand *,KviParameterList *,KviStr &);
protected slots:
	void selectionChanged();
	void currentItemChanged(QListBoxItem *);
};

#endif	// !_CLASS_COMBOBOX_H_
