//
//   File : class_progressbar.cpp
//   Creation date : Fri Jan 28 14:21:48 CEST 2005 
//   by Tonino Imbesi(Grifisx) and Alessandro Carbone(Noldor)
// 
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2005 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include <qprogressbar.h>
#include "class_progressbar.h"
#include "kvi_error.h"
#include "kvi_debug.h"
#include "kvi_command.h"
#include "kvi_locale.h"
#include "kvi_iconmanager.h"

/*
	@doc:	progressbar
	@keyterms:
		progressbar object class,
	@title:
		progressbar class
	@type:
		class
	@short:
		Provides a horizontal progress bar.
	@inherits:
		[class]object[/class]
		[class]widget[/class]
	@description:
		This widget can be used to display a horizontal progress bar.
	@functions:
		!fn: $setProgress(<value>)
		Set the amount of steps completed.
		See also [classfnc]$settotalSteps[/classfnc]()
		!fn: $settotalSteps(<total number of steps>)
		The progress bar uses the concept of steps; you give it the total number of steps
		and the number of steps completed so far and it will display the percentage of steps that have been completed. 
		See also [classfnc]$setProgress[/classfnc]() 
		!fn: $reset()
		Reset the progress bar. 
		!fn: $setCenterIndicator(<bool>)
		Sets whether the indicator string should be centered to on.
		See also [classfnc]$isCenterIndicator[/classfnc]() 
		!fn: $isCenterIndicator
		This property holds whether the indicator string should be centered.
		See also [classfnc]$setCenterIndicator[/classfnc]() 
		!fn: $setPercentageVisible(<bool>)
		Sets whether the current progress value is displayed.
		See also [classfnc]$isPercentageVisible[/classfnc]() 
		!fn: $ispercentageVisible()
		This property holds whether the current progress value is displayed.
		See also [classfnc]$setPercentageVisible[/classfnc]() 
*/

static KviScriptObjectClass * g_pProgressbarClass = 0;

static KviScriptObject * ProgressbarClassCreateInstance(KviScriptObjectClass * c,
	KviScriptObject * p, const char * n)
{
	return new KviScriptProgressbarObject(c, p, n);
}

KviScriptProgressbarObject::KviScriptProgressbarObject(KviScriptObjectClass * c, KviScriptObject * p,
	const char *n) : KviScriptWidgetObject(c, p, n)
{
}

KviScriptProgressbarObject::~KviScriptProgressbarObject()
{
}

bool KviScriptProgressbarObject::init(KviCommand *)
{
	setObject(new QProgressBar(parentScriptWidget(), name()), true);
	((QProgressBar *)widget())->setCenterIndicator(0);
	return true;
}

#define progressbarFuncReg(__nam, __func) \
	g_pProgressbarClass->registerFunctionHandler(__nam, \
	(KviScriptObjectFunctionHandlerProc)(KVI_PTR2MEMBER(KviScriptProgressbarObject::__func)), \
	0, true);

void KviScriptProgressbarObject::registerSelf()
{
	KviScriptObjectClass * base = g_pScriptObjectController-> \
		lookupClass("widget");
	__range_valid(base);

	g_pProgressbarClass = new KviScriptObjectClass(base, "progressbar",
		ProgressbarClassCreateInstance, true);

	progressbarFuncReg("setProgress", functionsetProgress);
	progressbarFuncReg("setTotalSteps", functionsettotalSteps);
	progressbarFuncReg("reset", functionReset);
	progressbarFuncReg("setCenterIndicator", functionsetCenterIndicator);
	progressbarFuncReg("setPercentageVisible", functionsetPercentageVisible);
	progressbarFuncReg("isCenterIndicator", functioncenterIndicator);
	progressbarFuncReg("isPercentageVisible", functionpercentageVisible);

}

void KviScriptProgressbarObject::unregisterSelf()
{
	delete g_pProgressbarClass;
    g_pProgressbarClass = 0;
}

bool KviScriptProgressbarObject::functionsetProgress(KviCommand *c,KviParameterList * params,KviStr &buffer)
{
	ENTER_STACK_FRAME(c,"progressbar::setProgress");

	KviStr * pVal = params->safeFirst();

	bool bOk;
	unsigned int uProg = pVal->toUInt(&bOk);
	if(!bOk)
	{
		c->warning(__tr("Invalid progress value (%s)"),pVal->ptr());
		return c->leaveStackFrame();
	}

	((QProgressBar *)object())->setProgress(uProg);

	return c->leaveStackFrame();
}

bool KviScriptProgressbarObject::functionsettotalSteps(KviCommand *c,KviParameterList * params,KviStr &buffer)
{
	ENTER_STACK_FRAME(c,"progressbar::settotalSteps");

	KviStr * pVal = params->safeFirst();

	bool bOk;
	unsigned int uStep = pVal->toUInt(&bOk);
	if(!bOk)
	{
		c->warning(__tr("Invalid progress value (%s)"),pVal->ptr());
		return c->leaveStackFrame();
	}

	((QProgressBar *)object())->setTotalSteps(uStep);

	return c->leaveStackFrame();
}
bool KviScriptProgressbarObject::functionReset(KviCommand * c,KviParameterList * params, 
	KviStr & buffer)
{
	if(widget())
	    ((QProgressBar *)widget())->reset();
	return true;
}
bool KviScriptProgressbarObject::functionsetCenterIndicator(KviCommand *,KviParameterList * p,
	KviStr &)
{
	if(widget())
	{
		((QProgressBar *)widget())->setCenterIndicator(p->getBool());
	}
	return true;
}


bool KviScriptProgressbarObject::functioncenterIndicator(KviCommand *,KviParameterList * p,
	KviStr &b)
{

	if(widget())
	    b.append(((QProgressBar *) widget())->centerIndicator() ? '1' : '0');
	return true;
}

bool KviScriptProgressbarObject::functionsetPercentageVisible(KviCommand *,KviParameterList * p,
	KviStr &)
{
	if(widget())
	{
		((QProgressBar *)widget())->setPercentageVisible(p->getBool());
	}
	return true;
}
bool KviScriptProgressbarObject::functionpercentageVisible(KviCommand *,KviParameterList * p,
	KviStr &b)
{

	if(widget())
	    b.append(((QProgressBar *) widget())->percentageVisible() ? '1' : '0');
	return true;
}

#include "m_class_progressbar.moc"
