#ifndef	_CLASS_SLIDER_H_
#define	_CLASS_SLIDER_H_
//mdm:
//   File : class_Slider.h
//   Creation date : Mon Gen 27 14:30:48 CEST 2005 
//	 by Tonino Imbesi(Grifisx) and Alessandro Carbone(Noldor)
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
#include <qslider.h>
#include "class_widget.h"

class KviScriptSliderObject : public KviScriptWidgetObject
{
	Q_OBJECT
public:
	KviScriptSliderObject(KviScriptObjectClass * c, KviScriptObject * p, 
		const char * n);
	virtual ~KviScriptSliderObject();

	static void registerSelf();
	static void unregisterSelf();

protected:
	virtual bool init(KviCommand *);

	bool functionsetOrientation(KviCommand *, KviParameterList *, KviStr &);
	bool functionsetValue(KviCommand *, KviParameterList *, KviStr &);
	bool functionsetTracking(KviCommand *, KviParameterList *, KviStr &);
	bool functionsetMinValue(KviCommand *, KviParameterList *, KviStr &);
	bool functionsetMaxValue(KviCommand *, KviParameterList *, KviStr &);
	bool functionsetLineStep(KviCommand *, KviParameterList *, KviStr &);
	bool functionsetPageStep(KviCommand *, KviParameterList * ,KviStr &);
	bool functionValue(KviCommand *, KviParameterList * ,KviStr &);
	bool functionminValue(KviCommand *, KviParameterList * ,KviStr &);
	bool functionmaxValue(KviCommand *, KviParameterList * ,KviStr &);
	bool functionlineStep(KviCommand *, KviParameterList * ,KviStr &);
	bool functionpageStep(KviCommand *, KviParameterList * ,KviStr &);
	bool functionsetTickmarks(KviCommand *, KviParameterList * ,KviStr &);
	bool functionsetTickInterval(KviCommand *, KviParameterList * ,KviStr &);
	bool functionvalueChangedEvent(KviCommand *, KviParameterList * ,KviStr &);

protected slots:
	void valueChanged(int);
};

#endif	// !_CLASS_SLIDER_H_

