//
//   File : class_string.cpp
//   Creation date : Sun Jul 01 2001 17:01:12 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
#define _KVI_DEBUG_CHECK_RANGE_
#include "kvi_debug.h"
#include "kvi_command.h"
//#include "kvi_malloc.h"
#include "kvi_locale.h"

#include "class_string.h"

#include <stdlib.h>

static KviScriptObjectClass * g_pStringClass = 0;

static KviScriptObject * stringClassCreateInstance(KviScriptObjectClass * cls,KviScriptObject *par,const char * nam)
{
	return new KviScriptStringObject(cls,par,nam);
}

KviScriptStringObject::KviScriptStringObject(KviScriptObjectClass * cla,KviScriptObject * par,const char * nam)
: KviScriptObject(cla,par,nam)
{
}

KviScriptStringObject::~KviScriptStringObject()
{
}

/*
	@doc: string
	@keyterms:
		string object class
	@title:
		string class
	@type:
		class
	@short:
		A powerful string object class
	@inherits:
		[class]object[/class]
	@description:

	@functions:

*/


#define REG_FH(__name,__func) \
	g_pStringClass->registerFunctionHandler(__name,(KviScriptObjectFunctionHandlerProc)(KVI_PTR2MEMBER(KviScriptStringObject::__func)),0,true)


void KviScriptStringObject::registerSelf()
{
	KviScriptObjectClass * base = g_pScriptObjectController->lookupClass("object");
	__range_valid(base);
	g_pStringClass = new KviScriptObjectClass(base,"string",stringClassCreateInstance,true);

	REG_FH("length",functionLength);
	REG_FH("len",functionLength);
	REG_FH("setData",functionSetData);
	REG_FH("data",functionData);
	REG_FH("left",functionLeft);
	REG_FH("right",functionRight);
	REG_FH("middle",functionMiddle);
	REG_FH("cutLeft",functionCutLeft);
	REG_FH("cutRight",functionCutRight);
	REG_FH("cut",functionCut);
	REG_FH("toUpper",functionToUpper);
	REG_FH("toLower",functionToLower);
	REG_FH("isEmpty",functionIsEmpty);
	REG_FH("hasData",functionHasData);
	REG_FH("hasNonWhiteSpaceData",functionHasNonWhiteSpaceData);
}

#undef REG_FH

void KviScriptStringObject::unregisterSelf()
{
	delete g_pStringClass; // this will delete all the objects of this class
}

bool KviScriptStringObject::functionLength(KviCommand *c,KviParameterList *,KviStr &buffer)
{
	buffer.append(KviStr::Format,"%d",m_szData.len());
	return true;
}

bool KviScriptStringObject::functionIsEmpty(KviCommand *c,KviParameterList *,KviStr &buffer)
{
	buffer.append(m_szData.isEmpty() ? '1' : '0');
	return true;
}

bool KviScriptStringObject::functionHasData(KviCommand *c,KviParameterList *,KviStr &buffer)
{
	buffer.append(m_szData.hasData() ? '1' : '0');
	return true;
}

bool KviScriptStringObject::functionHasNonWhiteSpaceData(KviCommand *c,KviParameterList *,KviStr &buffer)
{
	buffer.append(m_szData.hasNonWhiteSpaceData() ? '1' : '0');
	return true;
}

bool KviScriptStringObject::functionToUpper(KviCommand *c,KviParameterList *,KviStr &)
{
	m_szData.toUpper();
	return true;
}

bool KviScriptStringObject::functionToLower(KviCommand *c,KviParameterList *,KviStr &)
{
	m_szData.toLower();
	return true;
}

bool KviScriptStringObject::functionSetData(KviCommand *c,KviParameterList * params,KviStr &buffer)
{
	KviStr * pF = params->first();
	if(pF)m_szData = *pF;
	else m_szData = "";
	return true;
}

bool KviScriptStringObject::functionData(KviCommand *c,KviParameterList *,KviStr &buffer)
{
	buffer.append(m_szData);
	return true;
}

bool KviScriptStringObject::functionLeft(KviCommand *c,KviParameterList * params,KviStr &buffer)
{
	ENTER_STACK_FRAME(c,"string::left");
	bool bOk;
	int i = params->getInt(&bOk);
	if(!bOk || (i < 0))c->warning(__tr("Non-negative integer length expected as parameter"));
	else {
		if(i > m_szData.len())i = m_szData.len();
		buffer.append(m_szData.ptr(),i);
	}
	return c->leaveStackFrame();
}

bool KviScriptStringObject::functionRight(KviCommand *c,KviParameterList * params,KviStr &buffer)
{
	ENTER_STACK_FRAME(c,"string::right");
	bool bOk;
	int i = params->getInt(&bOk);
	if(!bOk || (i < 0))c->warning(__tr("Non-negative integer length expected as parameter"));
	else {
		if(i > m_szData.len())i = 0;
		else i = m_szData.len() - i;
		
		buffer.append(m_szData.ptr() + i);
	}
	return c->leaveStackFrame();
}

bool KviScriptStringObject::functionMiddle(KviCommand *c,KviParameterList *params,KviStr &buffer)
{
	ENTER_STACK_FRAME(c,"string::middle");
	bool bOk;
	int i = params->getInt(&bOk);
	if(!bOk || (i < 0))c->warning(__tr("Non-negative integer index expected as first parameter"));
	else {
		int i2 = params->getInt(&bOk);
		if(!bOk || (i2 < 0))c->warning(__tr("Non-negative integer length expected as second parameter"));
		else {
			if(i > m_szData.len())i = m_szData.len();
			if((i + i2) > m_szData.len())i2 = m_szData.len() - i;
			buffer.append(m_szData.ptr() + i,i2);
		}
	}
	return c->leaveStackFrame();
}

bool KviScriptStringObject::functionCutLeft(KviCommand *c,KviParameterList * params,KviStr &)
{
	ENTER_STACK_FRAME(c,"string::cutLeft");
	bool bOk;
	int i = params->getInt(&bOk);
	if(!bOk || (i < 0))c->warning(__tr("Non-negative integer length expected as parameter"));
	else m_szData.cutLeft(i);
	return c->leaveStackFrame();
}

bool KviScriptStringObject::functionCutRight(KviCommand *c,KviParameterList * params,KviStr &)
{
	ENTER_STACK_FRAME(c,"string::cutRight");
	bool bOk;
	int i = params->getInt(&bOk);
	if(!bOk || (i < 0))c->warning(__tr("Non-negative integer length expected as parameter"));
	else m_szData.cutRight(i);
	return c->leaveStackFrame();
}

bool KviScriptStringObject::functionCut(KviCommand *c,KviParameterList *params,KviStr &)
{
	ENTER_STACK_FRAME(c,"string::cut");
	bool bOk;
	int i = params->getInt(&bOk);
	if(!bOk || (i < 0))c->warning(__tr("Non-negative integer index expected as first parameter"));
	else {
		int i2 = params->getInt(&bOk);
		if(!bOk || (i2 < 0))c->warning(__tr("Non-negative integer length expected as second parameter"));
		else m_szData.cut(i,i2);
	}
	return c->leaveStackFrame();
}

//#warning "Finish the string class!"

#include "m_class_string.moc"
