#ifndef	_CLASS_WORKSPACE_H_
#define	_CLASS_WORKSPACE_H_
//mdm:
//   File : class_workspace.h
//   Creation date : Sat Feb 12 23:05:58 CEST 2005
//   by Tonino Imbesi(Grifisx) and Alessandro Carbone(Noldor)
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2005 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//




#include <qworkspace.h>
#include "class_widget.h"

class KviScriptWorkSpaceObject : public KviScriptWidgetObject
{
	Q_OBJECT
public:
	KviScriptWorkSpaceObject(KviScriptObjectClass * c, KviScriptObject * p, 
		const char * n);
	virtual ~KviScriptWorkSpaceObject();

	static void registerSelf();
	static void unregisterSelf();

protected:
	virtual bool init(KviCommand *);

	bool functionactiveWindow(KviCommand *, KviParameterList *, KviStr &);
	bool functionscrollBarsEnabled(KviCommand *, KviParameterList *, KviStr &);
	bool functionsetscrollBarsEnabled(KviCommand *, KviParameterList *, KviStr &);
	bool functioncascade(KviCommand *, KviParameterList *, KviStr &);;
	bool functiontile(KviCommand *, KviParameterList *, KviStr &);
	bool functioncloseActiveWindow(KviCommand *, KviParameterList *, KviStr &);
	bool functioncloseAllWindows(KviCommand *, KviParameterList *, KviStr &);
	bool functionactivateNextWindow(KviCommand *, KviParameterList *, KviStr &);
	bool functionactivatePrevWindow(KviCommand *, KviParameterList *, KviStr &);
};

#endif	//!_CLASS_WORKSPACE_H_
