//
//   File : libkviobjects.cpp
//   Creation date : Wed Sep 09 2000 20:59:01 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_module.h"

#include "class_button.h"
#include "class_checkbox.h"
#include "class_urllabel.h"
#include "class_lineedit.h"
#include "class_multilineedit.h"
#include "class_combobox.h"
#include "class_widget.h"
#include "class_list.h"
#include "class_file.h"
#include "class_string.h"
#include "class_socket.h"
#include "class_layout.h"
#include "class_menubar.h"
#include "class_window.h"
#include "class_listbox.h"
#include "class_progressbar.h"
#include "class_slider.h"
#include "class_spinbox.h"
#include "class_lcd.h"
#include "class_radiobutton.h"
#include "class_process.h"
#include "class_groupbox.h"
#include "class_tabwidget.h"
#include "class_workspace.h"
#include "class_popupmenu.h"

static bool objects_module_init(KviModule * m)
{
	KviScriptListObject::registerSelf();
	KviScriptFileObject::registerSelf();
	KviScriptStringObject::registerSelf();
	KviScriptSocketObject::registerSelf();

	KviScriptWidgetObject::registerSelf();
	// add new widget-inherited objects here. NOT before the previous line ;)

	KviScriptButtonObject::registerSelf();
	KviScriptCheckBoxObject::registerSelf(); // must be after button !

	KviScriptLabelObject::registerSelf();
	KviScriptUrlLabelObject::registerSelf();
	KviScriptLineEditObject::registerSelf();
	KviScriptMLEditObject::registerSelf();
	KviScriptComboBoxObject::registerSelf();
	KviScriptListBoxObject::registerSelf();
	KviScriptProgressbarObject::registerSelf();
	KviScriptMenuBarObject::registerSelf();
	KviScriptSpinboxObject::registerSelf();
	KviScriptSliderObject::registerSelf();
	KviScriptLcdObject::registerSelf();
	KviScriptRadioButtonObject::registerSelf();
	KviScriptProcessObject::registerSelf();
	KviScriptGroupBoxObject::registerSelf();
	KviScriptTabWidgetObject::registerSelf();
	KviScriptWorkSpaceObject::registerSelf();
	KviScriptPopupMenuObject::registerSelf();

	KviScriptWindowObject::registerSelf();

	KviScriptLayoutObject::registerSelf();

	return true;
}

static bool objects_module_cleanup(KviModule *m)
{
	// DEREGISTRATION MUST BE IN THE INVERSE ORDER!
	KviScriptLayoutObject::unregisterSelf();

	KviScriptWindowObject::unregisterSelf();

	KviScriptPopupMenuObject::unregisterSelf();
	KviScriptWorkSpaceObject::unregisterSelf();
	KviScriptTabWidgetObject::unregisterSelf();
	KviScriptGroupBoxObject::unregisterSelf();
	KviScriptProcessObject::unregisterSelf();
	KviScriptRadioButtonObject::unregisterSelf();
	KviScriptLcdObject::unregisterSelf();
	KviScriptSliderObject::unregisterSelf();
	KviScriptSpinboxObject::unregisterSelf();
	KviScriptMenuBarObject::unregisterSelf();
	KviScriptProgressbarObject::unregisterSelf();
	KviScriptListBoxObject::unregisterSelf();
	KviScriptComboBoxObject::unregisterSelf();
	KviScriptMLEditObject::unregisterSelf();
	KviScriptLineEditObject::unregisterSelf();
	KviScriptUrlLabelObject::unregisterSelf();
	KviScriptLabelObject::unregisterSelf();
	KviScriptCheckBoxObject::unregisterSelf();
	KviScriptButtonObject::unregisterSelf();
	
	KviScriptWidgetObject::unregisterSelf();

	KviScriptFileObject::unregisterSelf();
	KviScriptListObject::unregisterSelf();
	KviScriptStringObject::unregisterSelf();
	KviScriptSocketObject::unregisterSelf();

	m->unregisterMetaObject("KviScriptMenuBarObject");
	m->unregisterMetaObject("KviScriptWindowObject");
	m->unregisterMetaObject("KviScriptCheckBoxObject");
	m->unregisterMetaObject("KviScriptButtonObject");
	m->unregisterMetaObject("KviScriptLabelObject");
	m->unregisterMetaObject("KviScriptUrlLabelObject");
	m->unregisterMetaObject("KviScriptLineEditObject");
	m->unregisterMetaObject("KviScriptMLEditObject");
	m->unregisterMetaObject("KviScriptComboBoxObject");
	m->unregisterMetaObject("KviScriptListBoxObject");
	m->unregisterMetaObject("KviScriptWidgetObject");
	m->unregisterMetaObject("KviScriptFileObject");
	m->unregisterMetaObject("KviScriptListObject");
	m->unregisterMetaObject("KviScriptStringObject");
	m->unregisterMetaObject("KviScriptSocketObject");
	m->unregisterMetaObject("KviScriptLayoutObject");
	m->unregisterMetaObject("KviScriptProgressbarObject");
	m->unregisterMetaObject("KviScriptLcdObject");
	m->unregisterMetaObject("KviScriptRadioButtonObject");
	m->unregisterMetaObject("KviScriptProcessObject");
	m->unregisterMetaObject("KviScriptGroupBoxObject");
	m->unregisterMetaObject("KviScriptTabWidgetObject");
	m->unregisterMetaObject("KviScriptWorkspaceObject");
	m->unregisterMetaObject("KviScriptPopupMenuObject");
	return true;
}

static bool objects_module_can_unload(KviModule *)
{
	// Actually this object remains locked in memory
	// FIXME: unlock when no more instances & derived classes!
	return false;
}

KVIRC_MODULE(
	"Objects",
	"1.0.0",
	"Copyright (C) 2000-2004:\n" \
		"  Szymon Stefanek (pragma at kvirc dot net)\n" \
		"  Krzysztof Godlewski (kristoff at poczta dot wprost dot pl)\n" \
		"  Tonino Imbesi (grifisx at barmes dot org)\n" \
		"  Alessandro Carbone (noldor at barmes dot org)",
	"Object classes for KVIrc scripting language\n",
	objects_module_init,
	objects_module_can_unload,
	0,
	objects_module_cleanup
)
