//
//   File : dlg_options.cpp
//   Creation date : Tue Jun 11 2000 02:42:21 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2000 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "dlg_options.h"

#include "kvi_app.h"
#include "kvi_options.h"
#include "kvi_locale.h"
#include "kvi_iconmanager.h"
#include "kvi_module.h"

#include <qlayout.h>
#include <qlabel.h>
#include <qvbox.h>
#include <qsplitter.h>
#include <qwidgetstack.h>
#include <qpushbutton.h>
#include <qtooltip.h>
#include <qheader.h>

//extern KviModule * g_pOptionsModule;
extern KviGeneralOptionsDialog * g_pGeneralOptionsDialog;

extern KVIRC_API KviApp * g_pApp;
extern KviOptionsInstanceManager * g_pOptionsInstanceManager;

KviGeneralOptionsFrontWidget::KviGeneralOptionsFrontWidget(QWidget *parent)
:KviOptionsWidget(parent,"general_options_front_widget")
{
	createLayout(1,1);
#ifdef COMPILE_INFO_TIPS
	QLabel * l = new QLabel(__tr2qs(
					"<table width=\"100%\"><tr><td bgcolor=\"#303030\">" \
					"<center><h1><font color=\"#FFFFFF\">General Preferences</font></h1></center>" \
					"</td></tr><tr><td><br><br>" \
					"<center><b>These sections contain various settings for KVIrc</b></center><br><br>" \
					"<p>When you have finished, click \"<b>OK</b>\" to accept your changes " \
					"or \"<b>Cancel</b>\" to discard them. Clicking \"<b>Apply</b>\" will commit your " \
					"changes without closing the window." \
					"</td></tr><tr><td>" \
					"Many settings have tooltips that can be shown " \
					"by holding the cursor over their label for a few seconds." \
					"</p></td></tr></table>" \
				),this);
#else
	QLabel * l = new QLabel(__tr2qs(
					"<table width=\"100%\"><tr><td bgcolor=\"#303030\">" \
					"<center><h1><font color=\"#FFFFFF\">General Preferences</font></h1></center>" \
					"</td></tr><tr><td><br><br>" \
					"Select a category in the list view on the left " \
					"to view the related settings. " \
					"When you have finished, click \"<b>OK</b>\" to accept your changes " \
					"or \"<b>Cancel</b>\" to discard them. Clicking \"<b>Apply</b>\" will commit your " \
					"changes without closing this window.<br><br>" \
					"</td></tr></table>" \
				),this);
#endif
//	l->setAlignment(AlignCenter);
	layout()->addWidget(l,0,0);
}

KviGeneralOptionsFrontWidget::~KviGeneralOptionsFrontWidget()
{
}




KviGeneralOptionsListViewItem::KviGeneralOptionsListViewItem(QListView *parent,KviOptionsWidgetInstanceEntry * e)
:QListViewItem(parent,e->szName)
{
	m_pInstanceEntry = e;
	m_pOptionsWidget = 0;
	setPixmap(0,*(g_pIconManager->getSmallIcon(e->iIcon)));
}

KviGeneralOptionsListViewItem::KviGeneralOptionsListViewItem(QListViewItem *parent,KviOptionsWidgetInstanceEntry * e)
:QListViewItem(parent,e->szName)
{
	m_pInstanceEntry = e;
	m_pOptionsWidget = 0;
	setPixmap(0,*(g_pIconManager->getSmallIcon(e->iIcon)));
}

KviGeneralOptionsListViewItem::~KviGeneralOptionsListViewItem()
{
}


KviGeneralOptionsDialog::KviGeneralOptionsDialog(QWidget * par)
: QDialog(par,"general_options_dialog")
{
	setCaption(__tr2qs("Preferences - KVIrc"));
	setIcon(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_KVIRC)));

	QGridLayout * g1 = new QGridLayout(this,2,4,8,8);
	QSplitter * spl = new QSplitter(QSplitter::Horizontal,this);

	g1->addMultiCellWidget(spl,0,0,0,3);

	// Controlling list view
	m_pListView = new QListView(spl);
	m_pListView->addColumn("");
	m_pListView->header()->hide();
	m_pListView->setRootIsDecorated(true);
	m_pListView->setSorting(-1);
	connect(m_pListView,SIGNAL(selectionChanged(QListViewItem *)),this,SLOT(listViewItemSelectionChanged(QListViewItem *)));


	QVBox * vbox = new QVBox(spl);
	vbox->setSpacing(2);
	vbox->setMargin(3);

	m_pCategoryLabel = new QLabel("<b>" + __tr2qs("General Preferences") + "</b>",vbox);
	//m_pCategoryLabel->setMargin(3);

	QFrame * f = new QFrame(vbox);
	f->setFrameStyle(QFrame::HLine | QFrame::Sunken);

	// Widget stack
	m_pWidgetStack = new QWidgetStack(vbox);
	vbox->setStretchFactor(m_pWidgetStack,1);

	// First widget visible
	KviGeneralOptionsFrontWidget *w = new KviGeneralOptionsFrontWidget(m_pWidgetStack);
	m_pWidgetStack->addWidget(w,0);
	m_pWidgetStack->raiseWidget(w);

	// Ok,Cancel,Help
//	QPushButton * b = new QPushButton(__tr2qs("What's This?"),this);
//	connect(b,SIGNAL(clicked()),g_pApp,SLOT(slot_whatIsThisRequest()));
//	int whatIsThisWidth = b->sizeHint().width();
//	g1->addWidget(b,1,0);

	QPushButton * b = new QPushButton(__tr2qs("&OK"),this);
	QToolTip::add(b,__tr2qs("Close this dialog, accepting all changes."));
	connect(b,SIGNAL(clicked()),this,SLOT(okClicked()));
	//b->setMinimumWidth(whatIsThisWidth);
	b->setIconSet(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_ACCEPT)));
	g1->addWidget(b,1,1);	

	b = new QPushButton(__tr2qs("&Apply"),this);
	QToolTip::add(b,__tr2qs("Commit all changes immediately."));
	//b->setMinimumWidth(whatIsThisWidth);
	connect(b,SIGNAL(clicked()),this,SLOT(applyClicked()));
	b->setIconSet(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_ACCEPT)));
	g1->addWidget(b,1,2);

	b = new QPushButton(__tr2qs("Cancel"),this);
	QToolTip::add(b,__tr2qs("Close this dialog, discarding all changes."));
	b->setDefault(true);
	//b->setMinimumWidth(whatIsThisWidth);
	connect(b,SIGNAL(clicked()),this,SLOT(cancelClicked()));
	b->setIconSet(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_DISCARD)));
	g1->addWidget(b,1,3);

	g1->setRowStretch(0,1);
	g1->setColStretch(0,1);


	fillListView(0,g_pOptionsInstanceManager->instanceEntryTree());


	if(!parent())
	{

		if(KVI_OPTION_RECT(KviOption_rectGeneralOptionsDialogGeometry).y() < 5)
		{
			KVI_OPTION_RECT(KviOption_rectGeneralOptionsDialogGeometry).setY(5);
		}
		//setGeometry(KVI_OPTION_RECT(KviOption_rectGeneralOptionsDialogGeometry));
		resize(KVI_OPTION_RECT(KviOption_rectGeneralOptionsDialogGeometry).width(),
			KVI_OPTION_RECT(KviOption_rectGeneralOptionsDialogGeometry).height());
		move(KVI_OPTION_RECT(KviOption_rectGeneralOptionsDialogGeometry).x(),
			KVI_OPTION_RECT(KviOption_rectGeneralOptionsDialogGeometry).y());
	}
}

KviGeneralOptionsDialog::~KviGeneralOptionsDialog()
{
	if(!parent())KVI_OPTION_RECT(KviOption_rectGeneralOptionsDialogGeometry) = QRect(pos().x(),pos().y(),
			size().width(),size().height());
	g_pGeneralOptionsDialog = 0;
//	g_pOptionsModule->unlock();
}

void KviGeneralOptionsDialog::fillListView(QListViewItem * p,KviPtrList<KviOptionsWidgetInstanceEntry> * l)
{
	if(!l)return;

	KviGeneralOptionsListViewItem * it;
	KviOptionsWidgetInstanceEntry * e;

	KviPtrList<KviOptionsWidgetInstanceEntry> tmp;
	tmp.setAutoDelete(false);

	for(e = l->first();e;e = l->next())
	{
		KviOptionsWidgetInstanceEntry * ee = tmp.first();
		int idx = 0;
		while(ee)
		{
			if(ee->iPriority >= e->iPriority)break;
			idx++;
			ee = tmp.next();
		}
		tmp.insert(idx,e);
	}

	for(e = tmp.first();e;e = tmp.next())
	{
		if(p)it = new KviGeneralOptionsListViewItem(p,e);
		else it = new KviGeneralOptionsListViewItem(m_pListView,e);
		if(e->pChildList)fillListView(it,e->pChildList);
	}
}

void KviGeneralOptionsDialog::listViewItemSelectionChanged(QListViewItem *it)
{
	if(it)
	{
		QString str = it->text(0);
		QListViewItem * par = it->parent();

		while(par)
		{
			str.prepend(" :: ");
			str.prepend(par->text(0));
			par = par->parent();
		}
		str.prepend("<b>");
		str += "</b>";

		KviGeneralOptionsListViewItem *i = (KviGeneralOptionsListViewItem *)it;
		if(!i->m_pOptionsWidget)
		{
			i->m_pOptionsWidget = g_pOptionsInstanceManager->getInstance(i->m_pInstanceEntry,m_pWidgetStack);
			m_pWidgetStack->addWidget(i->m_pOptionsWidget,0);
		}

		m_pWidgetStack->raiseWidget(i->m_pOptionsWidget);
		m_pCategoryLabel->setText(str);
	}
}

void KviGeneralOptionsDialog::applyClicked()
{
	apply(false);
}

void KviGeneralOptionsDialog::apply(bool bDialogAboutToClose)
{
	KviGeneralOptionsListViewItem *it = (KviGeneralOptionsListViewItem *)m_pListView->firstChild();
	while(it)
	{
		recursiveCommit(it);
		it = (KviGeneralOptionsListViewItem *)it->nextSibling();
	}
	
	if(!bDialogAboutToClose)
	{
		// bring up the current widget again!
		it = (KviGeneralOptionsListViewItem *)m_pListView->currentItem();
		if(it)listViewItemSelectionChanged(it);
	}

	g_pApp->saveConfiguration();
}

void KviGeneralOptionsDialog::okClicked()
{
	apply(true);
	delete this;
}

void KviGeneralOptionsDialog::cancelClicked()
{
	delete this;
}

void KviGeneralOptionsDialog::closeEvent(QCloseEvent *e)
{
	e->ignore();
	delete this;
}

void KviGeneralOptionsDialog::recursiveCommit(KviGeneralOptionsListViewItem *it)
{
	// First commit the children
	KviGeneralOptionsListViewItem *it2 = (KviGeneralOptionsListViewItem *)it->firstChild();
	while(it2)
	{
		recursiveCommit(it2);
		it2 = (KviGeneralOptionsListViewItem *)it2->nextSibling();
	}
	// then the parents
	if(it->m_pOptionsWidget)
	{
		it->m_pOptionsWidget->commit();
		delete it->m_pOptionsWidget;
		it->m_pOptionsWidget = 0;
	}
}

#include "m_dlg_options.moc"
