#ifndef _DLG_OPTIONS_H_
#define _DLG_OPTIONS_H_

//
//   File : dlg_options.h
//   Creation date : Tue Jun 11 2000 02:39:12 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2000 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include <qdialog.h>
#include <qlistview.h>
#include "kvi_optionswidget.h"

#include "instances.h"

class QLabel;
class QWidgetStack;

class KviGeneralOptionsFrontWidget : public KviOptionsWidget
{
	Q_OBJECT
public:
	KviGeneralOptionsFrontWidget(QWidget *parent);
	~KviGeneralOptionsFrontWidget();
};

class KviGeneralOptionsListViewItem : public QListViewItem
{
public:
	KviGeneralOptionsListViewItem(QListView *parent,KviOptionsWidgetInstanceEntry * e);
	KviGeneralOptionsListViewItem(QListViewItem *parent,KviOptionsWidgetInstanceEntry * e);
	~KviGeneralOptionsListViewItem();
public:
	KviOptionsWidgetInstanceEntry * m_pInstanceEntry;
	KviOptionsWidget              * m_pOptionsWidget;
};

class KviGeneralOptionsDialog : public QDialog
{
	Q_OBJECT
public:
	KviGeneralOptionsDialog(QWidget * par = 0); 
	~KviGeneralOptionsDialog();
private:
	QListView    * m_pListView;
	QLabel       * m_pCategoryLabel;
	QWidgetStack * m_pWidgetStack;
private:
	void recursiveCommit(KviGeneralOptionsListViewItem *it);
	void fillListView(QListViewItem * p,KviPtrList<KviOptionsWidgetInstanceEntry> * l);
private slots:
	void listViewItemSelectionChanged(QListViewItem *it);
	void applyClicked();
	void okClicked();
	void cancelClicked();
protected:
	void apply(bool bDialogAboutToClose);
	virtual void closeEvent(QCloseEvent *e);
};

#endif //!_DLG_OPTIONS_H_
