//=============================================================================
//
//   File : optw_connection.cpp
//   Creation date : Sat Nov 24 04:25:16 2001 GMT by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//=============================================================================

#include "optw_connection.h"

#include "kvi_settings.h"
#include "kvi_locale.h"
#include "kvi_options.h"


KviConnectionOptionsWidget::KviConnectionOptionsWidget(QWidget * parent)
: KviOptionsWidget(parent,"connection_options_widget")
{

	createLayout(2,1);
	QGroupBox * gbox = addGroupBox(0,0,0,0,1,QGroupBox::Horizontal,__tr2qs("On Unexpected Disconnect" ));
	KviBoolSelector * b = addBoolSelector(gbox,__tr2qs("Automatically reconnect"),KviOption_boolAutoReconnectOnUnexpectedDisconnect);
#ifdef COMPILE_INFO_TIPS
	mergeTip(b,__tr2qs("<center>This option will enable auto-reconnecting after an unexpected disconnect. " \
						"An unexpected disconnect is the <b>termination</b> of a <b>fully connected IRC session</b> " \
						"that was <b>not requested by the user</b> by the means of the QUIT message." \
						"<p><b>Warning:</b> If you use /RAW to send a QUIT message to the server, " \
						"this option will not behave correctly, since does not detect the outgoing " \
						"QUIT message and will attempt to reconnect after the server has closed the connection. " \
						"For this reason, always use the /QUIT command to close your connections. " \
						"This option may also behave incorrectly with bouncers that support " \
						"detaching, in this case a solution could be to prepare an alias that sends the " \
						"bouncer \"detach\" command immediately before the \"quit\" command.<br>" \
						"<tt>alias(bncdetach){ raw bouncer detach; quit; }</tt></p></center>"));
#endif
	KviUIntSelector * u = addUIntSelector(gbox,__tr2qs("Maximum attempts (0: unlimited):"),
			KviOption_uintMaxAutoReconnectAttempts,0,100,5,
			KVI_OPTION_BOOL(KviOption_boolAutoReconnectOnUnexpectedDisconnect));
	connect(b,SIGNAL(toggled(bool)),u,SLOT(setEnabled(bool)));

	u = addUIntSelector(gbox,__tr2qs("Delay between attempts:"),
			KviOption_uintAutoReconnectDelay,0,86400,5,
			KVI_OPTION_BOOL(KviOption_boolAutoReconnectOnUnexpectedDisconnect));
	u->setSuffix(__tr2qs(" sec"));
	connect(b,SIGNAL(toggled(bool)),u,SLOT(setEnabled(bool)));
#ifdef COMPILE_INFO_TIPS
	mergeTip(u,__tr2qs("<center>Minimum value: <b>0 sec</b><br>Maximum value: <b>86400 sec</b></center>"));
#endif

	KviBoolSelector * b1 = addBoolSelector(gbox,__tr2qs("Keep channels open"),KviOption_boolKeepChannelsOpenOnUnexpectedDisconnect,KVI_OPTION_BOOL(KviOption_boolAutoReconnectOnUnexpectedDisconnect));
	connect(b,SIGNAL(toggled(bool)),b1,SLOT(setEnabled(bool)));
#ifdef COMPILE_INFO_TIPS
	mergeTip(b1,__tr2qs("<center>This option will cause KVIrc to keep channels open after an unexpected disconnect.</center>"));
#endif

	b1 = addBoolSelector(gbox,__tr2qs("Keep queries open"),KviOption_boolKeepQueriesOpenOnUnexpectedDisconnect,KVI_OPTION_BOOL(KviOption_boolAutoReconnectOnUnexpectedDisconnect));
	connect(b,SIGNAL(toggled(bool)),b1,SLOT(setEnabled(bool)));
#ifdef COMPILE_INFO_TIPS
	mergeTip(b1,__tr2qs("<center>This option will cause KVIrc to keep queries open after an unexpected disconnect.</center>"));
#endif

	b1 = addBoolSelector(gbox,__tr2qs("Rejoin channels after reconnect"),KviOption_boolRejoinChannelsAfterReconnect,KVI_OPTION_BOOL(KviOption_boolAutoReconnectOnUnexpectedDisconnect));
	connect(b,SIGNAL(toggled(bool)),b1,SLOT(setEnabled(bool)));
#ifdef COMPILE_INFO_TIPS
	mergeTip(b1,__tr2qs("<center>This option will cause KVIrc to rejoin channels after a successful reconnect attempt.</center>"));
#endif

	b1 = addBoolSelector(gbox,__tr2qs("Reopen queries after reconnect"),KviOption_boolReopenQueriesAfterReconnect,KVI_OPTION_BOOL(KviOption_boolAutoReconnectOnUnexpectedDisconnect));
	connect(b,SIGNAL(toggled(bool)),b1,SLOT(setEnabled(bool)));
#ifdef COMPILE_INFO_TIPS
	mergeTip(b1,__tr2qs("<center>This option will cause KVIrc to reopen query windows after a successful reconnect attempt.</center>"));
#endif

	addRowSpacer(0,1,0,1);
}


KviConnectionOptionsWidget::~KviConnectionOptionsWidget()
{
}


#include "m_optw_connection.moc"
