//
//   File : optw_ctcpavatarproto.cpp
//   Creation date : Sun Jan 21 2001 16:12:06 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "optw_ctcpavatarproto.h"

#include <qlayout.h>

#include "kvi_options.h"
#include "kvi_locale.h"

#include <qlabel.h>

/*
	@doc: ctcpavatarprotooptions
	@type:
		widget
	@title:
		CTCP AVATAR protocol options
	@short:
		A more visual IRC
	@keyterms:
		avatar
	@body:
		The CTCP AVATAR protocol is used to send avatar images between users.[br]
		To find out more about how avatars work, read the [doc:ctcp_avatar]AVATAR protocol specification[/doc].[br]
		The problems that arise from this protocol are related to flooding and "spam".[br]
		KVIrc attempts to protect you from these "attacks".[br]
		The flooding problem is solved by [widget:ctcpfloodprotectionoptions]CTCP flood protection[/widget].[br]
		If it is configured, CTCP AVATAR requests will be filtered.[br]
		The "spam" problem has no definite solution (just as with "common" DCC SEND or PRIVMSG "spam").[br]
		The inconvenience arises when you request missing images from the CTCP sender.[br]
		The "hard" solution is to never request missing images from other people; this can be
		set by disabling the "Request missing avatars" option.[br]
		Hard solutions are never optimal, so KVIrc also can use different strategies.[br]
		Avatar change requests are ignored for any users that do not share a channel with you
		or have a query open, which protects you from a common "spamming" technique.
		 
		
*/

//#warning "Finish this doc"

//#warning "Set current avatar as default for registered users"

KviCtcpAvatarProtoOptionsWidget::KviCtcpAvatarProtoOptionsWidget(QWidget * parent)
: KviOptionsWidget(parent,"ctcpavatarproto_options_widget")
{
	createLayout(8,1);

	KviBoolSelector * b = addBoolSelector(0,0,0,0,__tr2qs("Request missing avatars"),KviOption_boolRequestMissingAvatars);
#ifdef COMPILE_INFO_TIPS
	mergeTip(b,
		__tr2qs("<center>This option will cause KVIrc to send a DCC GET request " \
			"when someone sets an avatar and there is no cached copy available.</center>"));
#endif

	KviUIntSelector * u = addUIntSelector(0,1,0,1,__tr2qs("Maximum requested file size:"),KviOption_uintMaximumRequestedAvatarSize,0,1048576,102400,KVI_OPTION_BOOL(KviOption_boolRequestMissingAvatars));
	u->setSuffix(__tr2qs(" bytes"));
#ifdef COMPILE_INFO_TIPS
	mergeTip(u,
		__tr2qs("<center>This is the maximum size for avatar images that " \
			"will be automatically requested.<br>" \
			"A reasonable value might be 102400 bytes (100 K).</center>"));
#endif
	connect(b,SIGNAL(toggled(bool)),u,SLOT(setEnabled(bool)));

	b = addBoolSelector(0,2,0,2,__tr2qs("Automatically accept incoming avatars"),KviOption_boolAutoAcceptIncomingAvatars);
#ifdef COMPILE_INFO_TIPS
	mergeTip(
		b,
		__tr2qs("<center>This option will cause KVIrc to auto-accept " \
			"DCC SEND requests for incoming avatars.<br>" \
			"If you're using the \"Request missing avatars\" option " \
			"above, enabling this may by useful.<br>" \
			"Avatars will be saved in the local KVIrc directory.</center>"));
#endif

	b = addBoolSelector(0,3,0,3,__tr2qs("Cache avatars for registered users"),KviOption_boolSetLastAvatarAsDefaultForRegisteredUsers);

#ifdef COMPILE_INFO_TIPS
	mergeTip(
		b,
		__tr2qs("<center>Use a user's last known avatar by default " \
			"(only for users that are registered).</center>"));
#endif

	addSeparator(0,4,0,4);

	u = addUIntSelector(0,5,0,5,__tr2qs("Avatar offer timeout:"),KviOption_uintAvatarOfferTimeoutInSecs,1,99999,60);
	u->setSuffix(__tr2qs(" sec"));
#ifdef COMPILE_INFO_TIPS
	mergeTip(u,
		__tr2qs("<center>This is the amount of time to make an avatar available for transfer when requested.<br>" \
			"When someone sends a CTCP AVATAR request, " \
			"KVIrc will reply with a CTCP AVATAR message containing the name and size " \
			"of your avatar image.<br>" \
			"A time-limited file offer is added for the image file " \
			"to the requesting user.</center>"));
#endif

	b = addBoolSelector(0,6,0,6,__tr2qs("Ignore requests if no avatar is set"),KviOption_boolIgnoreChannelAvatarRequestsWhenNoAvatarSet);
#ifdef COMPILE_INFO_TIPS
	mergeTip(b,
		__tr2qs("This option will cause KVIrc to ignore channel CTCP AVATAR requests " \
			"when you have no avatar set. This is usually a good practice since " \
			"it helps in reducing traffic by not sending a reply that would be empty."));
#endif

	addRowSpacer(0,7,0,7);
}

KviCtcpAvatarProtoOptionsWidget::~KviCtcpAvatarProtoOptionsWidget()
{
}


#include "m_optw_ctcpavatarproto.moc"
