//
//   File : optw_ctcpreplies.cpp
//   Creation date : Fri Aug 23 02:42:01 2002 GMT by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2002 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//


#include "optw_ctcpreplies.h"

#include "kvi_settings.h"
#include "kvi_locale.h"
#include "kvi_options.h"



KviCtcpRepliesOptionsWidget::KviCtcpRepliesOptionsWidget(QWidget * parent)
: KviOptionsWidget(parent,"ctcpreplies_options_widget")
{

	createLayout(7,1);

	KviStringSelector * s = addStringSelector(0,0,0,0, __tr2qs("Append to VERSION reply:"),KviOption_stringCtcpVersionPostfix);

#ifdef COMPILE_INFO_TIPS
	mergeTip(s,
		__tr2qs("<center>This text will be appended to the CTCP VERSION reply.<br>For example, you can place a script name here.</center>"));
#endif

	s = addStringSelector(0,1,0,1, __tr2qs("Append to SOURCE reply:"),KviOption_stringCtcpSourcePostfix);

#ifdef COMPILE_INFO_TIPS
	mergeTip(s,
		__tr2qs("<center>This text will be appended to the CTCP SOURCE reply.<br>For example, you can place the source URL for a script here.</center>"));
#endif

	s = addStringSelector(0,2,0,2, __tr2qs("USERINFO reply:"),KviOption_stringCtcpUserinfoReply);

#ifdef COMPILE_INFO_TIPS
	mergeTip(s,
		__tr2qs("<center>This is the CTCP USERINFO reply.<br>It can contain some information about yourself.</center>"));
#endif

	s = addStringSelector(0,3,0,3, __tr2qs("PAGE reply:"),KviOption_stringCtcpPageReply);

#ifdef COMPILE_INFO_TIPS
	mergeTip(s,
		__tr2qs("<center>This is the CTCP PAGE reply.<br>It should contain some sort of acknowledgement for CTCP PAGE messages.</center>"));
#endif

	addBoolSelector(0,4,0,4,__tr2qs("Show the CTCP replies in the active window"),KviOption_boolCtcpRepliesToActiveWindow);

	addBoolSelector(0,5,0,5,__tr2qs("Show dialog for CTCP page requests"),KviOption_boolShowDialogOnCtcpPage);

	addRowSpacer(0,6,0,6);

}


KviCtcpRepliesOptionsWidget::~KviCtcpRepliesOptionsWidget()
{
}


#include "m_optw_ctcpreplies.moc"

