#ifndef _OPTW_HIGHLIGHTING_CPP_
#define _OPTW_HIGHLIGHTING_CPP_
//
//   File : optw_highlighting.cpp
//   Creation date : Sat Nov  3 18:09:35 2001 GMT by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "optw_highlighting.h"

#include <qlayout.h>

#include "kvi_options.h"
#include "kvi_locale.h"

#include <qlabel.h>


KviHighlightingOptionsWidget::KviHighlightingOptionsWidget(QWidget * parent)
: KviOptionsWidget(parent,"highlighting_options_widget")
{
	createLayout(6,1);

	KviBoolSelector * b;

	connect(
		addBoolSelector(0,0,0,0,__tr2qs("Enable word highlighting"),KviOption_boolUseWordHighlighting),
		SIGNAL(toggled(bool)),
		addStringListSelector(0,1,0,1,__tr2qs("Words to highlight:"),KviOption_stringlistHighlightWords,KVI_OPTION_BOOL(KviOption_boolUseWordHighlighting)),
		SLOT(setEnabled(bool)));
	// This can be used even without Word highlighting
	b = addBoolSelector(0,2,0,2,__tr2qs("Highlight messages containing my nickname"),KviOption_boolAlwaysHighlightNick);
#ifdef COMPILE_INFO_TIPS
	mergeTip(b,__tr2qs("<center>If this option is enabled, KVIrc will highlight any user message containing your current nickname</center>"));
#endif
	b = addBoolSelector(0,3,0,3,__tr2qs("Flash the system taskbar entry on highlighted messages"),KviOption_boolFlashWindowOnHighlightedMessages);
#ifdef COMPILE_INFO_TIPS
	mergeTip(b,__tr2qs("<center>If this option is enabled, KVIrc will (attempt to) flash the system taskbar entry when a highlighted message is printed and KVIrc is not the active window</center>"));
#endif
	b = addBoolSelector(0,4,0,4,__tr2qs("Popup the notifier window on highlighted messages"),KviOption_boolPopupNotifierOnHighlightedMessages);
#ifdef COMPILE_INFO_TIPS
	mergeTip(b,__tr2qs("<center>If this option is enabled, KVIrc will popup a little notifier window in the low right corner of your desktop when a highlighted message is printed and KVIrc is not the active window</center>"));
#endif

	QGroupBox * g = addGroupBox(0,5,0,5,1,QGroupBox::Horizontal,__tr2qs("Taskbar Alert"));
	KviBoolSelector * b3 = addBoolSelector(g,__tr2qs("Restrict alert"),KviOption_boolHighlightOnlyNormalMsg);
#ifdef COMPILE_INFO_TIPS
	mergeTip(b3, __tr2qs("<center>If this option is enabled, KVIrc will alert in the taskbar only if a normal message is received in a channel.<br>Actions like joins, parts and mode changes will be ignored.<br> This is useful if you are in channels with a high rate of traffic and only want to be alerted for messages that are interesting to you.</center>"));
#endif
	KviBoolSelector * b4 = addBoolSelector(g,__tr2qs("Alert for highlighted words"),KviOption_boolHighlightOnlyNormalMsgHighlightInChanToo,KVI_OPTION_BOOL(KviOption_boolHighlightOnlyNormalMsg));
#ifdef COMPILE_INFO_TIPS
	mergeTip(b4, __tr2qs("<center>If this option is enabled, the taskbar will also alert for messages which contain a word from the highlighted words list above.</center>"));
#endif
	KviBoolSelector * b5 = addBoolSelector(g,__tr2qs("Alert for query messages"),KviOption_boolHighlightOnlyNormalMsgQueryToo,KVI_OPTION_BOOL(KviOption_boolHighlightOnlyNormalMsg));
#ifdef COMPILE_INFO_TIPS
	mergeTip(b5, __tr2qs("<center>If this option is enabled, the taskbar will also alert for messages which are shown in queries.</center>"));
#endif
	connect(b3,SIGNAL(toggled(bool)),b4,SLOT(setEnabled(bool)));
	connect(b3,SIGNAL(toggled(bool)),b5,SLOT(setEnabled(bool)));
	KviBoolSelector * b6 = addBoolSelector(g,__tr2qs("Use custom alert level"),KviOption_boolHighlightOnlyAtCostumHighlightLevel);
#ifdef COMPILE_INFO_TIPS
	mergeTip(b6, __tr2qs("<center>If this option is enabled, KVIrc will alert in the taskbar only if the specified alert level is reached.</center>"));
#endif
	KviUIntSelector * b7 = addUIntSelector(g,__tr2qs("Minimum alert level:"),KviOption_uintMinHighlightLevel,1,KVI_MSGTYPE_MAXLEVEL,KVI_MSGTYPE_MAXLEVEL,KVI_OPTION_UINT(KviOption_boolHighlightOnlyAtCostumHighlightLevel));
	b7->setEnabled(KVI_OPTION_BOOL(KviOption_boolHighlightOnlyAtCostumHighlightLevel));
#ifdef COMPILE_INFO_TIPS
	mergeTip(b6, __tr2qs("<center>This option sets the minimum alert level for the taskbar.</center>"));
#endif
	connect(b6,SIGNAL(toggled(bool)),b7,SLOT(setEnabled(bool)));

	layout()->setRowStretch(1,1);
}

KviHighlightingOptionsWidget::~KviHighlightingOptionsWidget()
{
}


#include "m_optw_highlighting.moc"

#endif //_OPTW_HIGHLIGHTING_CPP_
