//================================================================================
//
//   File : optw_ident.cpp
//   Creation date : Mon Oct 29 15:48:42 2001 GMT by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001-2004 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//================================================================================

#include "optw_ident.h"

#include <qgroupbox.h>

#include "kvi_options.h"
#include "kvi_locale.h"
#include "kvi_settings.h"

//#warning "Info tips"


KviIdentOptionsWidget::KviIdentOptionsWidget(QWidget * parent)
: KviOptionsWidget(parent,"ident_options_widget")
{
	createLayout(5,1);

	m_pEnableIdent = addBoolSelector(0,0,0,0,__tr2qs("Enable ident service (bad practice on UNIX!)"),KviOption_boolUseIdentService);
	connect(m_pEnableIdent,SIGNAL(toggled(bool)),this,SLOT(enableIpv4InIpv6(bool)));

	QGroupBox * gbox = addGroupBox(0,1,0,1,1,QGroupBox::Horizontal,__tr2qs("Configuration"),KVI_OPTION_BOOL(KviOption_boolUseIdentService));
	
	KviStringSelector * s = addStringSelector(gbox,__tr2qs("Ident username:"),
		KviOption_stringIdentdUser,KVI_OPTION_BOOL(KviOption_boolUseIdentService));
	connect(m_pEnableIdent,SIGNAL(toggled(bool)),s,SLOT(setEnabled(bool)));
	
	KviUIntSelector * u = addUIntSelector(gbox,__tr2qs("Service port:"),
		KviOption_uintIdentdPort,0,65535,113,KVI_OPTION_BOOL(KviOption_boolUseIdentService));
	connect(m_pEnableIdent,SIGNAL(toggled(bool)),u,SLOT(setEnabled(bool)));
	connect(m_pEnableIdent,SIGNAL(toggled(bool)),gbox,SLOT(setEnabled(bool)));

	gbox = addGroupBox(0,2,0,2,1,QGroupBox::Horizontal,__tr2qs("IPv6 Settings" ),KVI_OPTION_BOOL(KviOption_boolUseIdentService));
	m_pEnableIpv6 = addBoolSelector(gbox,__tr2qs("Enable service for IPv6"),
		KviOption_boolIdentdEnableIpV6,
		KVI_OPTION_BOOL(KviOption_boolUseIdentService));
#ifdef COMPILE_IPV6_SUPPORT
	connect(m_pEnableIdent,SIGNAL(toggled(bool)),m_pEnableIpv6,SLOT(setEnabled(bool)));
	connect(m_pEnableIpv6,SIGNAL(toggled(bool)),this,SLOT(enableIpv4InIpv6(bool)));
#else
	m_pEnableIpv6->setEnabled(false);
#endif
	m_pIpv4InIpv6 = addBoolSelector(gbox,__tr2qs("IP stack treats IPv4 as part of IPv6 namespace"),
		KviOption_boolIdentdIpV6ContainsIpV4,
		KVI_OPTION_BOOL(KviOption_boolUseIdentService) && KVI_OPTION_BOOL(KviOption_boolIdentdEnableIpV6));
	connect(m_pEnableIdent,SIGNAL(toggled(bool)),gbox,SLOT(setEnabled(bool)));

	addLabel(0,3,0,3,
#ifdef COMPILE_ON_WINDOWS
			__tr2qs("<p><b>Warning:</b><br>" \
			"This is a <b>non RFC 1413 compliant</b> ident daemon that implements " \
			"only a limited subset of the Identification Protocol specifications. If it is possible, install a " \
			"real ident daemon.</p>")
#else
			__tr2qs("<p><b>Warning:</b><br>" \
			"This is a <b>non RFC 1413 compliant</b> ident daemon that implements " \
			"only a limited subset of the Identification Protocol specifications.<br>" \
			"On UNIX, you may also need root privileges to bind to the auth port (113).<br>" \
			"It is <b>highly recommended</b> that a <b>real</b> system-wide ident daemon be used instead, "\
			"or none at all if ident is not required.</p>")
#endif
	);

	addRowSpacer(0,4,0,4);
}

KviIdentOptionsWidget::~KviIdentOptionsWidget()
{
}

void KviIdentOptionsWidget::enableIpv4InIpv6(bool)
{
#ifdef COMPILE_IPV6_SUPPORT
	m_pIpv4InIpv6->setEnabled(m_pEnableIdent->isChecked() && m_pEnableIpv6->isChecked());
#endif
}

#include "m_optw_ident.moc"
