//
//   File : optw_irc.cpp
//   Creation date : Sun Dec  2 18:59:48 2001 GMT by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//


#include "optw_irc.h"

#include "kvi_settings.h"
#include "kvi_locale.h"
#include "kvi_options.h"



KviIrcOptionsWidget::KviIrcOptionsWidget(QWidget * parent)
: KviOptionsWidget(parent,"irc_options_widget")
{
	createLayout(7,1);
	KviBoolSelector *b = addBoolSelector(0,0,0,0,__tr2qs("Minimize console after successful login"),KviOption_boolMinimizeConsoleAfterConnect,KVI_OPTION_BOOL(KviOption_boolMinimizeConsoleAfterConnect));
	b->setEnabled(true);

#ifdef COMPILE_INFO_TIPS
	mergeTip(b,__tr2qs("<center>This option will cause KVIrc to minimize the console window after successfully logging into a server.</center>"));
#endif

	b = addBoolSelector(0,1,0,1,__tr2qs("Force immediate quit"),KviOption_boolForceBrutalQuit);    
#ifdef COMPILE_INFO_TIPS
	mergeTip(b,
		__tr2qs("<center>This option causes KVIrc to close " \
		"the connection immediately after sending the QUIT message.<br>" \
		"When this option is disabled, KVIrc will wait for the server " \
		"to close the connection.<br>" \
		"Note that if you use this, your QUIT message may be not displayed.</center>"));
#endif
	QGroupBox * g = addGroupBox(0,2,0,2,1,QGroupBox::Horizontal,__tr2qs("On Channel Join"));
	addBoolSelector(g,__tr2qs("Do not send /WHO request"),KviOption_boolDisableWhoRequestOnJoin);
  	addBoolSelector(g,__tr2qs("Do not request ban list"),KviOption_boolDisableBanListRequestOnJoin);
  	addBoolSelector(g,__tr2qs("Do not request ban exception list"),KviOption_boolDisableBanExceptionListRequestOnJoin);
 	addBoolSelector(g,__tr2qs("Do not request invite list"),KviOption_boolDisableInviteListRequestOnJoin);

	g = addGroupBox(0,3,0,3,1,QGroupBox::Horizontal,__tr2qs("On Channel Kick"));

	b = addBoolSelector(g,__tr2qs("Keep channel open"),KviOption_boolKeepChannelOpenOnKick);
#ifdef COMPILE_INFO_TIPS
	mergeTip(b,
		__tr2qs("<center>This option will cause KVIrc to keep " \
			"the channel window open after being kicked.<br>" \
			"It might be a good idea to also enable the " \
			"\"Rejoin channel\" option.</center>"));
#endif 

 	b = addBoolSelector(g,__tr2qs("Rejoin channel"),KviOption_boolRejoinChannelOnKick);
#ifdef COMPILE_INFO_TIPS
	mergeTip(b,
		__tr2qs("<center>This option will cause KVIrc to attempt " \
		"to rejoin a channel after being kicked.</center>"));
#endif

	g = addGroupBox(0,4,0,4,1,QGroupBox::Horizontal,__tr2qs("On Channel Part"));

	b = addBoolSelector(g,__tr2qs("Keep channel open"),KviOption_boolKeepChannelOpenOnPart);
#ifdef COMPILE_INFO_TIPS
	mergeTip(b,
		__tr2qs("<center>This option will cause KVIrc to keep " \
			"the channel window open after leaving it.</center>"));
#endif 

	b = addBoolSelector(0,5,0,5,__tr2qs("Automatically join channel on invite"),KviOption_boolAutoJoinOnInvite);
#ifdef COMPILE_INFO_TIPS
	mergeTip(b,
		__tr2qs("<center>This option will cause KVIrc to automatically " \
			"join a channel when an INVITE message for that channel is received.<br>" \
			"<b>Warning:</b> This may help spammers harass you. :)</center>"));
#endif

	addRowSpacer(0,6,0,6);
}


KviIrcOptionsWidget::~KviIrcOptionsWidget()
{
}


#include "m_optw_irc.moc"
