#ifndef _OPTW_SOUND_H_
#define _OPTW_SOUND_H_
//
//   File : optw_sound.h
//   Creation date : Fri Sep  6 02:18:21 2002 GMT by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2002 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//


#include "kvi_optionswidget.h"
#include <qcombobox.h>
#include <qpushbutton.h>

#define KVI_OPTIONS_WIDGET_ICON_KviSoundOptionsWidget KVI_SMALLICON_SOUND
#define KVI_OPTIONS_WIDGET_NAME_KviSoundOptionsWidget __tr_no_lookup("Sound")

class KviSoundOptionsWidget : public KviOptionsWidget
{
	Q_OBJECT
public:
	KviSoundOptionsWidget(QWidget * parent);
	~KviSoundOptionsWidget();
protected:
	QComboBox * m_pSoundSystemBox;
	QPushButton * m_pTestButton;
	QPushButton * m_pAutoDetectButton;
protected:
	void fillBox();
	virtual void commit();
protected slots:
	void test();
	void autoDetect();
};

#endif //_OPTW_SOUND_H_
