//
//   File : optw_taskbar.cpp
//   Creation date : Wed Jan 16 04:30:39 2002 GMT by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "optw_taskbar.h"

#include "kvi_settings.h"
#include "kvi_locale.h"
#include "kvi_options.h"


KviTaskBarOptionsWidget::KviTaskBarOptionsWidget(QWidget * parent)
: KviOptionsWidget(parent,"taskbar_options_widget")
{

	createLayout(7,1);

	addBoolSelector(0,0,0,0,__tr2qs("Use tree taskbar"),KviOption_boolUseTreeWindowListTaskBar);
	addBoolSelector(0,1,0,1,__tr2qs("Sort windows by name"),KviOption_boolSortTaskBarItemsByName);
	addBoolSelector(0,2,0,2,__tr2qs("Show window icons in taskbar"),KviOption_boolUseTaskBarIcons);
	KviBoolSelector * b = addBoolSelector(0,3,0,3,__tr2qs("Show activity meter in taskbar"),KviOption_boolUseTaskBarActivityMeter);
#ifdef COMPILE_INFO_TIPS
	mergeTip(b,__tr2qs("<center>This option enables the usage of the taskbar activity meter. " \
		"Each window entry will have a small indicator of the activity that is going on in that window. " \
		"The indicator is a small square that changes colors, dark colors mean low activity, " \
		"while bright colors signal high activity. KVIrc also uses some heuristics to determine " \
		"whether the activity is somewhat \"human\" or it is generated by automated entities (such as bots " \
		"or IRC servers). \"Human\" activity causes the indicator to be shaded red while automated " \
		"activity causes the indicator to be shaded blue.</center>"));
#endif
	addBoolSelector(0,4,0,4,__tr2qs("Show IRC context indicator in taskbar"),KviOption_boolUseTaskBarIrcContextIndicator);
	addBoolSelector(0,5,0,5,__tr2qs("Enable window tooltips"),KviOption_boolShowTaskBarToolTips);
	addRowSpacer(0,6,0,6);
}


KviTaskBarOptionsWidget::~KviTaskBarOptionsWidget()
{
}




KviTreeTaskBarOptionsWidget::KviTreeTaskBarOptionsWidget(QWidget * parent)
: KviOptionsWidget(parent,"treetaskbar_options_widget")
{

	createLayout(6,2);

	QGroupBox *g = addGroupBox(0,0,1,0,2,QGroupBox::Horizontal,__tr2qs("Text/Alert Colors"));
	addColorSelector(g,__tr2qs("Normal:"),KviOption_colorTreeTaskBarForeground);
	addColorSelector(g,__tr2qs("Selected:"),KviOption_colorTreeTaskBarActiveForeground);
	addColorSelector(g,__tr2qs("Alert Level 1:"),KviOption_colorTreeTaskBarHighlight1Foreground);
	addColorSelector(g,__tr2qs("Alert Level 2:"),KviOption_colorTreeTaskBarHighlight2Foreground);
	addColorSelector(g,__tr2qs("Alert Level 3:"),KviOption_colorTreeTaskBarHighlight3Foreground);
	addColorSelector(g,__tr2qs("Alert Level 4:"),KviOption_colorTreeTaskBarHighlight4Foreground);
	addColorSelector(g,__tr2qs("Alert Level 5:"),KviOption_colorTreeTaskBarHighlight5Foreground);
	g = addGroupBox(0,1,1,1,2,QGroupBox::Horizontal,__tr2qs("Background Colors"));
	addColorSelector(g,__tr2qs("Normal:"),KviOption_colorTreeTaskBarBackground);
	addColorSelector(g,__tr2qs("Selected:"),KviOption_colorTreeTaskBarActiveBackground);
	addColorSelector(0,2,1,2,__tr2qs("Progress bar color:"),KviOption_colorTreeTaskBarProgress);
	addPixmapSelector(0,3,1,3,__tr2qs("Background image:"),KviOption_pixmapTreeTaskBarBackground);

	addUIntSelector(0,4,0,4,__tr2qs("Minimum width:"),KviOption_uintTreeTaskBarMinimumWidth,24,1024,125);
	addUIntSelector(1,4,1,4,__tr2qs("Maximum width:"),KviOption_uintTreeTaskBarMaximumWidth,24,9999,125);
	layout()->setRowStretch(3,1);

}


KviTreeTaskBarOptionsWidget::~KviTreeTaskBarOptionsWidget()
{
}




KviClassicTaskBarOptionsWidget::KviClassicTaskBarOptionsWidget(QWidget * parent)
: KviOptionsWidget(parent,"classictaskbar_options_widget")
{
	createLayout(6,1);
	addFontSelector(0,0,0,0,__tr2qs("Font:"),KviOption_fontTaskbar);
	QGroupBox *g = addGroupBox(0,1,0,1,2,QGroupBox::Horizontal,__tr2qs("Text/Alert Colors"));
	addColorSelector(g,__tr2qs("Normal:"),KviOption_colorTaskBarNormalText);
	addColorSelector(g,__tr2qs("Minimized:"), KviOption_colorTaskBarMinimizedText);
	addColorSelector(g,__tr2qs("Alert Level 1:"),KviOption_colorTaskBarHighlight1Text);
	addColorSelector(g,__tr2qs("Alert Level 2:"),KviOption_colorTaskBarHighlight2Text);
	addColorSelector(g,__tr2qs("Alert Level 3:"),KviOption_colorTaskBarHighlight3Text);
	addColorSelector(g,__tr2qs("Alert Level 4:"),KviOption_colorTaskBarHighlight4Text);
	addColorSelector(g,__tr2qs("Alert Level 5:"),KviOption_colorTaskBarHighlight5Text);
	addColorSelector(0,2,0,2,__tr2qs("Progress bar color:"),KviOption_colorTaskBarProgressBar);
	addUIntSelector(0,3,0,3,__tr2qs("Minimum width of buttons:"),KviOption_uintTaskBarButtonMinWidth,24,9999,100);
	addUIntSelector(0,4,0,4,__tr2qs("Maximum number of rows:"),KviOption_uintTaskBarMaximumRows,1,16,2);
	addRowSpacer(0,5,0,5);
}


KviClassicTaskBarOptionsWidget::~KviClassicTaskBarOptionsWidget()
{
}

#include "m_optw_taskbar.moc"
