//
//   File : optw_transport.cpp
//   Creation date : Mon Nov 13 2000 14:14:22 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2000 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "optw_transport.h"

#include <qgroupbox.h>

#include "kvi_options.h"
#include "kvi_locale.h"

KviTransportOptionsWidget::KviTransportOptionsWidget(QWidget * parent)
: KviOptionsWidget(parent,"transport_options_widget")
{
	createLayout(5,1);
	KviUIntSelector * u;
	
	QGroupBox * g = addGroupBox(0,0,0,0,1,QGroupBox::Horizontal,__tr2qs("Timeout Values" ),this);
	u = addUIntSelector(g,__tr2qs("Connect timeout:"),KviOption_uintIrcSocketTimeout,5,6000,60);
	u->setSuffix(__tr2qs(" sec"));
	u = addUIntSelector(g,__tr2qs("Outgoing data queue flush timeout:"),KviOption_uintSocketQueueFlushTimeout,100,2000,500);
	u->setSuffix(__tr2qs(" msec"));
	KviBoolSelector * b = addBoolSelector(0,1,0,1,__tr2qs("Limit outgoing traffic"),KviOption_boolLimitOutgoingTraffic);
	u = addUIntSelector(0,2,0,2,__tr2qs("Limit to 1 message every:"),
			KviOption_uintOutgoingTrafficLimitUSeconds,10000,2000000,10000000,KVI_OPTION_BOOL(KviOption_boolLimitOutgoingTraffic));
	u->setSuffix(__tr2qs(" usec"));
#ifdef COMPILE_INFO_TIPS
	mergeTip(u,__tr2qs("<center>Minimum value: <b>10000 usec</b><br>Maximum value: <b>10000000 usec</b></center>"));
#endif
	connect(b,SIGNAL(toggled(bool)),u,SLOT(setEnabled(bool)));

	g = addGroupBox(0,3,0,3,2,QGroupBox::Horizontal,__tr2qs("Network Interfaces"));
	
	b = addBoolSelector(g,__tr2qs("Bind IPv4 connections to:"),KviOption_boolBindIrcIpV4ConnectionsToSpecifiedAddress);
	KviStringSelector * s = addStringSelector(g,"",KviOption_stringIpV4ConnectionBindAddress,KVI_OPTION_BOOL(KviOption_boolBindIrcIpV4ConnectionsToSpecifiedAddress));
	connect(b,SIGNAL(toggled(bool)),s,SLOT(setEnabled(bool)));
#ifdef COMPILE_IPV6_SUPPORT
	b = addBoolSelector(g,__tr2qs("Bind IPv6 connections to:"),KviOption_boolBindIrcIpV6ConnectionsToSpecifiedAddress);
	s = addStringSelector(g,"",KviOption_stringIpV6ConnectionBindAddress,KVI_OPTION_BOOL(KviOption_boolBindIrcIpV6ConnectionsToSpecifiedAddress));
	connect(b,SIGNAL(toggled(bool)),s,SLOT(setEnabled(bool)));
#endif //!COMPILE_IPV6_SUPPORT

	addRowSpacer(0,4,0,4);
}

KviTransportOptionsWidget::~KviTransportOptionsWidget()
{
}


#include "m_optw_transport.moc"
