//
//   File : optw_userlist.cpp
//   Creation date : Sat Aug 11 2001 03:29:52 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
#include "optw_userlist.h"

#include <qlayout.h>

#include "kvi_options.h"
#include "kvi_locale.h"
#include "kvi_userlistview.h"

//#warning "Info tips"

KviUserListLookOptionsWidget::KviUserListLookOptionsWidget(QWidget * parent)
: KviOptionsWidget(parent,"userlistlook_options_widget")
{
	createLayout(5,1);

	addFontSelector(0,0,0,0,__tr2qs("Font:"),KviOption_fontUserListView);
	
	QGroupBox * g = addGroupBox(0,1,0,1,2,QGroupBox::Horizontal,__tr2qs("Nickname Colors"));
	addColorSelector(g,__tr2qs("Normal:"),KviOption_colorUserListViewNormalForeground);
	addColorSelector(g,__tr2qs("Selected:"),KviOption_colorUserListViewSelectionForeground);
	addColorSelector(g,__tr2qs("Channel owner:"),KviOption_colorUserListViewChanOwnerForeground);
	addColorSelector(g,__tr2qs("Channel admin:"),KviOption_colorUserListViewChanAdminForeground);
	addColorSelector(g,__tr2qs("Op:"),KviOption_colorUserListViewOpForeground);
	addColorSelector(g,__tr2qs("Half-op:"),KviOption_colorUserListViewHalfOpForeground);
	addColorSelector(g,__tr2qs("Voice:"),KviOption_colorUserListViewVoiceForeground);
	addColorSelector(g,__tr2qs("User-op:"),KviOption_colorUserListViewUserOpForeground);
	g = addGroupBox(0,2,0,2,2,QGroupBox::Horizontal,__tr2qs("Background Colors"));
	addColorSelector(g,__tr2qs("Normal:"),KviOption_colorUserListViewBackground);
	addColorSelector(g,__tr2qs("Selected:"),KviOption_colorUserListViewSelectionBackground);


	g = addGroupBox(0,3,0,3,1,QGroupBox::Horizontal,__tr2qs("Nickname Grid"));
	KviBoolSelector * b = addBoolSelector(g,__tr2qs("Draw nickname grid"),KviOption_boolUserListViewDrawGrid);
	QHBox * hb = new QHBox(g);
	hb->setSpacing(4);

	KviColorSelector * s = addColorSelector(hb,__tr2qs("Grid color:"),KviOption_colorUserListViewGrid,KVI_OPTION_BOOL(KviOption_boolUserListViewDrawGrid));
	connect(b,SIGNAL(toggled(bool)),s,SLOT(setEnabled(bool)));

	QLabel * l = new QLabel(__tr2qs("Grid type:"),hb);
	l->setEnabled(KVI_OPTION_BOOL(KviOption_boolUserListViewDrawGrid));
	connect(b,SIGNAL(toggled(bool)),l,SLOT(setEnabled(bool)));
	m_pGridTypeCombo = new QComboBox(false,hb);
	m_pGridTypeCombo->insertItem(__tr2qs("3D Grid"));
	m_pGridTypeCombo->insertItem(__tr2qs("3D Buttons"));
	m_pGridTypeCombo->insertItem(__tr2qs("Plain Grid"));
	m_pGridTypeCombo->insertItem(__tr2qs("Dotted Grid"));
	m_pGridTypeCombo->setCurrentItem(KVI_OPTION_UINT(KviOption_uintUserListViewGridType));
	m_pGridTypeCombo->setEnabled(KVI_OPTION_BOOL(KviOption_boolUserListViewDrawGrid));
	connect(b,SIGNAL(toggled(bool)),m_pGridTypeCombo,SLOT(setEnabled(bool)));
	
	addPixmapSelector(0,4,0,4,__tr2qs("Background image:"),KviOption_pixmapUserListViewBackground);

	//layout()->setColStretch(0,1);
	layout()->setRowStretch(4,1);
}

KviUserListLookOptionsWidget::~KviUserListLookOptionsWidget()
{
}


void KviUserListLookOptionsWidget::commit()
{
	KviOptionsWidget::commit();
	KVI_OPTION_UINT(KviOption_uintUserListViewGridType) = m_pGridTypeCombo->currentItem();
	if(KVI_OPTION_UINT(KviOption_uintUserListViewGridType) > KVI_USERLISTVIEW_GRIDTYPE_MAXIMUM)
		KVI_OPTION_UINT(KviOption_uintUserListViewGridType) = KVI_USERLISTVIEW_GRIDTYPE_DEFAULT;
	
}


KviUserListFeaturesOptionsWidget::KviUserListFeaturesOptionsWidget(QWidget * parent)
: KviOptionsWidget(parent,"userlistfeatures_options_widget")
{
	createLayout(5,1);

	KviBoolSelector *b = addBoolSelector(0,0,0,0,__tr2qs("Show user channel icons"),KviOption_boolShowUserChannelIcons);
	b = addBoolSelector(0,1,0,1,__tr2qs("Show user channel activity indicator"),KviOption_boolShowUserChannelState);

	b = addBoolSelector(0,2,0,2,__tr2qs("Enable user tooltips"),KviOption_boolShowUserListViewToolTips);
	QGroupBox *g = addGroupBox(0,3,0,3,1,QGroupBox::Horizontal,__tr2qs("Avatars"));
	b = addBoolSelector(g,__tr2qs("Scale avatar images (recommended)"),KviOption_boolScaleAvatars);
	QToolTip::add(b,__tr2qs("<center>This option will force KVIrc to scale avatars" \
			" shown in the userlist.<br>" \
			"Avatars will be scaled to fit the " \
			"constraints set below. Better keep this option on. :)</center>"));

	KviUIntSelector *u = addUIntSelector(g,__tr2qs("Image width:"),KviOption_uintAvatarScaleWidth,0,512,80,KVI_OPTION_BOOL(KviOption_boolScaleAvatars));

	connect(b,SIGNAL(toggled(bool)),u,SLOT(setEnabled(bool)));
	u = addUIntSelector(g,__tr2qs("Image height:"),KviOption_uintAvatarScaleHeight,0,512,80,KVI_OPTION_BOOL(KviOption_boolScaleAvatars));
	connect(b,SIGNAL(toggled(bool)),u,SLOT(setEnabled(bool)));


	addRowSpacer(0,4,0,4);
}

KviUserListFeaturesOptionsWidget::~KviUserListFeaturesOptionsWidget()
{
}

#include "m_optw_userlist.moc"
