#ifndef _KVI_IRC_NETWORK_H_INCLUDED_
#define _KVI_IRC_NETWORK_H_INCLUDED_

// =============================================================================
//
//      --- kvi_irc_network.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qptrlist.h>

#include "kvi_irc_server.h"

class KviConfig;

class KviIrcNetwork
{
	friend class KviIrcServerManager;
public:
	KviIrcNetwork(const char *szName = 0);
	KviIrcNetwork(KviIrcNetwork *net);
	~KviIrcNetwork();
private:
	KviStr                  m_szName;
	KviIrcServer           *m_pCurrentServer;
	QPtrList<KviIrcServer> *m_pServerList;
public:
	void clear();
	uint serverCount();
	QPtrList<KviIrcServer> *serverList();
	bool setCurrentServer(KviIrcServer *ptr);

	/**
	 * Returns the current server or 0 if (and only if) the list is empty
	 */
	KviIrcServer *currentServer();

	/**
	 * Returns the next server in the list (circular), 0 if the list is empty.
	 * Updates the current server!!!
	 */
	KviIrcServer *nextServer();

	/**
	 * Appends a server entry and sets it as current
	 */
	void appendServer(KviIrcServer *ptr);

	/**
	 * Returns true if the server was in the list, updates the current server!
	 * Deletes the KviIrcServer entry, so ptr is not valid anymore!!!!
	 */
	bool removeServer(KviIrcServer *ptr);

	/**
	 * Copies the current network too...
	 */
	void copyFrom(KviIrcNetwork *net);

	char *name();
	// DO NOT CALL THIS, will mix the server list! (call only from KviDlgOptServer)
	void setName(const char *name);

	void updateServerIp(const char *szServer, KviIpAddresses list);
	KviIrcServer *getServerByName(const char *szName);
	void sortServers();
private:
	void       serverFromString(KviStr &szSrv, KviIrcServer *srv);
	void         serverToString(KviStr &szSrv, KviIrcServer *srv);
	void getServerCompareString(KviStr &szStr, KviIrcServer *srv);
	void save(KviConfig *cfg);
	void load(KviConfig *cfg);
};

#endif // _KVI_IRC_NETWORK_H_INCLUDED_
