#ifndef _KVI_IRC_SERVER_H_INCLUDED_
#define _KVI_IRC_SERVER_H_INCLUDED_

// =============================================================================
//
//      --- kvi_irc_server.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qptrlist.h>

#include "kvi_dns.h"
#include "kvi_settings.h"
#include "kvi_string.h"

class KviConfig;
class KviIrcNetwork;

typedef struct
{
	KviStr         szHost;
	KviIpAddresses addresses;
	KviStr         szPassword;
	KviStr         szDescription;
	KviStr         szPort;
#ifdef COMPILE_NEED_IPV6
	bool           bIPv6;
#endif
} KviIrcServer;

class KviIrcServerManager
{
public:
	KviIrcServerManager();
	~KviIrcServerManager();
private:
	QPtrList<KviIrcNetwork> *m_pNetList;
	KviIrcNetwork *m_pCurrentNet;
public:
	void clear();
	void load(KviConfig *cfg);
	void save(KviConfig *cfg);
	QPtrList<KviIrcNetwork> *networkList();
	void insertNetwork(KviIrcNetwork *net);
	KviIrcNetwork *getCurrentNetwork();
	KviIrcNetwork *getNetworkByName(const char *szName);
	bool setCurrentNetwork(KviIrcNetwork *net);
	bool setCurrentNetwork(const char *szName);
	bool setCurrentServer(KviIrcServer *srv);
	void iWantThisServerToBeCurrent(const char *szName, const char *szPort, bool bIPv6 = false);
	void setCurrentServerPassword(const char *pass);
	bool removeNetwork(KviIrcNetwork *net);
	bool removeNetwork(const char *szName);
	void copyFrom(KviIrcServerManager *ptr);
	KviIrcServer *getCurrentServer();
	KviIrcServer *getNextServer();
	void updateServerIp(const char *szNet, const char *szServer, KviIpAddresses list);
	bool importFromIni(const char *filename);
	void insertNewServer(KviIrcServer *srv, const char *szNetName);
};

#endif // _KVI_IRC_SERVER_H_INCLUDED_
