#ifndef _KVI_PROCESS_QT_H_INCLUDED_
#define _KVI_PROCESS_QT_H_INCLUDED_

// =============================================================================
//
//      --- kvi_process_qt.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <signal.h>

#include <qobject.h>
#include <qstring.h>

class QSocketNotifier;

/*
 *  Simple versions of the KProcess and KProcessController classes
 *  original code by (C) Christian Czezatke
 *  e9025461@student.tuwien.ac.at
 *  Really good work :)
 */
class KviProcess : public QObject
{
	friend class KviProcessController;

	Q_OBJECT
public:
	KviProcess();
	~KviProcess();

	bool  run(const char *commandline, bool bCommunicate = false, bool bKillOnClose = false, bool bExecInSubshell = false);
	bool  isActive();
	pid_t pid();
	bool  sendSignal(int sig = SIGKILL);
	bool  writeStdin(const char *buffer, int len);
	int   exitStatus();

	const QString findShell();
signals:
	void  processExited(KviProcess *);
	void receivedStdout(KviProcess *, char *buffer, int len);
	void receivedStderr(KviProcess *, char *buffer, int len);
protected:
	void processHasExited(int status);
	static QString m_szShellName;
private slots:
	void receivedStdout(int fd);
	void receivedStderr(int fd);
private:
	#define PROC_SOCKET_PARENT 0
	#define PROC_SOCKET_CHILD  1

	int   m_iExitStatus;
	pid_t m_pid;

	bool m_bIsRunning;
	bool m_bKillOnClose;

	int m_stdinSock[2];
	int m_stdoutSock[2];
	int m_stderrSock[2];

	QSocketNotifier *m_pStdoutNotifier;
	QSocketNotifier *m_pStderrNotifier;

	bool setupSockets();
	void killSockets();
	void clearSockVariables();
	bool child_setupSockets();
	bool parent_setupSockets();
};

#endif // _KVI_PROCESS_QT_H_INCLUDED_
