// =============================================================================
//
//      --- kvi_options_dcc_voice.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviOptionsDccVoice"

#include <qlayout.h>

#include "kvi_boolselector.h"
#include "kvi_locale.h"
#include "kvi_options_dcc_voice.h"
#include "kvi_options.h"
#include "kvi_stringselector.h"

/*
	@quickhelp: KviOptionsDccVoice
	@widget: DCC voice options
		Here you can set the options for the DCC Voice connections.<br>
		You can choose to auto accepth the connection (otherwise you will be asked for the permission).<br>
		KVIrc 0.9.0 had a "theoretical" bug in the compression/decompression algorythms that
		made it compress the data stream inefficently.<br>
		You can choose to emulate this bug if you want to talk with 0.9.0 clients.<br>
		It will work even without this option, but the remote user will hear
		a small "click" for each data packet decompressed.<br>
		The same may happen if you try to talk to a KVIrc >= 1.0.0 client with this option enabled.<br>
*/
KviOptionsDccVoice::KviOptionsDccVoice(QWidget *parent)
	: KviOptionsWidget(parent, KVI_GENERAL_OPTIONS_WIDGET_ID_DCCVOICE)
{
	QGridLayout *g = new QGridLayout(
		this, 6, 1, KVI_GENERAL_OPTIONS_GRIDLAYOUT_BORDER, KVI_GENERAL_OPTIONS_GRIDLAYOUT_SPACE
	);

	KviBoolSelector *b = new KviBoolSelector(this, _i18n_("Automatically accept"), &(g_pOptions->m_bAutoAcceptDccVoice));
	g->addWidget(b, 0, 0);

	b = new KviBoolSelector(this, _i18n_("Create iconified"), &(g_pOptions->m_bCreateIconifiedDccVoice));
	g->addWidget(b, 1, 0);

	KviStringSelector *s = new KviStringSelector(this, _i18n_("Sound device:"), &(g_pOptions->m_szSoundDevice), 180);
	g->addWidget(s, 2, 0);

	b = new KviBoolSelector(this, _i18n_("Sound device is full-duplex"), &(g_pOptions->m_bFullDuplexSoundDevice));
	g->addWidget(b, 3, 0);

	b = new KviBoolSelector(this,
		_i18n_("KVIrc 0.9.0 compatible compression (simulate 0.9.0 bug)"),
		&(g_pOptions->m_b090CompatibleVoiceCompression)
	);
	g->addWidget(b, 4, 0);

	// Trick
	QFrame *f = new QFrame(this);
	g->addWidget(f, 5, 0);
	g->setRowStretch(5, 1);
}

KviOptionsDccVoice::~KviOptionsDccVoice()
{
	// Nothing here
}

void KviOptionsDccVoice::commitChanges()
{
	KviBoolSelector::commitAll(this);
	KviStringSelector::commitAll(this);
}

#include "m_kvi_options_dcc_voice.moc"
