// =============================================================================
//
//      --- kvi_systray_widget.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviSysTrayWidget"

#include <qpainter.h>
#include <qpixmap.h>
#include <qtooltip.h>

#include "kvi_systray.h"
#include "kvi_systray_widget.h"

KviSysTrayWidget::KviSysTrayWidget(KviSysTray *parent, const char *tooltip, const char *name)
	: QWidget(parent, name ? name : "unnamed_systray_widget")
{
	m_pSysTray = parent;
	hide();
	if( tooltip )
		QToolTip::add(this, tooltip);
	m_plugin_handle = 0;
}

KviSysTrayWidget::~KviSysTrayWidget()
{
	// Nothing here
}

QString KviSysTrayWidget::icon()
{
	return QString::null;
}

void KviSysTrayWidget::paintDefaultBackground(QPainter *pa)
{
	pa->fillRect(0, 0, width(), height(), m_pSysTray->getBackground());
}

void KviSysTrayWidget::paintDefaultFrame(QPainter *pa)
{
	int w = width();
	int h = height();
	pa->setPen(QPen(colorGroup().dark(), 1));
	pa->drawLine(0, 0, w - 1, 0);
	pa->drawLine(0, 0, 0, h);
	pa->setPen(QPen(colorGroup().light(), 1));
	pa->drawLine(1, h - 1, w, h - 1);
	pa->drawLine(w - 1, 0, w - 1, h);
}

#include "m_kvi_systray_widget.moc"
