// =============================================================================
//
//   Copyright (C) 1999-2000 Szymon Stefanek
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviXmmsWidget"

#include <qpainter.h>

#define __KVIRC_PLUGIN__

#include "kvi_process.h"
#include "kvi_xmms.h"
#include "kvi_xmms_widget.h"
#include "kvirc_plugin.h"

KviXmmsWidget::KviXmmsWidget(void *handle, KviStatusBar *parent, KviFrame *frame)
	: KviDockableWidget(handle, parent)
{
	m_pFrm = frame;
	setMaximumWidth(146);
	setMinimumWidth(146);
	setMinimumHeight(16);
	setMaximumHeight(16);
	m_mousePressX = -1;
	setBackgroundMode(NoBackground);
	m_timer = startTimer(KVI_XMMS_UPDATE_TIME);
}

KviXmmsWidget::~KviXmmsWidget()
{
	// Nothing here
}

void KviXmmsWidget::processExited(KviProcess *proc)
{
	if( proc ) delete proc;
}

void KviXmmsWidget::mousePressEvent(QMouseEvent *e)
{
	m_mousePressX = e->pos().x();
	if( !libxmms_remote_is_running(0) ) {
		KviProcess *proc = new KviProcess();
		connect(proc, SIGNAL(processExited(KviProcess *)), this, SLOT(processExited(KviProcess *)));
		if( !proc->run("xmms") )
			delete proc;
	}
	if( m_mousePressX > 50 ) {
		if( m_mousePressX < 66 ) {
			libxmms_remote_playlist_prev(0);
			sayWhatIsPlayed();
		} else if( m_mousePressX < 82 ) {
			libxmms_remote_play(0);
			sayWhatIsPlayed();
		} else if( m_mousePressX < 98 ) {
			libxmms_remote_pause(0);
		} else if( m_mousePressX < 114 ) {
			libxmms_remote_stop(0);
		} else if( m_mousePressX < 130 ) {
			libxmms_remote_playlist_next(0);
			sayWhatIsPlayed();
		} else {
			libxmms_remote_eject(0);
		}
	} else {
		if( libxmms_remote_is_playing(0) )
			sayWhatIsPlayed();
		else
			kvirc_plugin_statusbar_message(m_pFrm, "[XMMS]: stopped", 5000);
	}
	repaint();
}

void KviXmmsWidget::sayWhatIsPlayed()
{
	const char *song = libxmms_remote_get_playlist_title(0, libxmms_remote_get_playlist_pos(0));
	KviStr tmp(KviStr::Format, "[XMMS]: playing \"%s\"", song);
	kvirc_plugin_statusbar_message(m_pFrm, tmp.ptr(), 5000);
}

void KviXmmsWidget::mouseReleaseEvent(QMouseEvent *e)
{
	m_mousePressX = -1;
	repaint();
}

void KviXmmsWidget::paintEvent(QPaintEvent *)
{
	m_bIsPlaying   = libxmms_remote_is_playing(0);
	m_bIsRunning   = libxmms_remote_is_running(0);
	m_iPlaylistPos = libxmms_remote_get_playlist_pos(0);
	m_iPlaylistLen = libxmms_remote_get_playlist_length(0);

	QPainter p(this);
	p.drawPixmap(0, 0, *g_pXmmsLogo, 0, 0, 50, 16);
	QColor clr(140, 120, 255);
	p.setPen(clr);

	QFont f = KviConfig::getFixedFont();
	f.setPointSize(9);
	p.setFont(f);

	if( m_bIsPlaying ) {
		KviStr tmp(KviStr::Format, "%d of %d", m_iPlaylistPos + 1, m_iPlaylistLen);
		p.drawText(1, 1, 48, 14, AlignCenter, tmp.ptr());
	} else {
		if( m_bIsRunning ) {
			KviStr tmp(KviStr::Format, "0 of %d", m_iPlaylistLen);
			p.drawText(1, 1, 48, 14, AlignCenter, tmp.ptr());
		} else
			p.drawText(1, 1, 48, 14, AlignCenter, "---");
	}
	// Prev
	p.drawPixmap(50, 0, ((m_mousePressX >= 50) && (m_mousePressX < 66)) ?
		*g_pXmmsButtonsPressed : *g_pXmmsButtonsNormal, 0, 0, 16, 16);
	// Play
	p.drawPixmap(66, 0, ((m_mousePressX >= 66) && (m_mousePressX < 82)) ?
		*g_pXmmsButtonsPressed : (m_bIsPlaying ? *g_pXmmsButtonsActive : *g_pXmmsButtonsNormal), 16, 0, 16, 16);
	// Pause
	p.drawPixmap(82, 0, ((m_mousePressX >= 82) && (m_mousePressX < 98)) ?
		*g_pXmmsButtonsPressed : (libxmms_remote_is_paused(0) ? *g_pXmmsButtonsActive : *g_pXmmsButtonsNormal), 32, 0, 16, 16);
	// Stop
	p.drawPixmap(98, 0, ((m_mousePressX >= 98) && (m_mousePressX < 114)) ?
		*g_pXmmsButtonsPressed : ((m_bIsPlaying || (!m_bIsRunning)) ? *g_pXmmsButtonsNormal : *g_pXmmsButtonsActive), 48, 0, 16, 16);
	// Next
	p.drawPixmap(114, 0, ((m_mousePressX >= 114) && (m_mousePressX < 130)) ?
		*g_pXmmsButtonsPressed : *g_pXmmsButtonsNormal, 64, 0, 16, 16);
	// Eject
	p.drawPixmap(130, 0, ((m_mousePressX >= 130) && (m_mousePressX < 146)) ?
		*g_pXmmsButtonsPressed : *g_pXmmsButtonsNormal, 80, 0, 16, 16);
}

void KviXmmsWidget::timerEvent(QTimerEvent *e)
{
	if( e->timerId() == m_timer ) {
		     if( m_bIsRunning   != libxmms_remote_is_running(0)          ) repaint();
		else if( m_bIsPlaying   != libxmms_remote_is_playing(0)          ) repaint();
		else if( m_iPlaylistPos != libxmms_remote_get_playlist_pos(0)    ) repaint();
		else if( m_iPlaylistLen != libxmms_remote_get_playlist_length(0) ) repaint();
	}
	KviDockableWidget::timerEvent(e);
}

#include "m_kvi_xmms_widget.moc"
