/***************************************************************************
*   Copyright (C) 2004 by Christoph Thielecke                             *
*   crissi99@gmx.de                                                       *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/ 
//BEGIN INCLUDES
#include "utils.h"
#include <qstring.h>
#include <qapplication.h>
#include <iostream>
#include <qfile.h>
#include <qprocess.h>
#include <qstring.h>
#include <klocale.h>
#include <ksimpleconfig.h>
#include <qdir.h>
#include <kstddirs.h>
#include <kdebug.h>
#include <kstandarddirs.h>
#include <netdb.h> // name resolving
#include <arpa/inet.h>
#include <qregexp.h>
#include <kmessagebox.h>

//END INCLUDES

Utils::Utils( KVpncConfig* config, QObject *parent, const char *name )
		: QObject( parent, name ) {
	env = new QStringList();
	*env << "LC_ALL=C" << "LANG=C";
	this->config = config;
	retrieveValidNetworkdevice = false;
}

Utils::~Utils() {
	// 	if(createProcess!=0)
	// 		delete createProcess;
	//
	// 	if (NetworkDeviceTestProcess!=0)
	// 		delete NetworkDeviceTestProcess;
}

bool Utils::isValidIPv4Address( QString Address ) {
	if ( Address.contains( '.' ) != 3 )
		return false;
	else {
		//std::cout << "test1 succeed.\n";
		QString addr = Address;
		int part0 = addr.section( '.', 0, 0 ).toInt();
		int part1 = addr.section( '.', 1, 1 ).toInt();
		int part2 = addr.section( '.', 2, 2 ).toInt();
		int part3 = addr.section( '.', 3, 3 ).toInt();

		//std::cout << "part0 " << part0 << ", part1 " << part1 <<  ", part2 " << part2 << ", part3 " << part3 << "\n";

		if ( ( part0 > 1 && part0 < 255 ) &&
		        ( part1 >= 0 && part1 < 255 ) &&
		        ( part2 >= 0 && part2 < 255 ) &&
		        ( part3 >= 0 && part3 < 255 ) )
			return true;
		else
			return false;
	}
}

bool Utils::isValidIPv4NetworkAddress( QString Address ) {
	if ( isValidIPv4Address( Address ) ) {
		if ( Address.section( '.', 3, 3 ).toInt() == 0 )
			return true;
		else
			return false;
	} else
		return false;
}

bool Utils::isValidIPv4BroadcastAddress( QString Address ) {
	if ( isValidIPv4Address( Address ) ) {
		if ( Address.section( '.', 3, 3 ).toInt() == 255 )
			return true;
		else
			return false;
	} else
		return false;
	return false;
}

bool Utils::tunDevExists() {
	if ( QFile ( "/dev/net/tun" ).exists() )
		return true;
	else
		return false;
}

bool Utils::createTunDev() {
	createProcess = new QProcess( this );
	connect( createProcess, SIGNAL( readyReadStdout() ), this, SLOT( readStdOutCreateTunDev() ) );
	connect( createProcess, SIGNAL( readyReadStderr() ), this, SLOT( readStdErrCreateTunDev() ) );

	// step one: create directory
	if ( !QDir ( "/dev/net" ).exists() ) {
		createProcess->addArgument( "mkdir" );
		//createProcess->addArgument("-p");
		createProcess->addArgument( "/dev/net" );


		if ( !createProcess->start() ) {
			kdError() << "Unable to create tunnel device file!" << endl;
			return false;
		} else {
			// 		while(createProcess->isRunning())
			// 		{ };
			sleep ( 2 );
		}
	}

	// step two: create device node
	createProcess->clearArguments();
	createProcess->addArgument( "/bin/mknod" );
	createProcess->addArgument( "/dev/net/tun" );
	createProcess->addArgument( "c" );
	createProcess->addArgument( "10" );
	createProcess->addArgument( "200" );

	if ( !createProcess->start() ) {
		kdError() << "Unable to create tunnel device file!" << endl;
		return false;
	} else
		return true;

	return false;
}

bool Utils::loadKernelModule( QString Name, QApplication *app ) {
	if ( !Name.isEmpty() ) {
		modprobeSuccess = true;
		ModprobeProcess = new QProcess( this );
		ModprobeProcess->addArgument( "/sbin/modprobe" );
		ModprobeProcess->addArgument( Name );

		connect( ModprobeProcess, SIGNAL( readyReadStdout() ), this, SLOT( readStdOutLoadKernelModule() ) );
		connect( ModprobeProcess, SIGNAL( readyReadStderr() ), this, SLOT( readStdErrLoadKernelModule() ) );
		if ( !ModprobeProcess->start( env ) ) {
			kdError() << "Unable to start kernel module loading process!" << endl;
			return false;
		} else {
			while ( ModprobeProcess->isRunning() )
				app->processEvents();
			return modprobeSuccess;
		}

	} else
		return false;
}

bool Utils::doChmod( QString file, QString mode ) {
	QProcess * chmodProcess = new QProcess( this );
	chmodProcess->addArgument( "chmod" );
	chmodProcess->addArgument( mode );
	chmodProcess->addArgument( file );

	if ( !chmodProcess->start() ) {
		// KMessageBox::sorry( this, i18n( "\"%1\" start failed!" ).arg( "PppdUpScript" ) );
		config->appendLogEntry( i18n( "Chmod of %1 failed!" ).arg( file ), config->error );
		return false;
	} else {
		if ( config->KvpncDebugLevel > 0 )
			config->appendLogEntry ( i18n( "chmod of %1 (%2) started." ).arg( file ).arg( mode ) , config->debug );
		while ( chmodProcess->isRunning() )
			config->appPointer->QApplication::processEvents();
		//GlobalConfig->appendLogEntry ( i18n( "\"%1\" finished." ).arg("chmod"),GlobalConfig->info );
		return true;
	}
}

QPtrList<ToolInfo>* Utils::getToolList() {
	QPtrList<ToolInfo> *ToolList = new QPtrList<ToolInfo>();

	//TODO move to KVpncConfig
	QStringList *ToolNamesList = new QStringList();
	ToolNamesList->append( "vpnc" );
	ToolNamesList->append( "racoon" );
	ToolNamesList->append( "ipsec" ); // freeswan
	ToolNamesList->append( "pppd" );
	ToolNamesList->append( "pptp" );
	ToolNamesList->append( "l2tpd" );
	ToolNamesList->append( "setkey" );
	ToolNamesList->append( "iptables" );
	ToolNamesList->append( "openssl" );
	ToolNamesList->append( "openvpn" );
	ToolNamesList->append( "kill" );
	ToolNamesList->append( "killall" );
	ToolNamesList->append( "ping" );
	ToolNamesList->append( "ip" );
	ToolNamesList->append( "ifconfig" );
	ToolNamesList->append( "route" );
	ToolNamesList->append( "pkcs11-tool" );

	ToolInfo *currentTool;
	for ( QStringList::Iterator it = ToolNamesList->begin(); it != ToolNamesList->end(); it++ ) {
		//std::cout << "tool: " << *it << std::endl;

		currentTool = new ToolInfo( *it );
		currentTool->programsInPath =config->programsInPath;
		if ( currentTool->Name == "vpnc" )
			currentTool->TryPath_first = config->pathToVpnc;
		else	if ( currentTool->Name == "ipsec" )
			currentTool->TryPath_first = config->pathToFreeswan;
		else	if ( currentTool->Name == "racoon" )
			currentTool->TryPath_first = config->pathToRacoon;
		else	if ( currentTool->Name == "setkey" )
			currentTool->TryPath_first = config->pathToSetkey;
		else	if ( currentTool->Name == "openvpn" )
			currentTool->TryPath_first = config->pathToOpenvpn;
		else	if ( currentTool->Name == "openssl" )
			currentTool->TryPath_first = config->pathToOpenssl;
		else	if ( currentTool->Name == "pppd" )
			currentTool->TryPath_first = config->pathToPppd;
		else	if ( currentTool->Name == "iptables" )
			currentTool->TryPath_first = config->pathToIptables;
		else	if ( currentTool->Name == "kill" )
			currentTool->TryPath_first = config->pathToKill;
		else	if ( currentTool->Name == "killall" )
			currentTool->TryPath_first = config->pathToKillall;
		else	if ( currentTool->Name == "ping" )
			currentTool->TryPath_first = config->pathToPing;
		else	if ( currentTool->Name == "ip" )
			currentTool->TryPath_first = config->pathToIp;
		else	if ( currentTool->Name == "ifconfig" )
			currentTool->TryPath_first = config->pathToIfconfig;
		else	if ( currentTool->Name == "route" )
			currentTool->TryPath_first = config->pathToRoute;
		else	if ( currentTool->Name == "pptp" )
			currentTool->TryPath_first = config->pathToPptp;
		else	if ( currentTool->Name == "l2tpd" )
			currentTool->TryPath_first = config->pathToL2tpd;
		else	if ( currentTool->Name == "pkcs11-tool" )
			currentTool->TryPath_first = config->pathToPkcs11Tool;

		ToolList->append( currentTool );
		currentTool->collectToolInfo();
		//currentTool=0L;
		// 			std::cout << "tool: " << currentTool->Name << std::endl;
		// 			std::cout << "Version: " << currentTool->Version << std::endl;
		// 			std::cout << "Path: " << currentTool->PathToExec << std::endl << std::endl;
	}
	ToolList->sort();

	return ToolList;

}

ToolInfo* Utils::getToolInfo( KVpncConfig *GlobalConfig, QString name ) {
	ToolInfo * Tool = 0;
	for ( Tool = GlobalConfig->ToolList->first();Tool;Tool = GlobalConfig->ToolList->next() ) {
		if ( Tool->Name == name )
			break;
	}
	return Tool;
}

QString Utils::resolveName( QString Name ) {
	resolvedIP = "";
	resolveFinished = false;

	struct hostent * server_entry;

	// get ip address to server name
	if ( ( server_entry = gethostbyname( Name.ascii() ) ) == NULL ) {
		printf( "gethostbyname failed\n" );
	} else
		resolvedIP = QString( inet_ntoa( *( struct in_addr* ) server_entry->h_addr_list[ 0 ] ) );
	return resolvedIP;
}

QString Utils::removeSpecialCharsForFilename( QString filename ) {
	filename.replace( QRegExp( "[*]+" ), "_" );
	filename.replace( QRegExp( "[+] +" ), "_" );
	filename.replace( QRegExp( "[$]+" ), "_" );
	filename.replace( QRegExp( ":+" ), "_" );
	filename.replace( QRegExp( "ï¿œ" ), "_" );
	filename.replace( QRegExp( "ï¿œ" ), "_" );
	filename.replace( QRegExp( "+" ), "_" );
	filename.replace( QRegExp( "ï¿œ" ), "_" );
	filename.replace( QRegExp( "ï¿œ" ), "_" );
	filename.replace( QRegExp( "ï¿œ" ), "_" );
	filename.replace( QRegExp( "ï¿œ" ), "_" );
	filename.replace( QRegExp( "\\+" ), "_" );
	filename.replace( QRegExp( "/+" ), "_" );
	filename.replace( QRegExp( ";+" ), "_" );
	filename.replace( QRegExp( " " ), "_" );
	filename.replace( QRegExp( "_+" ), "_" );
	return filename;
}

QStringList Utils::getOpenvpnCiphers() {
	OpenvpnCiphers.clear();
	retrieveOpenvpnCiphers = false;

	ToolInfo *OpenvpnInfo = getToolInfo( config, "openvpn" );
	QString pathToOpenvpn = OpenvpnInfo->PathToExec;

	if ( pathToOpenvpn.isEmpty() )
		return OpenvpnCiphers;

	OpenvpnCiphersProcess = new QProcess( this );
	OpenvpnCiphersProcess->addArgument( pathToOpenvpn );
	OpenvpnCiphersProcess->addArgument( "--show-ciphers" );

	connect( OpenvpnCiphersProcess, SIGNAL( readyReadStdout() ), this, SLOT( readStdOutRetriveOpenvpnCiphers() ) );
	connect( OpenvpnCiphersProcess, SIGNAL( readyReadStderr() ), this, SLOT( readStdErrRetriveOpenvpnCiphers() ) );

	if ( !OpenvpnCiphersProcess->start( env ) ) {
		kdError() << "Unable to fetch openvpn ciphers!" << endl;
		return false;
	} else {
		while ( OpenvpnCiphersProcess->isRunning() )
			config->appPointer->processEvents();


		disconnect( OpenvpnCiphersProcess, SIGNAL( readyReadStdout() ), this, SLOT( readStdOutRetriveOpenvpnCiphers() ) );
		disconnect( OpenvpnCiphersProcess, SIGNAL( readyReadStderr() ), this, SLOT( readStdErrRetriveOpenvpnCiphers() ) );

	}
	return OpenvpnCiphers;
}

QStringList Utils::getOpenvpnDigests() {
	OpenvpnDigests.clear();
	retrieveOpenvpnDigests = false;
	OpenvpnDigestCount=0;
	OpenvpnDigestString="";

	ToolInfo *OpenvpnInfo = getToolInfo( config, "openvpn" );
	QString pathToOpenvpn = OpenvpnInfo->PathToExec;

	if ( pathToOpenvpn.isEmpty() )
		return OpenvpnDigests;

	OpenvpnDigestProcess = new QProcess( this );
	OpenvpnDigestProcess->addArgument( pathToOpenvpn );
	OpenvpnDigestProcess->addArgument( "--show-digests" );

	connect( OpenvpnDigestProcess, SIGNAL( readyReadStdout() ), this, SLOT( readStdOutRetriveOpenvpnDigests() ) );
	connect( OpenvpnDigestProcess, SIGNAL( readyReadStderr() ), this, SLOT( readStdErrRetriveOpenvpnDigests() ) );

	if ( !OpenvpnDigestProcess->start( env ) ) {
		kdError() << "Unable to fetch openvpn digests!" << endl;
		return false;
	} else {
		while ( OpenvpnDigestProcess->isRunning() )
			config->appPointer->processEvents();

		disconnect( OpenvpnDigestProcess, SIGNAL( readyReadStdout() ), this, SLOT( readStdOutRetriveOpenvpnDigests() ) );
		disconnect( OpenvpnDigestProcess, SIGNAL( readyReadStderr() ), this, SLOT( readStdErrRetriveOpenvpnDigests() ) );

		OpenvpnDigests = QStringList().split("#",OpenvpnDigestString);

		for ( QStringList::Iterator it = OpenvpnDigests.begin(); it != OpenvpnDigests.end(); ++it )
			*it = QString(*it).section(' ',0,0);

	}
	return OpenvpnDigests;
}

QStringList Utils::getKernelCrypto() {
	KernelCrypto.clear();
	QFile cryptoprocfile( "/proc/crypto" );

	if ( cryptoprocfile.open( IO_ReadOnly ) ) {
		QTextStream stream( &cryptoprocfile );
		QString line;
		if (config->KvpncDebugLevel > 2)
			std::cout << "Kernel crypto list: " << std::endl;
		while ( !stream.atEnd() ) {
			line = stream.readLine();
			if (line.find("name") > -1 )
			{
				QString crypto = line.section(':',1,1).stripWhiteSpace();
				KernelCrypto.append(crypto);
// 				std::cout << "crypto: " << crypto.ascii() << std::endl;
			}
		}
		cryptoprocfile.close();
	} else {
	}
	return KernelCrypto;
}

QString Utils::getNameAndPidOfProgramListen( int port ) {
	if ( port == 0 )
		return "";

	ListenPort = port;
	retrieveNameAndPidOfProgramListen = false;

	NameAndPidOfProgramListenProcess = new QProcess( this );
	NameAndPidOfProgramListenProcess->addArgument( config->pathToNetstat );
	NameAndPidOfProgramListenProcess->addArgument( "-ntupl" );

	connect( NameAndPidOfProgramListenProcess, SIGNAL( readyReadStdout() ), this, SLOT( readStdOutGetNameAndPidOfProgramListen() ) );
	connect( NameAndPidOfProgramListenProcess, SIGNAL( readyReadStderr() ), this, SLOT( readStdErrGetNameAndPidOfProgramListen() ) );

	if ( !NameAndPidOfProgramListenProcess->start( env ) ) {
		kdError() << "netstat fails!" << endl;
		return false;
	} else {
		while ( NameAndPidOfProgramListenProcess->isRunning() )
			config->appPointer->processEvents();


		disconnect( NameAndPidOfProgramListenProcess, SIGNAL( readyReadStdout() ), this, SLOT( readStdOutRetriveOpenvpnCiphers() ) );
		disconnect( NameAndPidOfProgramListenProcess, SIGNAL( readyReadStderr() ), this, SLOT( readStdErrRetriveOpenvpnCiphers() ) );

	}
	return NameAndPidOfProgramListen;
}

QString Utils::getEmailAddressOfCert(QString cert)
{
	if (cert.isEmpty())
		return "";

	GetEmailAddressOfCertProcess = new QProcess ( this );
	GetEmailAddressOfCertProcess->setCommunication( QProcess::Stdin | QProcess::Stdout | QProcess::Stderr | QProcess::DupStderr );
	GetEmailAddressOfCertProcess->addArgument( config->pathToOpenssl );
	GetEmailAddressOfCertProcess->addArgument( "x509");
	GetEmailAddressOfCertProcess->addArgument( "-noout");
	GetEmailAddressOfCertProcess->addArgument( "-in");
	GetEmailAddressOfCertProcess->addArgument( cert );
	GetEmailAddressOfCertProcess->addArgument( "-subject");

	connect( GetEmailAddressOfCertProcess, SIGNAL( readyReadStdout() ), this, SLOT( readOutGetEmailAddressOfCert() ) );

	if ( !GetEmailAddressOfCertProcess->start( env ) ) {
		kdError() << "GetEmailAddressOfCertProcess" << endl;
		return false;
	} else {
		while ( GetEmailAddressOfCertProcess->isRunning() )
			config->appPointer->processEvents();
		disconnect( GetEmailAddressOfCertProcess, SIGNAL( readyReadStdout() ), this, SLOT( readOutGetEmailAddressOfCert() ) );
	}

	return EmailAddressOfCert;
}

QStringList Utils::getSmartcardSlots(QString ProviderLib)
{
	SmartcardSlots.clear();

	ToolInfo *Pkcs11ToolInfo = getToolInfo( config, "pkcs11-tool" );
	Pkcs11ToolInfo->collectToolInfo();
// 	if (Pkcs11ToolInfo == 0)
// 		return SmartcardSlots;
	QString pathToPkcs11Tool;
	pathToPkcs11Tool = Pkcs11ToolInfo->PathToExec;

	if ( pathToPkcs11Tool.isEmpty() )
		return SmartcardSlots;

	GetSmartcardSlotsProcess = new QProcess( this );
	GetSmartcardSlotsProcess->setCommunication( QProcess::Stdin | QProcess::Stdout | QProcess::Stderr | QProcess::DupStderr );
	GetSmartcardSlotsProcess->addArgument( pathToPkcs11Tool);	
	if (!ProviderLib.isEmpty())
	{
		GetSmartcardSlotsProcess->addArgument( "--module");
		GetSmartcardSlotsProcess->addArgument( ProviderLib );
	}
	GetSmartcardSlotsProcess->addArgument( "-L" );

	connect( GetSmartcardSlotsProcess, SIGNAL( readyReadStdout() ), this, SLOT( readOutGetSmartcardSlots() ) );
	
	if ( !GetSmartcardSlotsProcess->start( env ) ) {
		kdError() << "Unable to fetch smartcard slots via pkcs11-tool!" << endl;
		return false;
	} else {
		while ( GetSmartcardSlotsProcess->isRunning() )
// 			usleep(500);
			config->appPointer->processEvents();

		disconnect( GetSmartcardSlotsProcess, SIGNAL( readyReadStdout() ), this, SLOT( readOutGetSmartcardSlots() ) );

	}
	return SmartcardSlots;
}

QStringList Utils::getSmartcardCertsFromSlot(QString slot,QString IdType,QString ProviderLib)
{
	Pkcs11CertFound=false;
	SmartcardCertsFromSlot.clear();

	if (!IdType.isEmpty())
		this->IdType= IdType;
	else
		this->IdType = "id";

	ToolInfo *Pkcs11ToolInfo = getToolInfo( config, "pkcs11-tool" );
	Pkcs11ToolInfo->collectToolInfo();
// 	if (Pkcs11ToolInfo == 0)
// 		return SmartcardSlots;
	QString pathToPkcs11Tool;
	pathToPkcs11Tool = Pkcs11ToolInfo->PathToExec;

	if ( pathToPkcs11Tool.isEmpty() )
		return SmartcardSlots;

	GetSmartcardCertsFromSlotProcess = new QProcess( this );
	GetSmartcardCertsFromSlotProcess->setCommunication( QProcess::Stdin | QProcess::Stdout | QProcess::Stderr | QProcess::DupStderr );
	GetSmartcardCertsFromSlotProcess->addArgument( pathToPkcs11Tool);	
	
	if (!ProviderLib.isEmpty())
	{
		GetSmartcardCertsFromSlotProcess->addArgument( "--module");
		GetSmartcardCertsFromSlotProcess->addArgument( ProviderLib );
	}

	GetSmartcardCertsFromSlotProcess->addArgument( "-O" );

	GetSmartcardCertsFromSlotProcess->addArgument( "--slot" );
	if (!slot.isEmpty())
		GetSmartcardCertsFromSlotProcess->addArgument( slot );
	else
		GetSmartcardCertsFromSlotProcess->addArgument("0");

	connect( GetSmartcardCertsFromSlotProcess, SIGNAL( readyReadStdout() ), this, SLOT( readOutGetSmartcardCertsFromSlot() ) );
	
	if ( !GetSmartcardCertsFromSlotProcess->start( env ) ) {
		kdError() << "Unable to fetch smartcard slots via pkcs11-tool!" << endl;
		return false;
	} else {

		while ( GetSmartcardCertsFromSlotProcess->isRunning() )
// 			usleep(500);
			config->appPointer->processEvents();

		disconnect( GetSmartcardCertsFromSlotProcess, SIGNAL( readyReadStdout() ), this, SLOT( readOutGetSmartcardCertsFromSlot() ) );

	}

	return SmartcardCertsFromSlot;
}

bool Utils::getNeedsPassphrase(QString key)
{
	
	if (key.isEmpty() || !QFile(key).exists())
		return false;

	needsPassphrase=false;

	//openssl rsa -noout -in client.key -passin pass:aaa
	
	ToolInfo *OpensslToolInfo = getToolInfo( config, "openssl" );
	OpensslToolInfo->collectToolInfo();

	QString pathToOpenssl = OpensslToolInfo->PathToExec;

	if ( pathToOpenssl.isEmpty() )
		return needsPassphrase;

	NeedsPassphraseProcess = new QProcess( this );
	NeedsPassphraseProcess->setCommunication( QProcess::Stdin | QProcess::Stdout | QProcess::Stderr | QProcess::DupStderr );
	NeedsPassphraseProcess->addArgument( pathToOpenssl);
	NeedsPassphraseProcess->addArgument("rsa");
	NeedsPassphraseProcess->addArgument("-noout");
	NeedsPassphraseProcess->addArgument("-in");
	NeedsPassphraseProcess->addArgument(key);
	NeedsPassphraseProcess->addArgument("-passin");
	NeedsPassphraseProcess->addArgument("pass:aaa");
	

	connect( NeedsPassphraseProcess, SIGNAL( readyReadStdout() ), this, SLOT( readOutNeedsPassphrase() ) );
	
	if ( !NeedsPassphraseProcess->start( env ) ) {
		kdError() << "Unable to start openssl!" << endl;
		return false;
	} else {
		while ( NeedsPassphraseProcess->isRunning() )
// 			usleep(500);
			config->appPointer->processEvents();

		disconnect( NeedsPassphraseProcess, SIGNAL( readyReadStdout() ), this, SLOT( readOutNeedsPassphrase() ) );

	}

	return needsPassphrase;
}

/* === Slots === */
void Utils::readStdOutCreateTunDev() {
	QString msg = QString( createProcess->readStderr() );
	kdDebug() << "readStdOutCreateTunDev(): " << msg << endl;
}

void Utils::readStdErrCreateTunDev() {
	QString msg = QString( createProcess->readStderr() );
	kdError() << "readStdErrCreateTunDev" << msg << endl;

}

void Utils::readStdOutLoadKernelModule() {
	QString msg = QString( ModprobeProcess->readStdout() );
	kdDebug() << "readStdErrreadStdOutLoadKernelModule" << msg << endl;
}

void Utils::readStdErrLoadKernelModule() {
	QString msg = QString( ModprobeProcess->readStderr() );
	// 	kdDebug() << "readStdErrreadStderrLoadKernelModule" << msg << endl;

	/* FATAL: Module <Name> not found. */
	if ( msg.find( "not found", 0, FALSE ) > -1 ) {
		modprobeSuccess = false;
	}

	if ( msg.find( "could not find module", 0 , FALSE ) > -1 ) {
		modprobeSuccess = false;
	}

	if ( msg.find( "not permitted", 0 , FALSE ) > -1 ) {
		modprobeSuccess = false;
	}
}

void Utils::readStdOutToolsTest() {}

void Utils::readStdErrToolsTest() {}

void Utils::readStdOutRetriveOpenvpnCiphers() {
	while ( OpenvpnCiphersProcess->canReadLineStdout() ) {
		QString msg = QString( OpenvpnCiphersProcess->readLineStdout() );
		if ( msg.contains( "default key" ) ) {
			//std::cout << msg.ascii() << std::endl;
			OpenvpnCiphers.append( msg.section( ' ', 0, 0 ) );
		}
	}
}

void Utils::readStdErrRetriveOpenvpnCiphers() {
	while ( OpenvpnCiphersProcess->canReadLineStderr() ) {
		QString msg = QString( OpenvpnCiphersProcess->readLineStderr() );

	}
}

void Utils::readStdOutRetriveOpenvpnDigests() {
	while ( OpenvpnDigestProcess->canReadLineStdout() ) {
		QString msg = QString( OpenvpnDigestProcess->readLineStdout() );
		OpenvpnDigestCount+=1;
		if ( OpenvpnDigestCount > 5 ) {
// 			std::cout << msg.simplifyWhiteSpace().ascii() << std::endl;
			OpenvpnDigestString += msg+"#";
		}
	}
}

void Utils::readStdErrRetriveOpenvpnDigests() {
	while ( OpenvpnDigestProcess->canReadLineStderr() ) {
		QString msg = QString( OpenvpnDigestProcess->readLineStderr() );

	}
}

void Utils::readStdOutGetNameAndPidOfProgramListen() {
	while ( NameAndPidOfProgramListenProcess->canReadLineStdout() ) {
		QString msg = QString( NameAndPidOfProgramListenProcess->readLineStdout() );
		if ( msg.contains( "/" ) and msg.contains( QString().setNum( ListenPort ) ) ) {
			std::cout << msg.ascii() << std::endl;
			NameAndPidOfProgramListen = ( msg.simplifyWhiteSpace().section( ' ', 5, 5 ) );
		}
	}
}

void Utils::readStdErrGetNameAndPidOfProgramListen() {
	while ( NameAndPidOfProgramListenProcess->canReadLineStderr() ) {
		QString msg = QString( NameAndPidOfProgramListenProcess->readLineStderr() );

	}
}

void Utils::readOutGetEmailAddressOfCert()
{
	while ( GetEmailAddressOfCertProcess->canReadLineStdout() ) {
		QString msg = QString( GetEmailAddressOfCertProcess->readLineStdout() );
		if ( msg.contains( "emailAddress" ) ) {
			std::cout << "msg: " << msg.ascii() << std::endl;
			QStringList fields = QStringList::split( '/', msg);
			for ( QStringList::iterator field = fields.begin();  field != fields.end();++field )
			{
				if (QString (*field).contains("emailAddress"))
				{
					if (config->KvpncDebugLevel > 2)
						std::cout << "field: " << QString(*field).ascii() << std::endl;
					// subject= /C=de/L=WR/O=crissi/CN=Christoph Thielecke/emailAddress=crissi99@gxm.de
					// crissi99@gxm.de
					EmailAddressOfCert = QString(*field).section('=',1,1);
					break;
				}
			}
			break;
		}
	}
}

void Utils::readOutGetSmartcardSlots()
{
	while ( GetSmartcardSlotsProcess->canReadLineStdout() ) {
		QString msg = QString( GetSmartcardSlotsProcess->readLineStdout() );
		
		if ( msg.contains( "Slot" ) && !msg.contains("empty") )
		if ( msg.find( "Slot", 0, FALSE ) > -1 && msg.find( "empty", 0, FALSE ) == -1  )
		{
			//std::cout << msg.ascii() << std::endl;
// 			KMessageBox::information( 0, i18n( "msg: %1" ).arg( msg.stripWhiteSpace() ), QString("foo") );
			// we put in this format: <id>:<name>
			QString id = msg.stripWhiteSpace().section( ' ', 1, 1 );
			QString name = msg.stripWhiteSpace().remove(QString("Slot "+id)).stripWhiteSpace();
			QString slot = id+" : "+name;
			SmartcardSlots.append( slot );
		}
	}
}

void Utils::readOutGetSmartcardCertsFromSlot()
{
	while ( GetSmartcardCertsFromSlotProcess->canReadLineStdout() ) {
		QString msg = QString( GetSmartcardCertsFromSlotProcess->readLineStdout() );
		if ( msg.contains( "Certificate Object" ) ) {
// 			KMessageBox::sorry( 0, QString("msg: "+msg), QString("foo1"),0 );
			Pkcs11CertFound=true;
		}
// 		KMessageBox::information( 0, i18n( "msg: %1" ).arg( msg ), QString("foo") );
		if (IdType == "id")
		{
			if ( msg.contains( "ID:" ) && Pkcs11CertFound==true ) {
				//std::cout << msg.ascii() << std::endl;
				QString msg2 = msg.section( ':', 1, 1 );
				msg2 = msg2.stripWhiteSpace();
// 				KMessageBox::sorry( 0, QString("id: "+msg), QString("foo"),0 );
				SmartcardCertsFromSlot.append( msg2 );
				Pkcs11CertFound=false;
			}
		}
		else if (IdType == "label")
		{
			if ( msg.contains( "label:" ) && Pkcs11CertFound==true ) {
				//std::cout << msg.ascii() << std::endl;
				QString msg2 = msg.section( ':', 1, 1 );
				msg2 = msg2.stripWhiteSpace();
// 				KMessageBox::sorry( 0, QString("label: "+msg2), QString("foo"),0 );
				SmartcardCertsFromSlot.append( msg2 );
				Pkcs11CertFound=false;
			}
		}
		else if (IdType == "subject")
		{
			if ( msg.contains( "Subject:" ) && Pkcs11CertFound==true ) {
				//std::cout << msg.ascii() << std::endl;
				QString msg2 = msg.section( ':', 1, 1 );
				msg2 = msg2.stripWhiteSpace();
// 				KMessageBox::sorry( 0, QString("subject: "+msg), QString("foo"),0 );
				SmartcardCertsFromSlot.append( msg2 );
				Pkcs11CertFound=false;
			}
		}
	}

}

void Utils::readOutNeedsPassphrase()
{
	while ( NeedsPassphraseProcess->canReadLineStdout() ) {
		QString msg = QString( NeedsPassphraseProcess->readLineStdout() );
// 		KMessageBox::sorry( 0, QString("msg: "+msg), QString("foo1"),0 );
		if ( msg.contains( "unable to load Private Key" ) ) {
			needsPassphrase=true;
		}
	}

}



#include "utils.moc"
