/***************************************************************************
*   Copyright (C) 2004 by Christoph Thielecke                             *
*   crissi99@gmx.de                                                       *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
//BEGIN INCLUDES
#include "preferencesdialog.h"
#include <qtabwidget.h>
#include <qpushbutton.h>
#include <klocale.h>
#include <qcheckbox.h>
#include <kmessagebox.h>
#include <qspinbox.h>
#include <kurlrequester.h>
#include <kcolordialog.h>
#include <kcombobox.h>
#include <qlabel.h>
#include <qstringlist.h>
#include <kiconloader.h>
#include <klineedit.h>
#include <kinputdialog.h>
#include <knuminput.h>
#include <klistview.h>
#include <ktextedit.h>
#include <qlayout.h>
#include "networkinterface.h"
#include "utils.h"
#include "importcertificatedialog.h"
#include "newprofiledialog.h"

#include <iostream>
//END INCLUDES

PreferencesDialog::PreferencesDialog( QWidget *parent, QApplication *app,QTextEdit *LogOutput, KVpncConfig *GlobalConfig,bool showOnlyProfiles ) : KDialogBase ( KDialogBase::TreeList, i18n("Preferences..."),
		        KDialogBase::Ok | KDialogBase::Apply|KDialogBase::Cancel | KDialogBase::Help,KDialogBase::Ok,
		        parent,"configdialog" )
{
	//main = new PreferencesDialogBase(this);

	//setMainWidget(main);

	//main->setMinimumSize(main->sizeHint())

	this->AccountList = GlobalConfig->AccountList;
	this->LogOutput = LogOutput;
	this->currentProfile = GlobalConfig->currentProfile;
	this->KvpncDebugLevel = GlobalConfig->KvpncDebugLevel;
	this->app = app;
	this->GlobalConfig = GlobalConfig;

	lastProfileName="";

	this->showOnlyProfiles=showOnlyProfiles;
	if (showOnlyProfiles)
	{
		setCaption(i18n("Manage profiles"));
	}
	setupGui();

	// 	DaemonOptionsWidget->ProgramsInPathcheckBox->setChecked(GlobalConfig->programsInPath);
	// 	programsInPathToggled(GlobalConfig->programsInPath);
	//
	unfoldTreeList ();
	if (!showOnlyProfiles)
	{
		DaemonOptionsWidget->RacoonDebugLevelComboBox->clear();
		DaemonOptionsWidget->RacoonDebugLevelComboBox->insertItem( "notify" );
		DaemonOptionsWidget->RacoonDebugLevelComboBox->insertItem( "debug" );
		DaemonOptionsWidget->RacoonDebugLevelComboBox->insertItem( "debug2" );

		DaemonOptionsWidget->VpncPathInput->setURL( GlobalConfig->pathToVpnc );
		DaemonOptionsWidget->RacoonPathInput->setURL( GlobalConfig->pathToRacoon );
		DaemonOptionsWidget->SetkeyPathInput->setURL( GlobalConfig->pathToSetkey );
		HelperProgramOptionsWidget->IptablesPathInput->setURL( GlobalConfig->pathToIptables );
		DaemonOptionsWidget->FreeswanPathInput->setURL( GlobalConfig->pathToFreeswan );
		HelperProgramOptionsWidget->OpenSSLPathInput->setURL( GlobalConfig->pathToOpenssl );
		DaemonOptionsWidget->PppdPathInput->setURL( GlobalConfig->pathToPppd );
		HelperProgramOptionsWidget->KillPathInput->setURL( GlobalConfig->pathToKill );
		HelperProgramOptionsWidget->KillallPathInput->setURL( GlobalConfig->pathToKillall );
		HelperProgramOptionsWidget->PingPathInput->setURL( GlobalConfig->pathToPing );
		DaemonOptionsWidget->OpenvpnPathInput->setURL( GlobalConfig->pathToOpenvpn );
		ConnectOptionsWidget->checkMinimizeAfterConnectCheck->setChecked( GlobalConfig->minimizeAfterConnect );
		DebugOptionsWidget->showDebugCheck->setChecked( GlobalConfig->showDebugConsole );
		DebugOptionsWidget->WriteLogCheck->setChecked( GlobalConfig->writeLogFile );
		DebugOptionsWidget->spinKvpncDebugLevel->setValue ( GlobalConfig->KvpncDebugLevel );
		DaemonOptionsWidget->RacoonDebugLevelComboBox->setCurrentText ( GlobalConfig->RacoonDebugLevel );
		DaemonOptionsWidget->spinVpncDebugLevel->setValue ( GlobalConfig->VpncDebugLevel );
		DaemonOptionsWidget->spinOpenvpnDebugLevel->setValue ( GlobalConfig->OpenvpnDebugLevel );
		DaemonOptionsWidget->DebugPppdcheckBox->setChecked(GlobalConfig->enableDebugPppd);
		ConnectOptionsWidget->spinTryConnectTimeout->setValue( GlobalConfig->tryConnectTimeout );
		ConnectOptionsWidget->SilentQuitcheckBox->setChecked( GlobalConfig->useSilentQuit );
		DebugOptionsWidget->DontQuitOnCloseEventCheckBox->setChecked( GlobalConfig->dontQuitOnCloseEvent );
		DaemonOptionsWidget->ProgramsInPathcheckBox->setChecked(GlobalConfig->programsInPath);
		DebugOptionsWidget->KeepConnectionFilesCheckBox->setChecked(GlobalConfig->holdGeneratedScripts);
		LogOptionsWidget->InfoLogLabel->setPaletteBackgroundColor (GlobalConfig->InfoLogColor);
		LogOptionsWidget->RemoteLogLabel->setPaletteBackgroundColor (GlobalConfig->RemoteLogColor);
		LogOptionsWidget->ErrorLogLabel->setPaletteBackgroundColor (GlobalConfig->ErrorLogColor);
		LogOptionsWidget->SuccessLogLabel->setPaletteBackgroundColor (GlobalConfig->SuccessLogColor);
		LogOptionsWidget->DebugLogLabel->setPaletteBackgroundColor (GlobalConfig->DebugLogColor);
		LogOptionsWidget->UseColorizedLogOutputcheckBox->setChecked(GlobalConfig->useColorizedLogOutput);
		DaemonOptionsWidget->ShowInterfaceIPinTooltipCheckBox->setChecked(GlobalConfig->showInterfaceIPinTooltip);
		ConnectOptionsWidget->DoAutoConnectCheckBox->setChecked(GlobalConfig->doAutoConnectAtStartup);
		LogOptionsWidget->LogFontSizeSpinBox->setValue(GlobalConfig->LogViewerFontSize);

		bool profileInList=false;
		for (uint i=0; i < GlobalConfig->AccountList->count();i++)
		{
			ConnectOptionsWidget->AutoConnectProfileComboBox->insertItem(GlobalConfig->AccountList->at(i)->getName());
			if ( GlobalConfig->AccountList->at(i)->getName() == GlobalConfig->AutoConnectProfile)
			{
				profileInList=true;
			}
		}

		if (profileInList)
		{
			ConnectOptionsWidget->AutoConnectProfileComboBox->setCurrentText(GlobalConfig->AutoConnectProfile);
		}
		else
		{
			GlobalConfig->doAutoConnectAtStartup=false;
			ConnectOptionsWidget->DoAutoConnectCheckBox->setChecked(GlobalConfig->doAutoConnectAtStartup);
		}
	}
	KDialogBase::adjustSize();

	// TODO read types from list
	ProfileGeneralOptionsWidget->ConnectionTypeComboBox->insertItem( i18n( "Cisco (vpnc)" ), VpnAccountData::cisco );
	ProfileGeneralOptionsWidget->ConnectionTypeComboBox->insertItem( i18n( "IPSec (racoon)" ), VpnAccountData::racoon );
	ProfileGeneralOptionsWidget->ConnectionTypeComboBox->insertItem( i18n( "IPSec (FreeSWAN)" ), VpnAccountData::freeswan );
	ProfileGeneralOptionsWidget->ConnectionTypeComboBox->insertItem( i18n( "PPTP" ), VpnAccountData::pptp );
	ProfileGeneralOptionsWidget->ConnectionTypeComboBox->insertItem( i18n( "OpenVPN" ), VpnAccountData::openvpn );
	//ConnectionTypeComboBox->insertItem( "-", 5 );

	ProfileOpenvpnOptionsWidget->TunnelDeviceTypeComboBox->insertItem( "tun" );
	ProfileOpenvpnOptionsWidget->TunnelDeviceTypeComboBox->insertItem( "tap" );

	profileAddedOrDeleted = false;
	NewProfileName="";

	// profile data
	VpnAccountData * it;
	for ( it = GlobalConfig->AccountList->first(); it; it = GlobalConfig->AccountList->next() )
	{
		if (it != 0 )
		{
			//KMessageBox::information(0,"item found",it->getName());

			ProfileGeneralOptionsWidget->ProfileComboBox->insertItem(it->getName() );
			ProfileNetworkRouteOptionsWidget->ProfileComboBox->insertItem(it->getName() );
			ProfileNetworkNatOptionsWidget->ProfileComboBox->insertItem(it->getName() );
			ProfileNetworkVirtualIpOptionsWidget->ProfileComboBox->insertItem(it->getName() );
			ProfileCertPskOptionsWidget->ProfileComboBox->insertItem(it->getName() );
			ProfileUserOptionsWidget->ProfileComboBox->insertItem(it->getName() );
			ProfileOpenvpnOptionsWidget->ProfileComboBox->insertItem(it->getName() );
			ProfilePptpOptionsWidget->ProfileComboBox->insertItem(it->getName() );
			ProfileRacoonOptionsWidget->ProfileComboBox->insertItem(it->getName() );
			ProfileCiscoOptionsWidget->ProfileComboBox->insertItem(it->getName() );
			ProfileCmdExecBeforeConnectOptionsWidget->ProfileComboBox->insertItem(it->getName() );
			ProfileCmdExecBeforeDisconnectOptionsWidget->ProfileComboBox->insertItem(it->getName() );
			ProfileCmdExecAfterConnectOptionsWidget->ProfileComboBox->insertItem(it->getName() );
			ProfileCmdExecAfterDisconnectOptionsWidget->ProfileComboBox->insertItem(it->getName() );
		}
	}

	if ( !GlobalConfig->AccountList->isEmpty() )
	{
		if ( GlobalConfig->currentProfile != 0 )
		{
			ProfileGeneralOptionsWidget->ProfileComboBox->setCurrentText( GlobalConfig->currentProfile->getName() );
			ProfileNetworkRouteOptionsWidget->ProfileComboBox->setCurrentText( GlobalConfig->currentProfile->getName() );
			ProfileNetworkNatOptionsWidget->ProfileComboBox->setCurrentText( GlobalConfig->currentProfile->getName() );
			ProfileNetworkVirtualIpOptionsWidget->ProfileComboBox->setCurrentText( GlobalConfig->currentProfile->getName() );
			ProfileCertPskOptionsWidget->ProfileComboBox->setCurrentText( GlobalConfig->currentProfile->getName() );
			ProfileUserOptionsWidget->ProfileComboBox->setCurrentText( GlobalConfig->currentProfile->getName() );
			ProfileOpenvpnOptionsWidget->ProfileComboBox->setCurrentText( GlobalConfig->currentProfile->getName() );
			ProfilePptpOptionsWidget->ProfileComboBox->setCurrentText( GlobalConfig->currentProfile->getName() );
			ProfileRacoonOptionsWidget->ProfileComboBox->setCurrentText( GlobalConfig->currentProfile->getName() );
			ProfileCiscoOptionsWidget->ProfileComboBox->setCurrentText( GlobalConfig->currentProfile->getName() );
			ProfileCmdExecBeforeConnectOptionsWidget->ProfileComboBox->setCurrentText( GlobalConfig->currentProfile->getName() );
			ProfileCmdExecBeforeDisconnectOptionsWidget->ProfileComboBox->setCurrentText( GlobalConfig->currentProfile->getName() );
			ProfileCmdExecAfterConnectOptionsWidget->ProfileComboBox->setCurrentText( GlobalConfig->currentProfile->getName() );
			ProfileCmdExecAfterDisconnectOptionsWidget->ProfileComboBox->setCurrentText( GlobalConfig->currentProfile->getName() );
		}
		else
		{
			ProfileGeneralOptionsWidget->ProfileComboBox->setCurrentText( "" );
			ProfileNetworkRouteOptionsWidget->ProfileComboBox->setCurrentText( "" );
			ProfileNetworkNatOptionsWidget->ProfileComboBox->setCurrentText( "" );
			ProfileNetworkVirtualIpOptionsWidget->ProfileComboBox->setCurrentText( "" );
			ProfileCertPskOptionsWidget->ProfileComboBox->setCurrentText( "" );
			ProfileUserOptionsWidget->ProfileComboBox->setCurrentText( "" );
			ProfileOpenvpnOptionsWidget->ProfileComboBox->setCurrentText( "" );
			ProfilePptpOptionsWidget->ProfileComboBox->setCurrentText( "" );
			ProfileRacoonOptionsWidget->ProfileComboBox->setCurrentText( "" );
			ProfileCiscoOptionsWidget->ProfileComboBox->setCurrentText( "" );
			ProfileCmdExecBeforeConnectOptionsWidget->ProfileComboBox->setCurrentText( "" );
			ProfileCmdExecBeforeDisconnectOptionsWidget->ProfileComboBox->setCurrentText( "" );
			ProfileCmdExecAfterConnectOptionsWidget->ProfileComboBox->setCurrentText( "" );
			ProfileCmdExecAfterDisconnectOptionsWidget->ProfileComboBox->setCurrentText( "" );

		}
	}
	else
	{
		ProfileGeneralOptionsWidget->AdvancedSettingsPushButton->setEnabled( false );
		ProfileGeneralOptionsWidget->RenameSessionPushButton->setEnabled( false );
		ProfileGeneralOptionsWidget->DeleteSessionPushButton->setEnabled( false );
		ProfileGeneralOptionsWidget->SaveSessionPushButton->setEnabled( false );
	}


	NetworkInterface iface(GlobalConfig->appPointer);
	QStringList list = iface.getAllNetworkInterfaces();
	ProfileGeneralOptionsWidget->NetworkDeviceComboBox->insertItem( "default" );
	if ( GlobalConfig->currentProfile != 0 )
	{
		for ( QStringList::Iterator it = list.begin(); it != list.end(); ++it )
		{
			ProfileGeneralOptionsWidget->NetworkDeviceComboBox->insertItem( QString( *it ) );
		}
		ProfileGeneralOptionsWidget->NetworkDeviceComboBox->setEnabled( true );
		ProfileGeneralOptionsWidget->LabelNetworkDevice->setEnabled( true );

		if ( GlobalConfig->currentProfile->getAuthType() == VpnAccountData::cert )
			ProfileCertPskOptionsWidget->AuthTypeComboBox->setCurrentText( i18n( "X.509 certificate" ) );

		if ( GlobalConfig->currentProfile->getAuthType() == VpnAccountData::psk )
			ProfileCertPskOptionsWidget->AuthTypeComboBox->setCurrentText( i18n( "Pre shared key" ) );

		if (GlobalConfig->currentProfile->getConnectionType() != VpnAccountData::ConnectionType(VpnAccountData::openvpn))
			ProfileCertPskOptionsWidget->PSKLineEdit->setText( GlobalConfig->currentProfile->getPreSharedKey() );
		else
			ProfileCertPskOptionsWidget->PSKFileURLRequester->setURL(GlobalConfig->currentProfile->getPreSharedKeyFile());

		if ( GlobalConfig->currentProfile->getDoPingIP() )
			ProfileGeneralOptionsWidget->PingIPLineEdit->setEnabled( true );
		else
			ProfileGeneralOptionsWidget->PingIPLineEdit->setEnabled( false );

		ProfileGeneralOptionsWidget->UseConnectionStatusCheckCheckBox->setChecked( GlobalConfig->currentProfile->getUseConnectionStatusCheck() );
		ProfileGeneralOptionsWidget->ConnectionStatusSuccessCountNumInput->setValue(GlobalConfig->currentProfile->getConnectionStatusCheckSuccessCount());
		ProfileGeneralOptionsWidget->ConnectionStatusCheckIntervalNumInput->setValue(GlobalConfig->currentProfile->getConnectionStatusInterval());
		ProfileGeneralOptionsWidget->DoReconnectAfterConnectionLostCheckBox->setChecked(GlobalConfig->currentProfile->getDoReconnectAfterConnectionLost());

		ProfileCertPskOptionsWidget->RemoteIDLineEdit->setEnabled( false );

		ProfileNetworkRouteOptionsWidget->UseExtraNetworkRoutesCheckbox->setChecked(GlobalConfig->currentProfile->getUseAdditionalNetworkRoutes());

		ProfileNetworkRouteOptionsWidget->NetworkListView->clear();
		QStringList AdditionalNetworkRoutes = GlobalConfig->currentProfile->getAdditionalNetworkRoutes();

		for (QStringList::Iterator it2 = AdditionalNetworkRoutes.begin() ; it2 != AdditionalNetworkRoutes.end(); ++it2 )
		{
			QString networkstring = *it2;
			QString Network = networkstring.section('#',0,0).section('/',0,0);
			QString Netmask = networkstring.section('#',0,0).section('/',1,1);
			QString Gateway = networkstring.section('#',1,1).section('/',0,0);

			ProfileNetworkRouteOptionsWidget->NetworkListView->insertItem(new QListViewItem(ProfileNetworkRouteOptionsWidget->NetworkListView,Network,Netmask,Gateway));

		}

		ProfileCertPskOptionsWidget->UseSpecialServerCertificateCheckBox->setChecked( GlobalConfig->currentProfile->getUseSpecialServerCertificate() );

		if ( GlobalConfig->currentProfile != 0 )
		{
			if ( GlobalConfig->currentProfile->getUseSpecialServerCertificate())
				ProfileCertPskOptionsWidget->SpecialServerCertificateURLRequester->setURL(GlobalConfig->currentProfile->getSpecialServerCertificate());
		}
		connectionTypeChanged( ProfileGeneralOptionsWidget->ConnectionTypeComboBox->currentItem() );
		authTypeChanged( ProfileCertPskOptionsWidget->AuthTypeComboBox->currentItem() );

		// FIXME
		profileChanged( ProfileGeneralOptionsWidget->ProfileComboBox->currentText() );

	}

	// 	// pppd settings
	ProfilePptpOptionsWidget->DnsServerLineedit->setEnabled( false );
	ProfilePptpOptionsWidget->MtuSpinbox->setEnabled( false );

	//FIXME -> no virtual IP's yet
	ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->setChecked(false);
	ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->setEnabled(false);
	ProfileNetworkVirtualIpOptionsWidget->RemoteVirtualIpLineEdit->setEnabled(false);
	ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->setEnabled(false);
	ProfileNetworkVirtualIpOptionsWidget->LabelRemoteVirtualIp->setEnabled(false);
	ProfileNetworkVirtualIpOptionsWidget->LabelLocalVirtualIp->setEnabled(false);

	if ( GlobalConfig->currentProfile != 0 )
	{
		if ( GlobalConfig->currentProfile->getUseUserdefinedPort() )
		{
			ProfileOpenvpnOptionsWidget->UseUserdefinedPortCheckBox->setChecked(true);
			ProfileOpenvpnOptionsWidget->UserdefinedPortSpinBox->setEnabled(true);
		}
		else
		{
			ProfileOpenvpnOptionsWidget->UseUserdefinedPortCheckBox->setChecked(false);
			ProfileOpenvpnOptionsWidget->UserdefinedPortSpinBox->setEnabled(false);
		}

		if ( GlobalConfig->currentProfile->getUseNsCertType())
		{
			ProfileOpenvpnOptionsWidget->UseNsCertTypeCheckBox->setChecked(true);
			ProfileOpenvpnOptionsWidget->NsCertTypeComboBox->setEnabled(true);
		}
		else
		{
			ProfileOpenvpnOptionsWidget->UseNsCertTypeCheckBox->setChecked(false);
			ProfileOpenvpnOptionsWidget->NsCertTypeComboBox->setEnabled(false);
		}

		if ( GlobalConfig->currentProfile->getDisableLzoCompression())
		{
			ProfileOpenvpnOptionsWidget->DisableLzoCompressionCheckBox->setChecked(false);
		}
		else
		{
			ProfileOpenvpnOptionsWidget->DisableLzoCompressionCheckBox->setChecked(true);
		}

		ProfileOpenvpnOptionsWidget->UserdefinedPortSpinBox->setValue(GlobalConfig->currentProfile->getUserdefinedPort());
	}
	KDialogBase::adjustSize();
}

void PreferencesDialog::setupGui()
{

	setShowIconsInTreeList(true);

	QStringList path;
	path.clear();
	path << i18n("KVpnc");
	setFolderIcon (path, SmallIcon("kvpnc-application", KIcon::SizeSmall));

	path.clear();

	QVBoxLayout *lo;

	if (!showOnlyProfiles)
	{
		/* called as preferences dialog */

		// General page
		path << i18n("Application") << i18n("Debug");
		QFrame* DebugFrame = addPage(path, i18n("Debug"), BarIcon("bug", KIcon::SizeSmall));
		lo = new QVBoxLayout( DebugFrame );
		lo->setSpacing(KDialog::spacingHint());
		DebugOptionsWidget = new ConfigDebugOptions(DebugFrame);
		DebugFrame->resize(DebugFrame->sizeHint());

		path.clear();
		path << i18n("Application") << i18n("Connect");
		QFrame* ConnectFrame = addPage(path, i18n("Connect"), BarIcon("kvpnc-connecting", KIcon::SizeSmall));
		lo = new QVBoxLayout( ConnectFrame );
		lo->setSpacing(KDialog::spacingHint());
		ConnectOptionsWidget = new ConfigConnectOptions(ConnectFrame);
		ConnectOptionsWidget->resize(ConnectOptionsWidget->sizeHint());
		ConnectFrame->resize(ConnectFrame->sizeHint());

		path.clear();
		path << i18n("Application") << i18n("Log");
		QFrame* LogFrame = addPage(path, i18n("Log"), BarIcon("text_center", KIcon::SizeSmall));
		lo = new QVBoxLayout( LogFrame );
		lo->setSpacing(KDialog::spacingHint());
		LogOptionsWidget = new ConfigLogOptions(LogFrame);
		LogOptionsWidget->resize(LogOptionsWidget->sizeHint());
		LogFrame->resize(LogFrame->sizeHint());

		path << i18n("Programs");
		setFolderIcon (path, SmallIcon("kvpnc", KIcon::SizeSmall));

		path.clear();
		path << i18n("Programs") << i18n("Daemons");
		QFrame* DaemonFrame = addPage(path, i18n("Daemons"), BarIcon("fork", KIcon::SizeSmall));
		lo = new QVBoxLayout( DaemonFrame );
		lo->setSpacing(KDialog::spacingHint());
		DaemonOptionsWidget = new ConfigDaemonOptions(DaemonFrame);
		DaemonOptionsWidget->resize(DaemonOptionsWidget->sizeHint());
		DaemonFrame->resize(DaemonFrame->sizeHint());

		path.clear();
		path << i18n("Programs") << i18n("Helper programs");
		QFrame* HelperProgramFrame = addPage(path, i18n("Helper programs"), BarIcon("tool", KIcon::SizeSmall));
		lo = new QVBoxLayout( HelperProgramFrame );
		lo->setSpacing(KDialog::spacingHint());
		HelperProgramOptionsWidget = new ConfigHelperProgramOptions(HelperProgramFrame);
		HelperProgramOptionsWidget->resize(HelperProgramOptionsWidget->sizeHint());
		HelperProgramFrame->resize(HelperProgramFrame->sizeHint());
	}
	// Profile page
	path.clear();
	path << i18n("Profile");
	setFolderIcon (path, SmallIcon("view_icon", KIcon::SizeSmall));

	path.clear();
	path << i18n("Profile") << i18n("General");
	QFrame* ProfileGeneralOptionsFrame = addPage(path, i18n("General"), BarIcon("application", KIcon::SizeSmall));
	lo = new QVBoxLayout( ProfileGeneralOptionsFrame );
	lo->setSpacing(KDialog::spacingHint());
	ProfileGeneralOptionsWidget = new ProfileGeneralOptions(ProfileGeneralOptionsFrame, GlobalConfig);
	ProfileGeneralOptionsWidget->resize(ProfileGeneralOptionsWidget->sizeHint());
	ProfileGeneralOptionsFrame->resize(ProfileGeneralOptionsFrame->sizeHint());

	path.clear();
	path << i18n("Profile") << i18n("Network");

	path.clear();
	path << i18n("Profile") << i18n("Network") << i18n("Routes");
	QFrame* ProfileNetworkRouteOptionsFrame = addPage(path, i18n("Routes"), BarIcon("kvpnc-route", KIcon::SizeSmall));
	lo = new QVBoxLayout( ProfileNetworkRouteOptionsFrame );
	lo->setSpacing(KDialog::spacingHint());
	ProfileNetworkRouteOptionsWidget = new ProfileNetworkRouteOptions(ProfileNetworkRouteOptionsFrame);
	//ProfileNetworkRouteOptionsWidget->resize(ProfileNetworkRouteOptionsWidget->sizeHint());
	ProfileNetworkRouteOptionsFrame->resize(ProfileNetworkRouteOptionsFrame->sizeHint());

	path.clear();
	path << i18n("Profile") << i18n("Network") << i18n("NAT");
	QFrame* ProfileNetworkNatOptionsFrame = addPage(path, i18n("NAT"), BarIcon("application", KIcon::SizeSmall));
	lo = new QVBoxLayout( ProfileNetworkNatOptionsFrame );
	lo->setSpacing(KDialog::spacingHint());
	ProfileNetworkNatOptionsWidget = new ProfileNetworkNatOptions(ProfileNetworkNatOptionsFrame);
	ProfileNetworkNatOptionsWidget->resize(ProfileNetworkNatOptionsWidget->sizeHint());
	ProfileNetworkNatOptionsFrame->resize(ProfileNetworkNatOptionsFrame->sizeHint());

	path.clear();
	path << i18n("Profile") << i18n("Virtual IP");
	QFrame* ProfileNetworkVirtualIpOptionsFrame = addPage(path, i18n("Virtual IP"), BarIcon("application", KIcon::SizeSmall));
	lo = new QVBoxLayout( ProfileNetworkVirtualIpOptionsFrame );
	lo->setSpacing(KDialog::spacingHint());
	ProfileNetworkVirtualIpOptionsWidget = new ProfileNetworkVirtualIpOptions(ProfileNetworkVirtualIpOptionsFrame);
	ProfileNetworkVirtualIpOptionsWidget->resize(ProfileNetworkVirtualIpOptionsWidget->sizeHint());
	ProfileNetworkVirtualIpOptionsFrame->resize(ProfileNetworkVirtualIpOptionsFrame->sizeHint());

	path.clear();
	path << i18n("Profile") << i18n("Certificate/PSK");
	QFrame* ProfileCertPskOptionsFrame = addPage(path, i18n("Certificate/PSK"), BarIcon("kvpnc-certimport", KIcon::SizeSmall));
	lo = new QVBoxLayout( ProfileCertPskOptionsFrame );
	lo->setSpacing(KDialog::spacingHint());
	ProfileCertPskOptionsWidget = new ProfileCertPskOptions(ProfileCertPskOptionsFrame);
	//ProfileCertPskOptionsWidget->resize(ProfileCertPskOptionsWidget->sizeHint());
	ProfileCertPskOptionsFrame->resize(ProfileCertPskOptionsFrame->sizeHint());


	path.clear();
	path << i18n("Profile") << i18n("User data");
	QFrame* ProfileUserOptionsFrame = addPage(path, i18n("User data"), BarIcon("kvpnc-user", KIcon::SizeSmall));
	lo = new QVBoxLayout( ProfileUserOptionsFrame );
	lo->setSpacing(KDialog::spacingHint());
	ProfileUserOptionsWidget = new ProfileUserOptions(ProfileUserOptionsFrame);
	ProfileUserOptionsWidget->resize(ProfileUserOptionsWidget->sizeHint());
	ProfileUserOptionsFrame->resize(ProfileUserOptionsFrame->sizeHint());

	path.clear();
	path << i18n("Profile") << i18n("Cisco");
	QFrame* ProfileCiscoOptionsFrame = addPage(path, i18n("Cisco"), BarIcon("kvpnc-cisco", KIcon::SizeSmall));
	lo = new QVBoxLayout( ProfileCiscoOptionsFrame );
	lo->setSpacing(KDialog::spacingHint());
	ProfileCiscoOptionsWidget = new ProfileCiscoOptions(ProfileCiscoOptionsFrame);
	ProfileCiscoOptionsWidget->resize(ProfileCiscoOptionsWidget->sizeHint());
	ProfileCiscoOptionsFrame->resize(ProfileCiscoOptionsFrame->sizeHint());

	path.clear();
	path << i18n("Profile") << i18n("Racoon");
	QFrame* ProfileRacoonOptionsFrame = addPage(path, i18n("Racoon"), BarIcon("kvpnc-kame", KIcon::SizeSmall));
	lo = new QVBoxLayout( ProfileRacoonOptionsFrame );
	lo->setSpacing(KDialog::spacingHint());
	ProfileRacoonOptionsWidget = new ProfileRacoonOptions(ProfileRacoonOptionsFrame);
	ProfileRacoonOptionsWidget->resize(ProfileRacoonOptionsWidget->sizeHint());
	ProfileRacoonOptionsFrame->resize(ProfileRacoonOptionsFrame->sizeHint());

	path.clear();
	path << i18n("Profile") << i18n("OpenVPN");
	QFrame* ProfileOpenvpnOptionsFrame = addPage(path, i18n("OpenVPN"), BarIcon("application", KIcon::SizeSmall));
	lo = new QVBoxLayout( ProfileOpenvpnOptionsFrame );
	lo->setSpacing(KDialog::spacingHint());
	ProfileOpenvpnOptionsWidget = new ProfileOpenvpnOptions(ProfileOpenvpnOptionsFrame);
	ProfileOpenvpnOptionsWidget->resize(ProfileOpenvpnOptionsWidget->sizeHint());
	ProfileOpenvpnOptionsFrame->resize(ProfileOpenvpnOptionsFrame->sizeHint());

	path.clear();
	path << i18n("Profile") << i18n("PPTP");
	QFrame* ProfilePptpOptionsFrame = addPage(path, i18n("PPTP"), BarIcon("application", KIcon::SizeSmall));
	lo = new QVBoxLayout( ProfilePptpOptionsFrame );
	lo->setSpacing(KDialog::spacingHint());
	ProfilePptpOptionsWidget = new ProfilePptpOptions(ProfilePptpOptionsFrame);
	//ProfilePptpOptionsWidget->resize(ProfilePptpOptionsWidget->sizeHint());
	ProfilePptpOptionsFrame->resize(ProfilePptpOptionsFrame->sizeHint());

	path.clear();
	path << i18n("Profile") << i18n("Command execution");

	path.clear();
	path << i18n("Profile") << i18n("Command execution") << i18n("Before connect");
	QFrame* ProfileCmdExecBeforeConnectOptionsFrame = addPage(path, i18n("Before connect"), BarIcon("exec", KIcon::SizeSmall));
	lo = new QVBoxLayout( ProfileCmdExecBeforeConnectOptionsFrame );
	lo->setSpacing(KDialog::spacingHint());
	ProfileCmdExecBeforeConnectOptionsWidget = new ProfileCmdExecBeforeConnectOptions(ProfileCmdExecBeforeConnectOptionsFrame);
	ProfileCmdExecBeforeConnectOptionsWidget->resize(ProfileCmdExecBeforeConnectOptionsWidget->sizeHint());
	ProfileCmdExecBeforeConnectOptionsFrame->resize(ProfileCmdExecBeforeConnectOptionsFrame->sizeHint());

	path.clear();
	path << i18n("Profile") << i18n("Command execution") << i18n("After connect");
	QFrame* ProfileCmdExecAfterConnectOptionsFrame = addPage(path, i18n("After connect"), BarIcon("exec", KIcon::SizeSmall));
	lo = new QVBoxLayout( ProfileCmdExecAfterConnectOptionsFrame );
	lo->setSpacing(KDialog::spacingHint());
	ProfileCmdExecAfterConnectOptionsWidget = new ProfileCmdExecAfterConnectOptions(ProfileCmdExecAfterConnectOptionsFrame);
	ProfileCmdExecAfterConnectOptionsWidget->resize(ProfileCmdExecAfterConnectOptionsWidget->sizeHint());
	ProfileCmdExecAfterConnectOptionsFrame->resize(ProfileCmdExecAfterConnectOptionsFrame->sizeHint());

	path.clear();
	path << i18n("Profile") << i18n("Command execution") << i18n("Before disconnect");
	QFrame* ProfileCmdExecBeforeDisconnectOptionsFrame = addPage(path, i18n("Before disconnect"), BarIcon("exec", KIcon::SizeSmall));
	lo = new QVBoxLayout( ProfileCmdExecBeforeDisconnectOptionsFrame );
	lo->setSpacing(KDialog::spacingHint());
	ProfileCmdExecBeforeDisconnectOptionsWidget = new ProfileCmdExecBeforeDisconnectOptions(ProfileCmdExecBeforeDisconnectOptionsFrame);
	ProfileCmdExecBeforeDisconnectOptionsWidget->resize(ProfileCmdExecBeforeDisconnectOptionsWidget->sizeHint());
	ProfileCmdExecBeforeDisconnectOptionsFrame->resize(ProfileCmdExecBeforeDisconnectOptionsFrame->sizeHint());

	path.clear();
	path << i18n("Profile") << i18n("Command execution") << i18n("After disconnect");
	QFrame* ProfileCmdExecAfterDisconnectOptionsFrame = addPage(path, i18n("Command execute after disconnect"), BarIcon("exec", KIcon::SizeSmall));
	lo = new QVBoxLayout( ProfileCmdExecAfterDisconnectOptionsFrame );
	lo->setSpacing(KDialog::spacingHint());
	ProfileCmdExecAfterDisconnectOptionsWidget = new ProfileCmdExecAfterDisconnectOptions(ProfileCmdExecAfterDisconnectOptionsFrame);
	ProfileCmdExecAfterDisconnectOptionsWidget->resize(ProfileCmdExecAfterDisconnectOptionsWidget->sizeHint());
	ProfileCmdExecAfterDisconnectOptionsFrame->resize(ProfileCmdExecAfterDisconnectOptionsFrame->sizeHint());

	adjustSize();

	/* connect profile combobox of each profile widget */
	connect( ProfileGeneralOptionsWidget->ProfileComboBox, SIGNAL( activated ( const QString& ) ), this, SLOT( profileChanged( const QString& ) ) );
	connect( ProfileNetworkRouteOptionsWidget->ProfileComboBox, SIGNAL( activated ( const QString& ) ), this, SLOT( profileChanged( const QString& ) ) );
	connect( ProfileNetworkNatOptionsWidget->ProfileComboBox, SIGNAL( activated ( const QString& ) ), this, SLOT( profileChanged( const QString& ) ) );
	connect( ProfileNetworkVirtualIpOptionsWidget->ProfileComboBox, SIGNAL( activated ( const QString& ) ), this, SLOT( profileChanged( const QString& ) ) );
	connect( ProfileCertPskOptionsWidget->ProfileComboBox, SIGNAL( activated ( const QString& ) ), this, SLOT( profileChanged( const QString& ) ) );
	connect( ProfileUserOptionsWidget->ProfileComboBox, SIGNAL( activated ( const QString& ) ), this, SLOT( profileChanged( const QString& ) ) );
	connect( ProfileOpenvpnOptionsWidget->ProfileComboBox, SIGNAL( activated ( const QString& ) ), this, SLOT( profileChanged( const QString& ) ) );
	connect( ProfilePptpOptionsWidget->ProfileComboBox, SIGNAL( activated ( const QString& ) ), this, SLOT( profileChanged( const QString& ) ) );
	connect( ProfileRacoonOptionsWidget->ProfileComboBox, SIGNAL( activated ( const QString& ) ), this, SLOT( profileChanged( const QString& ) ) );
	connect( ProfileCiscoOptionsWidget->ProfileComboBox, SIGNAL( activated ( const QString& ) ), this, SLOT( profileChanged( const QString& ) ) );
	connect( ProfileCmdExecBeforeConnectOptionsWidget->ProfileComboBox, SIGNAL( activated ( const QString& ) ), this, SLOT( profileChanged( const QString& ) ) );
	connect( ProfileCmdExecBeforeDisconnectOptionsWidget->ProfileComboBox, SIGNAL( activated ( const QString& ) ), this, SLOT( profileChanged( const QString& ) ) );
	connect( ProfileCmdExecAfterConnectOptionsWidget->ProfileComboBox, SIGNAL( activated ( const QString& ) ), this, SLOT( profileChanged( const QString& ) ) );
	connect( ProfileCmdExecAfterDisconnectOptionsWidget->ProfileComboBox, SIGNAL( activated ( const QString& ) ), this, SLOT( profileChanged( const QString& ) ) );

	connect( ProfileCertPskOptionsWidget->AuthTypeComboBox, SIGNAL( activated ( int ) ), this, SLOT( authTypeChanged( int ) ) );

	connect ( ProfileGeneralOptionsWidget->NewSessionPushButton , SIGNAL(clicked ()), this, SLOT(newSessionClicked()));
	connect ( ProfileGeneralOptionsWidget->SaveSessionPushButton, SIGNAL(clicked ()), this, SLOT(saveSessionClicked()));
	connect ( ProfileGeneralOptionsWidget->RenameSessionPushButton, SIGNAL(clicked ()), this, SLOT(renameSessionClicked()));
	connect ( ProfileGeneralOptionsWidget->DeleteSessionPushButton, SIGNAL(clicked ()), this, SLOT(deleteSessionClicked()));
	connect ( ProfileGeneralOptionsWidget->ImportCertificatePushButton, SIGNAL(clicked ()), this, SLOT(importCertificate()));

	connect ( this, SIGNAL(aboutToShowPage(QWidget *)), this, SLOT(pageChanged(QWidget *)));

	connect ( this, SIGNAL(applyClicked ()), this, SLOT(saveSessionClicked()));

}

void PreferencesDialog::accept()
{
	//MyprofileWidget->saveSessionClicked();
	if (!showOnlyProfiles)
	{
		GlobalConfig->pathToVpnc = DaemonOptionsWidget->VpncPathInput->url();
		GlobalConfig->pathToSetkey = DaemonOptionsWidget->SetkeyPathInput->url();
		GlobalConfig->pathToRacoon = DaemonOptionsWidget->RacoonPathInput->url();
		GlobalConfig->pathToIptables = HelperProgramOptionsWidget->IptablesPathInput->url();
		GlobalConfig->pathToOpenssl = HelperProgramOptionsWidget->OpenSSLPathInput->url();
		GlobalConfig->pathToPppd = DaemonOptionsWidget->PppdPathInput->url();
		GlobalConfig->pathToKill = HelperProgramOptionsWidget->KillPathInput->url();
		GlobalConfig->pathToKillall = HelperProgramOptionsWidget->KillallPathInput->url();
		GlobalConfig->pathToPing = HelperProgramOptionsWidget->PingPathInput->url();
		GlobalConfig->pathToOpenvpn = DaemonOptionsWidget->OpenvpnPathInput->url();
		GlobalConfig->pathToFreeswan = DaemonOptionsWidget->FreeswanPathInput->url();
		GlobalConfig->minimizeAfterConnect = ConnectOptionsWidget->checkMinimizeAfterConnectCheck->isChecked();
		GlobalConfig->showDebugConsole = DebugOptionsWidget->showDebugCheck->isChecked();
		GlobalConfig->useSilentQuit = ConnectOptionsWidget->SilentQuitcheckBox->isChecked();
		GlobalConfig->dontQuitOnCloseEvent = DebugOptionsWidget->DontQuitOnCloseEventCheckBox->isChecked();
		GlobalConfig->writeLogFile = DebugOptionsWidget->WriteLogCheck->isChecked();
		GlobalConfig->KvpncDebugLevel = DebugOptionsWidget->spinKvpncDebugLevel->value();
		GlobalConfig->RacoonDebugLevel = DaemonOptionsWidget->RacoonDebugLevelComboBox->currentText();
		GlobalConfig->VpncDebugLevel = DaemonOptionsWidget->spinVpncDebugLevel->value();
		GlobalConfig->OpenvpnDebugLevel = DaemonOptionsWidget->spinOpenvpnDebugLevel->value();
		GlobalConfig->enableDebugPppd = DaemonOptionsWidget->DebugPppdcheckBox->isChecked();
		GlobalConfig->tryConnectTimeout = ConnectOptionsWidget->spinTryConnectTimeout->value();
		GlobalConfig->useSilentQuit = ConnectOptionsWidget->SilentQuitcheckBox->isChecked();
		GlobalConfig->dontQuitOnCloseEvent = DebugOptionsWidget->DontQuitOnCloseEventCheckBox->isChecked();
		GlobalConfig->programsInPath = DaemonOptionsWidget->ProgramsInPathcheckBox->isChecked();
		GlobalConfig->holdGeneratedScripts = DebugOptionsWidget->KeepConnectionFilesCheckBox->isChecked();
		GlobalConfig->InfoLogColor = LogOptionsWidget->InfoLogLabel->paletteBackgroundColor ();
		GlobalConfig->RemoteLogColor = LogOptionsWidget->RemoteLogLabel->paletteBackgroundColor();
		GlobalConfig->ErrorLogColor = LogOptionsWidget->ErrorLogLabel->paletteBackgroundColor ();
		GlobalConfig->SuccessLogColor = LogOptionsWidget->SuccessLogLabel->paletteBackgroundColor ();
		GlobalConfig->DebugLogColor = LogOptionsWidget->DebugLogLabel->paletteBackgroundColor ();
		GlobalConfig->useColorizedLogOutput = LogOptionsWidget->UseColorizedLogOutputcheckBox->isChecked();
		GlobalConfig->showInterfaceIPinTooltip = DaemonOptionsWidget->ShowInterfaceIPinTooltipCheckBox->isChecked();
		GlobalConfig->doAutoConnectAtStartup = ConnectOptionsWidget->DoAutoConnectCheckBox->isChecked();
		GlobalConfig->AutoConnectProfile = ConnectOptionsWidget->AutoConnectProfileComboBox->currentText();
		GlobalConfig->LogViewerFontSize = LogOptionsWidget->LogFontSizeSpinBox->value();
	}
	if (GlobalConfig->currentProfile != 0)
		saveSessionClicked();

	QDialog::accept();
}

void PreferencesDialog::connectionTypeChanged( int )
{

	if ( GlobalConfig->KvpncDebugLevel > 0 )
		GlobalConfig->appendLogEntry( "connectionTypeChanged()", GlobalConfig->debug );

	if (GlobalConfig->currentProfile == 0)
		return;

	ProfileGeneralOptionsWidget->DeleteSessionPushButton->setEnabled ( TRUE );
	ProfileGeneralOptionsWidget->NewSessionPushButton->setEnabled ( TRUE );
	ProfileGeneralOptionsWidget->SaveSessionPushButton->setEnabled ( TRUE );

	// First we should set a type
	// 	parent->buttonCancel->setEnabled( FALSE );
	// 	parent->buttonOk->setEnabled( FALSE );
	ProfileGeneralOptionsWidget->AdvancedSettingsPushButton->setEnabled( false );

	if ( GlobalConfig->currentProfile->getConnectionType() ==  VpnAccountData::cisco )
	{

		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry( "new type: cisco",GlobalConfig->debug );

		ProfileCiscoOptionsWidget->IDLineEdit->setEnabled( true );
		ProfileCiscoOptionsWidget->LabelID->setEnabled( true );

		ProfileGeneralOptionsWidget->AdvancedSettingsPushButton->setEnabled( true );

		ProfileGeneralOptionsWidget->NetworkDeviceComboBox->setEnabled( true );
		ProfileGeneralOptionsWidget->LabelNetworkDevice->setEnabled( true );
		ProfileGeneralOptionsWidget->RemoteNetAddrLineEdit->setEnabled( false );
		ProfileGeneralOptionsWidget->RemoteNetMaskComboBox->setEnabled( false );

		ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setEnabled( true );
		ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled( true );
		if (GlobalConfig->currentProfile->getUseUdp())
			ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled(true);
		else
			ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled(false);
		emit authTypeChanged(GlobalConfig->currentProfile->getAuthType());
	} // vpnc

	else if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::racoon || GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::freeswan )
	{

		if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::racoon )
		{

			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry( i18n( "New type: %1" ).arg("racoon"), GlobalConfig->debug );

			ProfileGeneralOptionsWidget->AdvancedSettingsPushButton->setEnabled( true );
		}
		else
		{

			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry( i18n( "New type: %1" ).arg("freeswan"), GlobalConfig->debug );

			if (GlobalConfig->currentProfile != 0)
			{
				ProfileCertPskOptionsWidget->privkeypathURLRequester->setURL( GlobalConfig->currentProfile->getPrivateKey() );
				ProfileCertPskOptionsWidget->PrivkeyPasswordEdit->setText( GlobalConfig->currentProfile->getPrivateKeyPass() );
			}
			ProfileGeneralOptionsWidget->AdvancedSettingsPushButton->setEnabled( false );
		}
		ProfileGeneralOptionsWidget->NetworkDeviceComboBox->setEnabled ( true );
		ProfileGeneralOptionsWidget->LabelNetworkDevice->setEnabled( true );
		ProfileGeneralOptionsWidget->RemoteNetAddrLineEdit->setEnabled( true );
		ProfileGeneralOptionsWidget->RemoteNetMaskComboBox->setEnabled( true );
		ProfileCiscoOptionsWidget->IDLineEdit->setEnabled( false );
		ProfileCiscoOptionsWidget->LabelID->setEnabled( false );

		// 		buttonCancel->setEnabled( TRUE );
		// 		buttonOk->setEnabled( TRUE );
		if ( ProfileCertPskOptionsWidget->UseSpecialRemoteIDcheckBox->isChecked() )
			ProfileCertPskOptionsWidget->RemoteIDLineEdit->setEnabled( true );
		else
			ProfileCertPskOptionsWidget->RemoteIDLineEdit->setEnabled( false );

		ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setEnabled( true );
		ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled( true );
		if (GlobalConfig->currentProfile->getUseUdp())
			ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled(true);
		else
			ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled(false);

		emit authTypeChanged(GlobalConfig->currentProfile->getAuthType());
	} // racoon/freeswan

	else if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::pptp )
	{

		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry( "new type: pptp", GlobalConfig->debug );

		ProfileGeneralOptionsWidget->AdvancedSettingsPushButton->setEnabled( true );

		authTypeChanged(VpnAccountData::pptp);
	} // pptp
	else if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::openvpn )
	{
		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry( i18n( "new type: %1" ).arg("openvpn"),GlobalConfig->debug );

		ProfileGeneralOptionsWidget->AdvancedSettingsPushButton->setEnabled( false );
		ProfileGeneralOptionsWidget->RemoteNetAddrLineEdit->setEnabled( true );
		ProfileGeneralOptionsWidget->LabelRemoteNetwork->setEnabled( true );
		ProfileGeneralOptionsWidget->RemoteNetMaskComboBox->setEnabled( true );
		ProfileCiscoOptionsWidget->IDLineEdit->setEnabled( false );
		ProfileCiscoOptionsWidget->LabelID->setEnabled( false );
		// 		buttonCancel->setEnabled( TRUE );
		// 		buttonOk->setEnabled( TRUE );

		ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setEnabled( true );
		ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled( true );
		if (GlobalConfig->currentProfile->getUseUdp())
			ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled(true);
		else
			ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled(false);

		emit authTypeChanged(GlobalConfig->currentProfile->getAuthType());
	} // openvpn

	// other
	else if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::other )
	{

		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry( i18n( "new type: none specified" ),GlobalConfig->debug );
	}
	else
	{
		GlobalConfig->appendLogEntry( i18n( "unknown type" ),GlobalConfig->debug );
	}

}

void PreferencesDialog::authTypeChanged( int authtype )
{
	if (GlobalConfig->currentProfile ==0)
		return;

	ProfileCertPskOptionsWidget->PskInFileCheckBox->setEnabled(true);

	if (GlobalConfig->KvpncDebugLevel > 0)
	{

		QString type;
		if ( GlobalConfig->currentProfile->getAuthType() == VpnAccountData::cert )
			type = "cert";
		else if ( GlobalConfig->currentProfile->getAuthType() == VpnAccountData::psk )
			type = "psk";


		GlobalConfig->appendLogEntry( i18n( "New authtype: \"%1\"." ).arg( type ) ,GlobalConfig->debug);
	}

	ProfileCertPskOptionsWidget->CertificateGroupBox->setEnabled( false );
	ProfileCertPskOptionsWidget->PskGroupBox->setEnabled( false );
	ProfileCertPskOptionsWidget->AuthTypeComboBox->setEnabled( false );
	ProfileCertPskOptionsWidget->LabelAuthType->setEnabled( false );
	ProfileCertPskOptionsWidget->CaCertpathURLRequester->setEnabled( false );
	ProfileCertPskOptionsWidget->SpecialServerCertificateURLRequester->setEnabled( false );

	int connectiontype = ProfileGeneralOptionsWidget->ConnectionTypeComboBox->currentItem();


	if (connectiontype == VpnAccountData::cisco || connectiontype == VpnAccountData::pptp )
	{
		if (connectiontype == VpnAccountData::cisco)
		{
			ProfileCertPskOptionsWidget->PskGroupBox->setEnabled( true );
			ProfileCertPskOptionsWidget->PSKLineEdit->setEnabled( true );
			ProfileCertPskOptionsWidget->LabelPsk->setEnabled( true );
			ProfileCertPskOptionsWidget->PskInFileCheckBox->setChecked(false);
			ProfileCertPskOptionsWidget->PskInFileCheckBox->setEnabled(false);
			ProfileCertPskOptionsWidget->PSKFileURLRequester->setEnabled(false);
			ProfileCertPskOptionsWidget->LabelPskFile->setEnabled(false);
		}

	}

	// racoon or freeswan
	else if ( connectiontype == VpnAccountData::freeswan || connectiontype == VpnAccountData::racoon )
	{

		ProfileCertPskOptionsWidget->AuthTypeComboBox->setEnabled( true );
		ProfileCertPskOptionsWidget->LabelAuthType->setEnabled( true );

		// cert
		if ( authtype == VpnAccountData::cert )
		{
			// certificate
			ProfileCertPskOptionsWidget->CertificateGroupBox->setEnabled( true );
			ProfileCertPskOptionsWidget->x509certURLRequester->setEnabled( true );
			ProfileCertPskOptionsWidget->LabelCertificate->setEnabled( true );

			ProfileCertPskOptionsWidget->certpathURLRequester->setEnabled( true );
			ProfileCertPskOptionsWidget->LabelCertificatePath->setEnabled( true );

			ProfileGeneralOptionsWidget->ImportCertificatePushButton->setEnabled( true );

			ProfileCertPskOptionsWidget->PskGroupBox->setEnabled( false );
			ProfileCertPskOptionsWidget->PSKLineEdit->setEnabled( false );
			ProfileCertPskOptionsWidget->LabelPsk->setEnabled( false );

		}

		// psk
		if ( authtype == VpnAccountData::psk )
		{
			// psk
			ProfileCertPskOptionsWidget->PskGroupBox->setEnabled( true );
			ProfileCertPskOptionsWidget->PSKLineEdit->setEnabled( true );
			ProfileCertPskOptionsWidget->LabelPsk->setEnabled( true );

			ProfileCertPskOptionsWidget->CertificateGroupBox->setEnabled( false );
			ProfileCertPskOptionsWidget->x509certURLRequester->setEnabled( false );
			ProfileCertPskOptionsWidget->LabelCertificate->setEnabled( false );

			ProfileCertPskOptionsWidget->certpathURLRequester->setEnabled( false );
			ProfileCertPskOptionsWidget->LabelCertificatePath->setEnabled( false );

			ProfileGeneralOptionsWidget->ImportCertificatePushButton->setEnabled( false );

		}
	}
	else if (connectiontype == VpnAccountData::openvpn)
	{

		ProfileCertPskOptionsWidget->AuthTypeComboBox->setEnabled( true );
		ProfileCertPskOptionsWidget->LabelAuthType->setEnabled( true );
		// cert
		if ( authtype  == VpnAccountData::cert )
		{
			// certificate
			ProfileCertPskOptionsWidget->CertificateGroupBox->setEnabled( true );
			ProfileCertPskOptionsWidget->x509certURLRequester->setEnabled( true );
			ProfileCertPskOptionsWidget->CaCertpathURLRequester->setEnabled( true );
			ProfileCertPskOptionsWidget->LabelCertificate->setEnabled( true );

			ProfileCertPskOptionsWidget->certpathURLRequester->setEnabled( true );
			ProfileCertPskOptionsWidget->LabelCertificatePath->setEnabled( true );
			ProfileCertPskOptionsWidget->privkeypathURLRequester->setEnabled( true );
			ProfileCertPskOptionsWidget->LabelPrivateKeyPath->setEnabled( true );

			ProfileGeneralOptionsWidget->ImportCertificatePushButton->setEnabled( true );

			ProfileCertPskOptionsWidget->PskGroupBox->setEnabled( false );
			ProfileCertPskOptionsWidget->PSKFileURLRequester->setEnabled( false );
			ProfileCertPskOptionsWidget->LabelPrivateKeyPath->setEnabled( true );
		}

		// psk
		if ( authtype == VpnAccountData::psk)
		{
			// psk
			ProfileCertPskOptionsWidget->PskGroupBox->setEnabled( true );
			ProfileCertPskOptionsWidget->PSKFileURLRequester->setEnabled( true );
			ProfileCertPskOptionsWidget->PSKLineEdit->setEnabled( true );
			ProfileCertPskOptionsWidget->LabelPsk->setEnabled( true );

			ProfileCertPskOptionsWidget->CertificateGroupBox->setEnabled( false );
			ProfileCertPskOptionsWidget->LabelPrivateKeyPath->setEnabled( false );
			ProfileCertPskOptionsWidget->x509certURLRequester->setEnabled( false );
			ProfileCertPskOptionsWidget->LabelCertificate->setEnabled( false );

			ProfileCertPskOptionsWidget->certpathURLRequester->setEnabled( false );
			ProfileCertPskOptionsWidget->LabelCertificatePath->setEnabled( false );
			ProfileGeneralOptionsWidget->ImportCertificatePushButton->setEnabled( false );
		}

	}
}


void PreferencesDialog::profileChanged( const QString& itemtext )
{

	if (!GlobalConfig->AccountList->isEmpty() && GlobalConfig->currentProfile != 0)
	{

		QString Name = itemtext;
		lastProfileName = Name;
		ProfileGeneralOptionsWidget->ProfileComboBox->setCurrentText( lastProfileName );
		ProfileNetworkRouteOptionsWidget->ProfileComboBox->setCurrentText( lastProfileName );
		ProfileNetworkNatOptionsWidget->ProfileComboBox->setCurrentText( lastProfileName );
		ProfileNetworkVirtualIpOptionsWidget->ProfileComboBox->setCurrentText( lastProfileName );
		ProfileCertPskOptionsWidget->ProfileComboBox->setCurrentText( lastProfileName );
		ProfileUserOptionsWidget->ProfileComboBox->setCurrentText( lastProfileName );
		ProfileOpenvpnOptionsWidget->ProfileComboBox->setCurrentText( lastProfileName );
		ProfilePptpOptionsWidget->ProfileComboBox->setCurrentText( lastProfileName );
		ProfileRacoonOptionsWidget->ProfileComboBox->setCurrentText( lastProfileName );
		ProfileCiscoOptionsWidget->ProfileComboBox->setCurrentText( lastProfileName );
		ProfileCmdExecBeforeConnectOptionsWidget->ProfileComboBox->setCurrentText( lastProfileName );
		ProfileCmdExecBeforeDisconnectOptionsWidget->ProfileComboBox->setCurrentText( lastProfileName );
		ProfileCmdExecAfterConnectOptionsWidget->ProfileComboBox->setCurrentText( lastProfileName );
		ProfileCmdExecAfterDisconnectOptionsWidget->ProfileComboBox->setCurrentText( lastProfileName );

		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry( i18n( "New profile: %1" ).arg( Name ),GlobalConfig->debug );

		//	KMessageBox::information(0,"item clicked",Name);
		// profile data
		VpnAccountData * it;
		for ( it = GlobalConfig->AccountList->first(); it; it = GlobalConfig->AccountList->next() )
		{
			if ( it->getName() == Name )
			{
				GlobalConfig->currentProfile = it;
				break;
			}
		}

		ProfileCertPskOptionsWidget->x509certURLRequester->clear();
		ProfileCertPskOptionsWidget->certpathURLRequester->clear();
		ProfileUserOptionsWidget->UsernameLineEdit->clear();
		ProfileCertPskOptionsWidget->PSKLineEdit->clear();
		ProfileCertPskOptionsWidget->RemoteIDLineEdit->clear();
		ProfileGeneralOptionsWidget->RemoteNetAddrLineEdit->clear();
		ProfileGeneralOptionsWidget->gatewayLineEdit->clear();
		ProfileNetworkRouteOptionsWidget->NetworkListView->clear();
		ProfileCertPskOptionsWidget->SpecialServerCertificateURLRequester->clear();

		ProfileCertPskOptionsWidget->CheckSavePsk->setChecked( false );
		ProfileUserOptionsWidget->CheckUserPass->setChecked( false );
		ProfileCiscoOptionsWidget->IDLineEdit->clear();
		ProfileUserOptionsWidget->UsernameLineEdit->clear();
		ProfileUserOptionsWidget->PasswordEdit->clear();
		ProfileCmdExecBeforeConnectOptionsWidget->CmdBeforeConnectTextEdit->setEnabled(false);
		ProfileCmdExecAfterConnectOptionsWidget->CmdAfterConnectTextEdit->setEnabled(false);
		ProfileCmdExecBeforeDisconnectOptionsWidget->CmdBeforeDisconnectTextEdit->setEnabled(false);
		ProfileCmdExecAfterDisconnectOptionsWidget->CmdAfterDisconnectTextEdit->setEnabled(false);
		ProfileCmdExecBeforeConnectOptionsWidget->ExcuteCmdBeforeConnectCheckBox->setChecked(false);
		ProfileCmdExecAfterConnectOptionsWidget->ExcuteCmdAfterConnectCheckBox->setChecked(false);
		ProfileCmdExecBeforeDisconnectOptionsWidget->ExcuteCmdBeforeDisconnectCheckBox->setChecked(false);
		ProfileCmdExecAfterDisconnectOptionsWidget->ExcuteCmdAfterDisconnectCheckBox->setChecked(false);
		ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->setChecked(false);
		ProfileCertPskOptionsWidget->UseSpecialServerCertificateCheckBox->setChecked(false);

		ProfilePptpOptionsWidget->RefuseEapCheckbox->setChecked( false );
		ProfilePptpOptionsWidget->RequireMppeCheckbox->setChecked( false );
		ProfilePptpOptionsWidget->Refuse128BitEncryptionCheckbox->setChecked(false );
		ProfilePptpOptionsWidget->Refuse40BitEncryptionCheckbox->setChecked( false );
		ProfilePptpOptionsWidget->UseNoMPPECompressionCheckbox->setChecked( false );
		ProfilePptpOptionsWidget->DnsServerCheckbox->setChecked( false );
		ProfilePptpOptionsWidget->DnsServerLineedit->clear();
		ProfilePptpOptionsWidget->AllowStatefulModeCheckbox->setChecked( false );
		ProfilePptpOptionsWidget->GetDnsFromPeerCheckbox->setChecked( false );
		ProfilePptpOptionsWidget->UseNoBsdCompCheckbox->setChecked( false );
		ProfilePptpOptionsWidget->UseNoDeflateCheckbox->setChecked( false );
		ProfilePptpOptionsWidget->ReplaceDefaultRouteCheckbox->setChecked( false );
		ProfilePptpOptionsWidget->SetDefaultRouteCheckbox->setChecked( false );
		ProfilePptpOptionsWidget->MtuSpinbox->setValue( 1500 );
		ProfilePptpOptionsWidget->MtuCheckbox->setChecked( false );

		if ( it == 0 )
		{
			ProfileGeneralOptionsWidget->RenameSessionPushButton->setEnabled( false );
			ProfileGeneralOptionsWidget->DeleteSessionPushButton->setEnabled( false );
			ProfileGeneralOptionsWidget->SaveSessionPushButton->setEnabled( false );
			return;
		}
		else
		{
			ProfileGeneralOptionsWidget->AdvancedSettingsPushButton->setEnabled( true );
			ProfileGeneralOptionsWidget->DeleteSessionPushButton->setEnabled( true );
			ProfileGeneralOptionsWidget->SaveSessionPushButton->setEnabled( true );
		}

		ProfileCertPskOptionsWidget->RemoteIDLineEdit->clear();
		ProfileGeneralOptionsWidget->RemoteNetMaskComboBox->setCurrentText("24");
		ProfileGeneralOptionsWidget->DescriptionLineEdit->setText( it->getDescription() );
		ProfileGeneralOptionsWidget->gatewayLineEdit->setText(it->getGateway());

		// 	AdvancedSettingsPushButton->setEnabled( false );
		if ( ( it->getNetworkDevice() ).isEmpty() )
		{
			ProfileGeneralOptionsWidget->NetworkDeviceComboBox->setCurrentText( "default" );

			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry( i18n( "profile \"%1\": no network device defined, using \"default\"." ).arg( it->getName() ), GlobalConfig->debug );
		}
		else
		{
			ProfileGeneralOptionsWidget->NetworkDeviceComboBox->setCurrentText( it->getNetworkDevice() );

			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry( i18n( "profile \"%1\": network device defined, using \"%2\"." ).arg( it->getName() ).arg( it->getNetworkDevice() ), GlobalConfig->debug );
		}

		// global
		if ( it->getConnectionType() == VpnAccountData::ConnectionType(VpnAccountData::cisco ))
			ProfileGeneralOptionsWidget->ConnectionTypeComboBox->setCurrentItem( 0 );
		else if ( it->getConnectionType() == VpnAccountData::ConnectionType(VpnAccountData::racoon ))
			ProfileGeneralOptionsWidget->ConnectionTypeComboBox->setCurrentItem( 1 );
		else if ( it->getConnectionType() == VpnAccountData::ConnectionType(VpnAccountData::freeswan ))
			ProfileGeneralOptionsWidget->ConnectionTypeComboBox->setCurrentItem( 2 );
		else if ( it->getConnectionType() == VpnAccountData::ConnectionType(VpnAccountData::pptp ))
			ProfileGeneralOptionsWidget->ConnectionTypeComboBox->setCurrentItem( 3 );
		else if ( it->getConnectionType() == VpnAccountData::ConnectionType(VpnAccountData::openvpn ))
			ProfileGeneralOptionsWidget->ConnectionTypeComboBox->setCurrentItem( 4 );
		else
			ProfileGeneralOptionsWidget->ConnectionTypeComboBox->setCurrentItem( VpnAccountData::other ); // must be last item -> other

		ProfileGeneralOptionsWidget->gatewayLineEdit->setText( it->getGateway() );

		ProfileCertPskOptionsWidget->PSKLineEdit->setText( it->getPreSharedKey() );

		/* connection specific */
		if ( it->getConnectionType() == VpnAccountData::cisco )
		{
			ProfileCertPskOptionsWidget->CheckSavePsk->setChecked( it->getSavePsk() );
			ProfileUserOptionsWidget->CheckUserPass->setChecked ( it->getSaveUserPassword() );
			ProfileCiscoOptionsWidget->IDLineEdit->setText( it->getID() );
			ProfileUserOptionsWidget->UsernameLineEdit->setText ( it->getUserName() );
			ProfileCertPskOptionsWidget->PSKLineEdit->setText( it->getPreSharedKey() );
			ProfileUserOptionsWidget->PasswordEdit->setText ( it->getUserPassword() );

			ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setChecked(it->getUseUdp());
			ProfileNetworkNatOptionsWidget->UdpPortSpinbox->setValue(it->getUdpPort());
			if (it->getUseUdpPort() )
				ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setChecked(true);
			else
				ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setChecked(false);

			ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setEnabled( true );
			ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled( true );
			if (it->getUseUdp())
				ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled(true);
			else
				ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled(false);

			ProfileCertPskOptionsWidget->AuthTypeComboBox->setCurrentItem(1); // PSK
			ProfileCertPskOptionsWidget->AuthTypeComboBox->setEnabled( false );

			ProfileCertPskOptionsWidget->PSKLineEdit->setText( it->getPreSharedKey() );
			ProfileCertPskOptionsWidget->CheckSavePsk->setChecked( it->getSavePsk() );

			ProfileCiscoOptionsWidget->IDLineEdit->setEnabled( true );
			ProfileCiscoOptionsWidget->LabelID->setEnabled( true );
			ProfileCiscoOptionsWidget->KeepDefaultRouteCheckBox->setChecked( it->getKeepDefaultRoute());
			ProfileGeneralOptionsWidget->AdvancedSettingsPushButton->setEnabled( true );

			ProfileGeneralOptionsWidget->RemoteNetAddrLineEdit->setEnabled( false );
			ProfileGeneralOptionsWidget->LabelRemoteNetwork->setEnabled( false );
			ProfileGeneralOptionsWidget->RemoteNetMaskComboBox->setEnabled( false );
			ProfileCertPskOptionsWidget->RemoteIDLineEdit->setEnabled( false );

			ProfilePptpOptionsWidget->setEnabled(false);
			ProfileOpenvpnOptionsWidget->setEnabled(false);
			ProfileCiscoOptionsWidget->setEnabled(true);
			ProfileRacoonOptionsWidget->setEnabled(false);

		} // vpnc

		else if ( it->getConnectionType() == VpnAccountData::ConnectionType(VpnAccountData::racoon) || it->getConnectionType() == VpnAccountData::ConnectionType(VpnAccountData::freeswan ))
		{
			QString RemoteNetAddr = it->getRemoteNet().section( '/', 0, 0 );
			QString RemoteNetMask = it->getRemoteNet().section( '/', 1, 1 );
			ProfileGeneralOptionsWidget->RemoteNetAddrLineEdit->setText( RemoteNetAddr );
			ProfileGeneralOptionsWidget->RemoteNetMaskComboBox->setCurrentText( RemoteNetMask );
			if ( it->getAuthType() == VpnAccountData::cert )
			{
				ProfileCertPskOptionsWidget->AuthTypeComboBox->setCurrentItem( 0 );
			}
			else
			{
				ProfileCertPskOptionsWidget->AuthTypeComboBox->setCurrentItem( 1 );
			}


			ProfileCertPskOptionsWidget->x509certURLRequester->setURL( it->getX509Certificate() );
			ProfileCertPskOptionsWidget->CaCertpathURLRequester->setURL( it->getCaCertificate() );
			ProfileCertPskOptionsWidget->certpathURLRequester->setURL( it->getCertPath() );
			ProfileCertPskOptionsWidget->PrivkeyPasswordEdit->setText( it->getPrivateKeyPass());
			ProfileCertPskOptionsWidget->privkeypathURLRequester->setURL( it->getPrivateKey() );

			ProfileGeneralOptionsWidget->PingCheckBox->setChecked( it->getDoPingIP() );
			ProfileGeneralOptionsWidget->PingIPLineEdit->setText( it->getPingHostIP() );
			ProfileCertPskOptionsWidget->RemoteIDLineEdit->setText( it->getSpecialRemoteID() );
			ProfileCertPskOptionsWidget->UseSpecialRemoteIDcheckBox->setChecked( it->getUseSpecialRemoteID() );
			ProfileCertPskOptionsWidget->PSKLineEdit->setText(it->getPreSharedKey());
			ProfileCertPskOptionsWidget->CheckSavePsk->setChecked(it->getSavePsk());

			// TODO made it useable for freeswan
			if (it->getConnectionType() == VpnAccountData::freeswan)
			{
				ProfileCertPskOptionsWidget->SpecialServerCertificateURLRequester->setEnabled(false);
				ProfileCertPskOptionsWidget->UseSpecialServerCertificateCheckBox->setChecked( 	it->getUseSpecialServerCertificate() );
				if ( it->getUseSpecialServerCertificate())
					ProfileCertPskOptionsWidget->SpecialServerCertificateURLRequester->setURL(it->getSpecialServerCertificate());
			}

			ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->setChecked( it->getUseVirtualIP() );
			ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->setEnabled( true);

			ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setChecked(it->getUseUdp());
			ProfileNetworkNatOptionsWidget->UdpPortSpinbox->setValue(it->getUdpPort());
			if (it->getUseUdpPort() )
				ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setChecked(true);
			else
				ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setChecked(false);

			ProfileUserOptionsWidget->setEnabled(false);

			ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setEnabled( true );
			ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled( true );
			if (it->getUseUdp())
				ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled(true);
			else
				ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled(false);

			ProfileGeneralOptionsWidget->RemoteNetAddrLineEdit->setEnabled( true );
			ProfileGeneralOptionsWidget->LabelRemoteNetwork->setEnabled( true );
			ProfileGeneralOptionsWidget->RemoteNetMaskComboBox->setEnabled( true );

			ProfileGeneralOptionsWidget->ImportCertificatePushButton->setEnabled( true );

			ProfileCiscoOptionsWidget->IDLineEdit->setEnabled( false );
			ProfileCiscoOptionsWidget->LabelID->setEnabled( false );

			if (it->getConnectionType() == VpnAccountData::racoon)
				ProfileGeneralOptionsWidget->AdvancedSettingsPushButton->setEnabled( true );

			ProfilePptpOptionsWidget->setEnabled(false);
			ProfileOpenvpnOptionsWidget->setEnabled(false);
			ProfileCiscoOptionsWidget->setEnabled(false);
			ProfileRacoonOptionsWidget->setEnabled( true );

			if (it->getHashAlgo() == "sha1")
				ProfileRacoonOptionsWidget->HashAlgoComboBox->setCurrentText("SHA1");
			if (it->getHashAlgo() == "md5")
				ProfileRacoonOptionsWidget->HashAlgoComboBox->setCurrentText("MD5");

		} // racoon or freeswan

		else if ( it->getConnectionType() == VpnAccountData::ConnectionType(VpnAccountData::pptp ))
		{
			ProfileCertPskOptionsWidget->CheckSavePsk->setChecked( it->getSavePsk() );
			ProfileUserOptionsWidget->CheckUserPass->setChecked ( it->getSaveUserPassword() );
			ProfileUserOptionsWidget->UsernameLineEdit->setText ( it->getUserName() );
			ProfileUserOptionsWidget->PasswordEdit->setText ( it->getUserPassword() );
			ProfileGeneralOptionsWidget->PingCheckBox->setChecked( it->getDoPingIP() );
			ProfileGeneralOptionsWidget->PingIPLineEdit->setText( it->getPingHostIP() );

			if (!it->getRemoteNet().isEmpty())
			{
				QString RemoteNetAddr = it->getRemoteNet().section( '/', 0, 0 );
				QString RemoteNetMask = it->getRemoteNet().section( '/', 1, 1 );
				ProfileGeneralOptionsWidget->RemoteNetAddrLineEdit->setText( RemoteNetAddr );
				ProfileGeneralOptionsWidget->RemoteNetMaskComboBox->setCurrentText( RemoteNetMask );
			}

			ProfilePptpOptionsWidget->RefuseEapCheckbox->setChecked(it->getRefuseEap());
			ProfilePptpOptionsWidget->RequireMppeCheckbox->setChecked(it->getRequireMppe());
			ProfilePptpOptionsWidget->Refuse128BitEncryptionCheckbox->setChecked(it->getRefuse128BitEncryption());
			ProfilePptpOptionsWidget->Refuse40BitEncryptionCheckbox->setChecked(it->getRefuse40BitEncryption());
			ProfilePptpOptionsWidget->UseNoMPPECompressionCheckbox->setChecked(it->getDisableMPPEComp());
			ProfilePptpOptionsWidget->GetDnsFromPeerCheckbox->setChecked(it->getUseGetDnsFromPeer());
			ProfilePptpOptionsWidget->DnsServerCheckbox->setChecked(it->getUseDnsServer());
			ProfilePptpOptionsWidget->DnsServerLineedit->setText(it->getDnsServer());
			ProfilePptpOptionsWidget->UseNoBsdCompCheckbox->setChecked(it->getUseNoBsdComp());
			ProfilePptpOptionsWidget->UseNoDeflateCheckbox->setChecked(it->getUseNoDeflate());
			ProfilePptpOptionsWidget->SetDefaultRouteCheckbox->setChecked(it->getSetDefaultRoute());
			ProfilePptpOptionsWidget->ReplaceDefaultRouteCheckbox->setChecked(it->getReplaceDefaultRoute());
			ProfilePptpOptionsWidget->MtuCheckbox->setChecked(it->getUseMtu());
			ProfilePptpOptionsWidget->MtuSpinbox->setValue(it->getMtu());
			ProfilePptpOptionsWidget->AllowStatefulModeCheckbox->setChecked(it->getAllowStatefulMode());
			ProfilePptpOptionsWidget->UseNoIpDefaultCheckbox->setChecked(it->getAllowStatefulMode());

			ProfileGeneralOptionsWidget->AdvancedSettingsPushButton->setEnabled( true );

			ProfileCiscoOptionsWidget->IDLineEdit->setEnabled( false );
			ProfileCiscoOptionsWidget->LabelID->setEnabled( false );

			ProfileGeneralOptionsWidget->RemoteNetAddrLineEdit->setEnabled( true );
			ProfileGeneralOptionsWidget->LabelRemoteNetwork->setEnabled( true );
			ProfileGeneralOptionsWidget->RemoteNetMaskComboBox->setEnabled(true );
			ProfileGeneralOptionsWidget->ImportCertificatePushButton->setEnabled( false );
			ProfileGeneralOptionsWidget->NetworkDeviceComboBox->setEnabled( false );

			ProfilePptpOptionsWidget->setEnabled(true);
			ProfileOpenvpnOptionsWidget->setEnabled(false);
			ProfileCiscoOptionsWidget->setEnabled(false);
			ProfileRacoonOptionsWidget->setEnabled(false);

		} // pptp

		else if ( it->getConnectionType() == VpnAccountData::ConnectionType(VpnAccountData::openvpn ))
		{

			if ( it->getAuthType() == VpnAccountData::cert )
			{
				ProfileCertPskOptionsWidget->AuthTypeComboBox->setCurrentItem( 0 );
			}
			else
			{
				ProfileCertPskOptionsWidget->AuthTypeComboBox->setCurrentItem( 1 );
			}

			ProfileCertPskOptionsWidget->x509certURLRequester->setURL( it->getX509Certificate() );
			ProfileCertPskOptionsWidget->CaCertpathURLRequester->setURL( it->getCaCertificate() );
			ProfileCertPskOptionsWidget->certpathURLRequester->setURL( it->getCertPath() );
			ProfileCertPskOptionsWidget->PrivkeyPasswordEdit->setText( it->getPrivateKeyPass());
			ProfileCertPskOptionsWidget->privkeypathURLRequester->setURL( it->getPrivateKey() );
			ProfileCertPskOptionsWidget->PSKLineEdit->setText(it->getPreSharedKey());
			ProfileCertPskOptionsWidget->CheckSavePsk->setChecked(it->getSavePsk());
			ProfileGeneralOptionsWidget->PingCheckBox->setChecked( it->getDoPingIP() );
			ProfileGeneralOptionsWidget->PingIPLineEdit->setText( it->getPingHostIP() );

			ProfileGeneralOptionsWidget->UseConnectionStatusCheckCheckBox->setChecked( GlobalConfig->currentProfile->getUseConnectionStatusCheck());
			ProfileGeneralOptionsWidget->ConnectionStatusSuccessCountNumInput->setValue(GlobalConfig->currentProfile->getConnectionStatusCheckSuccessCount());
			ProfileGeneralOptionsWidget->ConnectionStatusCheckIntervalNumInput->setValue(GlobalConfig->currentProfile->getConnectionStatusInterval());
			ProfileGeneralOptionsWidget->DoReconnectAfterConnectionLostCheckBox->setChecked(GlobalConfig->currentProfile->getDoReconnectAfterConnectionLost());

			ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->setText( it->getLocalVirtualIP());
			ProfileNetworkVirtualIpOptionsWidget->RemoteVirtualIpLineEdit->setText( it->getRemoteVirtualIP());

// 			if (!it->getRemoteNet().isEmpty())
// 			{
// 				QString RemoteNetAddr = it->getRemoteNet().section( '/', 0, 0 );
// 				QString RemoteNetMask = it->getRemoteNet().section( '/', 1, 1 );
// 				ProfileGeneralOptionsWidget->RemoteNetAddrLineEdit->setText( RemoteNetAddr );
// 				ProfileGeneralOptionsWidget->RemoteNetMaskComboBox->setCurrentText( RemoteNetMask );
// 			}
// 			ProfileGeneralOptionsWidget->RemoteNetMaskComboBox->setEnabled(true);
// 			ProfileGeneralOptionsWidget->RemoteNetAddrLineEdit->setEnabled(true);


			ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setChecked(it->getUseUdp());
			ProfileNetworkNatOptionsWidget->UdpPortSpinbox->setValue(it->getUdpPort());
			if (it->getUseUdpPort() )
				ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setChecked(true);
			else
				ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setChecked(false);

			ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setEnabled( true );
			ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled( true );
			if (it->getUseUdp())
				ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled(true);
			else
				ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled(false);

			ProfileCiscoOptionsWidget->IDLineEdit->setEnabled( false );
			ProfileCiscoOptionsWidget->LabelID->setEnabled( false );

			ProfilePptpOptionsWidget->setEnabled(false);
			ProfileOpenvpnOptionsWidget->setEnabled(true);
			ProfileCiscoOptionsWidget->setEnabled(false);
			ProfileRacoonOptionsWidget->setEnabled(false);

			ProfileOpenvpnOptionsWidget->TunnelDeviceTypeComboBox->setCurrentText(it->getTunnelDeviceType());

			if ( GlobalConfig->currentProfile->getUseUserdefinedPort() )
			{
				ProfileOpenvpnOptionsWidget->UseUserdefinedPortCheckBox->setChecked(true);
				ProfileOpenvpnOptionsWidget->UserdefinedPortSpinBox->setEnabled(true);
			}
			else
			{
				ProfileOpenvpnOptionsWidget->UseUserdefinedPortCheckBox->setChecked(false);
				ProfileOpenvpnOptionsWidget->UserdefinedPortSpinBox->setEnabled(false);
			}

			if (it->getAuthType() == VpnAccountData::cert)
				ProfileOpenvpnOptionsWidget->UseNsCertTypeCheckBox->setEnabled(true);
			else
				ProfileOpenvpnOptionsWidget->UseNsCertTypeCheckBox->setEnabled(false);


			if ( GlobalConfig->currentProfile->getUseNsCertType())
			{
				ProfileOpenvpnOptionsWidget->UseNsCertTypeCheckBox->setChecked(true);
				ProfileOpenvpnOptionsWidget->NsCertTypeComboBox->setEnabled(true);

				if (GlobalConfig->currentProfile->getNsCertType() == "client")
					ProfileOpenvpnOptionsWidget->NsCertTypeComboBox->setCurrentItem(0);
				else
					ProfileOpenvpnOptionsWidget->NsCertTypeComboBox->setCurrentItem(1);
			}
			else
			{
				ProfileOpenvpnOptionsWidget->UseNsCertTypeCheckBox->setChecked(false);
				ProfileOpenvpnOptionsWidget->NsCertTypeComboBox->setEnabled(false);
			}
			ProfileOpenvpnOptionsWidget->UserdefinedPortSpinBox->setValue(GlobalConfig->currentProfile->getUserdefinedPort());

			if (GlobalConfig->currentProfile->getDisableLzoCompression())
				ProfileOpenvpnOptionsWidget->DisableLzoCompressionCheckBox->setChecked(false);
			else
				ProfileOpenvpnOptionsWidget->DisableLzoCompressionCheckBox->setChecked(true);

		} // openvpn

		ProfileCmdExecBeforeConnectOptionsWidget->ExcuteCmdBeforeConnectCheckBox->setChecked(it->getExecuteCmdBeforeConnect());
		ProfileCmdExecAfterConnectOptionsWidget->ExcuteCmdAfterConnectCheckBox->setChecked(it->getExecuteCmdAfterConnect());
		ProfileCmdExecBeforeDisconnectOptionsWidget->ExcuteCmdBeforeDisconnectCheckBox->setChecked(it->getExecuteCmdBeforeDisconnect());
		ProfileCmdExecAfterDisconnectOptionsWidget->ExcuteCmdAfterDisconnectCheckBox->setChecked(it->getExecuteCmdAfterDisconnect());
		ProfileCmdExecBeforeConnectOptionsWidget->CmdBeforeConnectTextEdit->setText(it->getCommandBeforeConnect());
		ProfileCmdExecAfterConnectOptionsWidget->CmdAfterConnectTextEdit->setText(it->getCommandAfterConnect());
		ProfileCmdExecBeforeDisconnectOptionsWidget->CmdBeforeDisconnectTextEdit->setText (it->getCommandBeforeDisconnect());
		ProfileCmdExecAfterDisconnectOptionsWidget->CmdAfterDisconnectTextEdit->setText (it->getCommandAfterDisconnect());
		ProfileCmdExecBeforeConnectOptionsWidget->CmdBeforeConnectTextEdit->setEnabled(it->getExecuteCmdBeforeConnect());
		ProfileCmdExecAfterConnectOptionsWidget->CmdAfterConnectTextEdit->setEnabled(it->getExecuteCmdAfterConnect());
		ProfileCmdExecBeforeDisconnectOptionsWidget->CmdBeforeDisconnectTextEdit->setEnabled(it->getExecuteCmdBeforeDisconnect());
		ProfileCmdExecAfterDisconnectOptionsWidget->CmdAfterDisconnectTextEdit->setEnabled(it->getExecuteCmdAfterDisconnect());

		ProfileNetworkRouteOptionsWidget->UseExtraNetworkRoutesCheckbox->setChecked(it->getUseAdditionalNetworkRoutes());

		QStringList AdditionalNetworkRoutes = it->getAdditionalNetworkRoutes();
		// example entry:
		// <network>/<netmask>#<gateway>

		for (QStringList::Iterator it2 = AdditionalNetworkRoutes.begin() ; it2 != AdditionalNetworkRoutes.end(); ++it2 )
		{
			QString networkstring = *it2;
			QString Network = networkstring.section('#',0,0).section('/',0,0);
			QString Netmask = networkstring.section('#',0,0).section('/',1,1);
			QString Gateway = networkstring.section('#',1,1).section('/',0,0);

			ProfileNetworkRouteOptionsWidget->NetworkListView->insertItem(new QListViewItem(ProfileNetworkRouteOptionsWidget->NetworkListView,Network,Netmask,Gateway));

		}

		connectionTypeChanged( ProfileGeneralOptionsWidget->ConnectionTypeComboBox->currentItem() );
		ProfileCertPskOptionsWidget->AuthTypeComboBox->setCurrentItem(it->getAuthType());
		ProfileCertPskOptionsWidget->x509certURLRequester->setFilter( "*.pem" );
		ProfileCertPskOptionsWidget->certpathURLRequester->setMode( KFile::Directory );
	}
}

void PreferencesDialog::saveSessionClicked()
{
	if ( GlobalConfig->currentProfile== 0 )
		return;
	//QString itemString=ConnectionTypeComboBox->currentText();
	int item = ProfileGeneralOptionsWidget->ConnectionTypeComboBox->currentItem();

	GlobalConfig->currentProfile->setDescription( ProfileGeneralOptionsWidget->DescriptionLineEdit->text() );

	// cisco
	if ( ProfileGeneralOptionsWidget->ConnectionTypeComboBox->currentItem() == VpnAccountData::cisco )
	{
		GlobalConfig->currentProfile->setConnectionType( VpnAccountData::cisco );
		if (ProfileUserOptionsWidget->CheckUserPass->isChecked())
		{
			GlobalConfig->currentProfile->setSaveUserPassword(true);
			GlobalConfig->currentProfile->setUserPassword(ProfileUserOptionsWidget->UsernameLineEdit->text());
		}
		else
		{
			GlobalConfig->currentProfile->setSaveUserPassword(false);
		}

		if (ProfileCertPskOptionsWidget->CheckSavePsk->isChecked())
		{
			GlobalConfig->currentProfile->setSavePsk(true);
			GlobalConfig->currentProfile->setPreSharedKey(ProfileCertPskOptionsWidget->PSKLineEdit->text());
		}
		else
		{
			GlobalConfig->currentProfile->setSavePsk(false);
		}
		GlobalConfig->currentProfile->setKeepDefaultRoute(ProfileCiscoOptionsWidget->KeepDefaultRouteCheckBox->isChecked());
	}

	else if ( ProfileGeneralOptionsWidget->ConnectionTypeComboBox->currentItem() == VpnAccountData::racoon || ProfileGeneralOptionsWidget->ConnectionTypeComboBox->currentItem() == VpnAccountData::freeswan )
	{
		GlobalConfig->currentProfile->setSpecialRemoteID( ProfileCertPskOptionsWidget->RemoteIDLineEdit->text() );
		GlobalConfig->currentProfile->setUseSpecialRemoteID( ProfileCertPskOptionsWidget->UseSpecialRemoteIDcheckBox->isChecked() );

		if ( item == VpnAccountData::racoon )
			GlobalConfig->currentProfile->setConnectionType( VpnAccountData::racoon );
		else
			GlobalConfig->currentProfile->setConnectionType( VpnAccountData::freeswan );

		GlobalConfig->currentProfile->setPrivateKey( ProfileCertPskOptionsWidget->privkeypathURLRequester->url() );
		GlobalConfig->currentProfile->setPrivateKeyPass( ProfileCertPskOptionsWidget->PrivkeyPasswordEdit->text() );


		bool validAddr = true;
		if ( ProfileGeneralOptionsWidget->PingCheckBox->isChecked() && ProfileGeneralOptionsWidget->RemoteNetAddrLineEdit->text().contains( '.' ) != 3 )
		{
			KMessageBox::error ( this, i18n( "No IP address entered!" ), i18n( "No IP address" ) );
			GlobalConfig->appendLogEntry(i18n( "No IP address entered!" ) ,GlobalConfig->error);
			validAddr = false;
		}
		else
		{
			QString addr = ProfileGeneralOptionsWidget->RemoteNetAddrLineEdit->text();
			int part0 = addr.section( '.', 0, 0 ).toInt();
			int part1 = addr.section( '.', 1, 1 ).toInt();
			int part2 = addr.section( '.', 2, 2 ).toInt();
			int part3 = addr.section( '.', 3, 3 ).toInt();

			/*
						LogOutput->append ("part0: "+QString().setNum(part0));
						LogOutput->append ("part1: "+QString().setNum(part1));
						LogOutput->append ("part2: "+QString().setNum(part2));
						LogOutput->append ("part3: "+QString().setNum(part3));
			*/
			if ( ( part0 < 1 || part0 > 254 ) || ( part1 < 0 || part1 > 254 ) || ( part2 < 0 || part2 > 254 ) || ( part3 < 0 || part3 > 254 ) )
			{
				KMessageBox::error ( this, i18n( "IP address (remote net) is not valid!" ), i18n( "Invalid IP address" ) );
				GlobalConfig->appendLogEntry( i18n( "IP address (remote net) is not valid!" ) ,GlobalConfig->error);

				validAddr = false;
			}
			if ( validAddr == true )
			{
				GlobalConfig->currentProfile->setRemoteNet( addr + "/" + ProfileGeneralOptionsWidget->RemoteNetMaskComboBox->currentText() );
			}

		}

		if ( ProfileCertPskOptionsWidget->AuthTypeComboBox->currentItem() == 0 )
			GlobalConfig->currentProfile->setAuthType( VpnAccountData::cert );
		else
			GlobalConfig->currentProfile->setAuthType( VpnAccountData::psk );

		GlobalConfig->currentProfile->setX509Certificate( ProfileCertPskOptionsWidget->x509certURLRequester->url() );
		GlobalConfig->currentProfile->setCertPath( ProfileCertPskOptionsWidget->certpathURLRequester->url() );

		GlobalConfig->currentProfile->setPreSharedKey( ProfileCertPskOptionsWidget->PSKLineEdit->text());

		if ( ProfileGeneralOptionsWidget->ConnectionTypeComboBox->currentItem() == VpnAccountData::racoon )
		{
			if (ProfileRacoonOptionsWidget->HashAlgoComboBox->currentText() =="SHA1")
			{
				GlobalConfig->currentProfile->setHashAlgo("sha1");
			}
			if (ProfileRacoonOptionsWidget->HashAlgoComboBox->currentText() =="MD5")
			{
				GlobalConfig->currentProfile->setHashAlgo("md5");
			}
		}
	}

	else if ( ProfileGeneralOptionsWidget->ConnectionTypeComboBox->currentItem() == VpnAccountData::pptp )
	{
		GlobalConfig->currentProfile->setConnectionType( VpnAccountData::pptp );


		bool validAddr = true;
		if (ProfileGeneralOptionsWidget->PingCheckBox->isChecked() && !ProfileGeneralOptionsWidget->RemoteNetAddrLineEdit->text().isEmpty())
		{
			if ( ProfileGeneralOptionsWidget->RemoteNetAddrLineEdit->text().contains( '.' ) != 3 )
			{
				//KMessageBox::error ( this, i18n( "No IP address entered!" ), i18n( "No IP address" ) );
				validAddr = false;
			}
			else
			{
				QString addr = ProfileGeneralOptionsWidget->RemoteNetAddrLineEdit->text();
				int part0 = addr.section( '.', 0, 0 ).toInt();
				int part1 = addr.section( '.', 1, 1 ).toInt();
				int part2 = addr.section( '.', 2, 2 ).toInt();
				int part3 = addr.section( '.', 3, 3 ).toInt();

				/*
							LogOutput->append ("part0: "+QString().setNum(part0));
							LogOutput->append ("part1: "+QString().setNum(part1));
							LogOutput->append ("part2: "+QString().setNum(part2));
							LogOutput->append ("part3: "+QString().setNum(part3));
				*/

				if ( ( part0 < 1 || part0 > 254 ) || ( part1 < 0 || part1 > 254 ) || ( part2 < 0 || part2 > 254 ) || ( part3 < 0 || part3 > 254 ) )
				{
					KMessageBox::error ( this, i18n( "Invalid values in IP address (remote net)!" ), i18n( "Invalid values in IP address" ) );
					GlobalConfig->appendLogEntry(i18n( "Invalid values in IP address (remote net)!" ) ,GlobalConfig->error);
					validAddr = false;
				}


				if ( validAddr == true )
				{
					GlobalConfig->currentProfile->setRemoteNet( addr + "/" + ProfileGeneralOptionsWidget->RemoteNetMaskComboBox->currentText() );
				}

			}
		}
		else
		{
			GlobalConfig->currentProfile->setRemoteNet("");
		}

	}

	else if ( ProfileGeneralOptionsWidget->ConnectionTypeComboBox->currentItem() == VpnAccountData::openvpn)
	{
		GlobalConfig->currentProfile->setConnectionType( VpnAccountData::openvpn );

// 		bool validAddr = true;
// 		if ( ProfileGeneralOptionsWidget->PingCheckBox->isChecked() && ProfileGeneralOptionsWidget->RemoteNetAddrLineEdit->text().contains( '.' ) != 3 )
// 		{
// 			KMessageBox::error ( this, i18n( "No IP address entered!" ), i18n( "No IP address" ) );
// 			GlobalConfig->appendLogEntry(i18n( "No IP address entered!" ) ,GlobalConfig->error);
// 			validAddr = false;
// 		}
// 		else
// 		{
// 			QString addr = ProfileGeneralOptionsWidget->RemoteNetAddrLineEdit->text();
// 			int part0 = addr.section( '.', 0, 0 ).toInt();
// 			int part1 = addr.section( '.', 1, 1 ).toInt();
// 			int part2 = addr.section( '.', 2, 2 ).toInt();
// 			int part3 = addr.section( '.', 3, 3 ).toInt();
// 
// 			/*
// 						LogOutput->append ("part0: "+QString().setNum(part0));
// 						LogOutput->append ("part1: "+QString().setNum(part1));
// 						LogOutput->append ("part2: "+QString().setNum(part2));
// 						LogOutput->append ("part3: "+QString().setNum(part3));
// 			*/
// 			if ( ( part0 < 1 || part0 > 254 ) || ( part1 < 0 || part1 > 254 ) || ( part2 < 0 || part2 > 254 ) || ( part3 < 0 || part3 > 254 ) )
// 			{
// 				KMessageBox::error ( this, i18n( "IP address (remote net) is invalid!" ), i18n( "Invalid IP address" ) );
// 				GlobalConfig->appendLogEntry(i18n( "IP address (remote net) is invalid!" ) ,GlobalConfig->error);
// 				validAddr = false;
// 			}
// 			if ( validAddr == true )
// 			{
// 				GlobalConfig->currentProfile->setRemoteNet( addr + "/" + ProfileGeneralOptionsWidget->RemoteNetMaskComboBox->currentText() );
// 			}
// 
// 		}

		// 		QString LocalVirtualIp = ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->text();
		// 		if (Utils().isValidIPv4Adress(LocalVirtualIp) == false)
		// 			KMessageBox::error ( this, i18n( "No valid IP address entered!" ), i18n( "No valid IP address" ) );
		// 		else
		// 		{
		// 			GlobalConfig->currentProfile->setLocalVirtualIP( LocalVirtualIp);
		// 		}
		//
		// 		QString RemoteVirtualIp = RemoteVirtualIpLineEdit->text();
		// 		if (Utils().isValidIPv4Adress(RemoteVirtualIp) == false)
		// 			KMessageBox::error ( this, i18n( "No valid IP address entered!" ), i18n( "No valid IP address" ) );
		// 		else
		// 		{
		// 			GlobalConfig->currentProfile->setRemoteVirtualIP( RemoteVirtualIp);
		// 		}


		if ( ProfileCertPskOptionsWidget->AuthTypeComboBox->currentItem() == 0 )
			GlobalConfig->currentProfile->setAuthType( VpnAccountData::cert );
		else
			GlobalConfig->currentProfile->setAuthType( VpnAccountData::psk );


		GlobalConfig->currentProfile->setPreSharedKeyFile(ProfileCertPskOptionsWidget->PSKFileURLRequester->url());
		GlobalConfig->currentProfile->setX509Certificate( ProfileCertPskOptionsWidget->x509certURLRequester->url() );
		GlobalConfig->currentProfile->setCaCertificate( ProfileCertPskOptionsWidget->CaCertpathURLRequester->url() );
		GlobalConfig->currentProfile->setCertPath( ProfileCertPskOptionsWidget->certpathURLRequester->url() );
		GlobalConfig->currentProfile->setPrivateKey ( ProfileCertPskOptionsWidget->privkeypathURLRequester->url());
		GlobalConfig->currentProfile->setPrivateKeyPass ( ProfileCertPskOptionsWidget->PrivkeyPasswordEdit->text());
		GlobalConfig->currentProfile->setTunnelDeviceType( ProfileOpenvpnOptionsWidget->TunnelDeviceTypeComboBox->currentText() );

		GlobalConfig->currentProfile->setUserdefinedPort( ProfileOpenvpnOptionsWidget->UserdefinedPortSpinBox->value());
		GlobalConfig->currentProfile->setUseUserdefinedPort( ProfileOpenvpnOptionsWidget->UseUserdefinedPortCheckBox->isChecked());
		GlobalConfig->currentProfile->setDisableLzoCompression (!ProfileOpenvpnOptionsWidget->DisableLzoCompressionCheckBox->isChecked());
	} // openvpn

	else
		GlobalConfig->currentProfile->setConnectionType( VpnAccountData::other );

	if ( ProfileGeneralOptionsWidget->PingCheckBox->isChecked() && !ProfileGeneralOptionsWidget->PingIPLineEdit->text().isEmpty() )
	{
		// do check for vailid IP
		if (!Utils().isValidIPv4Adress(ProfileGeneralOptionsWidget->PingIPLineEdit->text()))
		{
			KMessageBox::error ( this, i18n( "No valid IP address entered!" ), i18n( "No valid IP address" ) );
			GlobalConfig->appendLogEntry( i18n( "No valid IP address entered!" ) ,GlobalConfig->error);
		}
		else
		{
			GlobalConfig->currentProfile->setPingHostIP( ProfileGeneralOptionsWidget->PingIPLineEdit->text() );
			GlobalConfig->currentProfile->setDoPingIP( ProfileGeneralOptionsWidget->PingCheckBox->isChecked());
		}
	}
	else
	{
		if ( ProfileGeneralOptionsWidget->PingCheckBox->isChecked() && ProfileGeneralOptionsWidget->PingIPLineEdit->text() == QString( "" ) )
		{
			KMessageBox::error ( this, i18n( "No IP address (ping host) entered!" ), i18n( "No IP address" ) );
			GlobalConfig->appendLogEntry(i18n( "No IP address (ping host) entered!" ) ,GlobalConfig->error);
		}
		else
			GlobalConfig->currentProfile->setPingHostIP( "" );
	}

			GlobalConfig->currentProfile->setUseConnectionStatusCheck( ProfileGeneralOptionsWidget->UseConnectionStatusCheckCheckBox->isChecked());
			GlobalConfig->currentProfile->setConnectionStatusCheckSuccessCount( ProfileGeneralOptionsWidget->ConnectionStatusSuccessCountNumInput->value());
			GlobalConfig->currentProfile->setConnectionStatusInterval( ProfileGeneralOptionsWidget->ConnectionStatusCheckIntervalNumInput->value());
			GlobalConfig->currentProfile->setDoReconnectAfterConnectionLost(ProfileGeneralOptionsWidget->DoReconnectAfterConnectionLostCheckBox->isChecked());

	if ( item == VpnAccountData::ConnectionType(VpnAccountData::freeswan) ||
	        item == VpnAccountData::ConnectionType(VpnAccountData::racoon) )
	{

		if ( ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->isChecked() && !ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->text().isEmpty() )
		{
			// do check for vailid IP
			if (!Utils().isValidIPv4Adress(ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->text()))
			{
				KMessageBox::error ( this, i18n( "No valid IP address entered!" ), i18n( "No valid IP address" ) );
				GlobalConfig->appendLogEntry( i18n( "No valid IP address entered!" ) ,GlobalConfig->error);
			}
			else
			{
				GlobalConfig->currentProfile->setVirtualIP( ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->text() );
				GlobalConfig->currentProfile->setUseVirtualIP( ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->isChecked());
			}
		}
		else
		{
			if ( ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->isChecked() && ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->text().isEmpty() )
			{
				KMessageBox::error ( this, i18n( "No IP address (virtual IP) entered!" ), i18n( "No IP address" ) );
				GlobalConfig->appendLogEntry(i18n( "No IP address (virtual IP) entered!" ) ,GlobalConfig->error);
			}
			else
			{
				GlobalConfig->currentProfile->setVirtualIP( "" );
				GlobalConfig->currentProfile->setUseVirtualIP(false);
			}
		}
	}



	GlobalConfig->currentProfile->setSavePsk( ProfileCertPskOptionsWidget->CheckSavePsk->isChecked() );
	GlobalConfig->currentProfile->setSaveUserPassword( ProfileUserOptionsWidget->CheckUserPass->isChecked () );
	GlobalConfig->currentProfile->setID( ProfileCiscoOptionsWidget->IDLineEdit->text() );
	GlobalConfig->currentProfile->setUserName( ProfileUserOptionsWidget->UsernameLineEdit->text () );

	if (ProfileCertPskOptionsWidget->CheckSavePsk->isChecked())
		GlobalConfig->currentProfile->setPreSharedKey( ProfileCertPskOptionsWidget->PSKLineEdit->text( ) );
	else
		GlobalConfig->currentProfile->setPreSharedKey( "" );

	if (ProfileUserOptionsWidget->CheckUserPass->isChecked())
		GlobalConfig->currentProfile->setUserPassword( ProfileUserOptionsWidget->PasswordEdit->text ( ) );
	else
		GlobalConfig->currentProfile->setUserPassword( "" );

	GlobalConfig->currentProfile->setGateway( ProfileGeneralOptionsWidget->gatewayLineEdit->text() );
	GlobalConfig->currentProfile->setPreSharedKey( ProfileCertPskOptionsWidget->PSKLineEdit->text() );
	GlobalConfig->currentProfile->setX509Certificate( ProfileCertPskOptionsWidget->x509certURLRequester->url() );
	GlobalConfig->currentProfile->setCertPath( ProfileCertPskOptionsWidget->certpathURLRequester->url() );
	GlobalConfig->currentProfile->setNetworkDevice( ProfileGeneralOptionsWidget->NetworkDeviceComboBox->currentText() );

	GlobalConfig->currentProfile->setDoPingIP( ProfileGeneralOptionsWidget->PingCheckBox->isChecked() );

	if ( ProfileCertPskOptionsWidget->AuthTypeComboBox->currentItem() == 0 )
		GlobalConfig->currentProfile->setAuthType( VpnAccountData::cert );
	if ( ProfileCertPskOptionsWidget->AuthTypeComboBox->currentItem() == 1 )
		GlobalConfig->currentProfile->setAuthType( VpnAccountData::psk );

	if (ProfileNetworkNatOptionsWidget->UseUdpCheckbox->isChecked())
		GlobalConfig->currentProfile->setUseUdp(true);
	else
		GlobalConfig->currentProfile->setUseUdp(false);

	if (ProfileNetworkNatOptionsWidget->UdpPortCheckbox->isChecked())
	{
		GlobalConfig->currentProfile->setUdpPort(ProfileNetworkNatOptionsWidget->UdpPortSpinbox->value());
		GlobalConfig->currentProfile->setUseUdpPort(true);
	}
	else
	{
		GlobalConfig->currentProfile->setUdpPort(0);
		GlobalConfig->currentProfile->setUseUdpPort(false);
	}



	GlobalConfig->currentProfile->setExecuteCmdBeforeConnect( (ProfileCmdExecBeforeConnectOptionsWidget->ExcuteCmdBeforeConnectCheckBox->isChecked()));
	GlobalConfig->currentProfile->setExecuteCmdAfterConnect( (ProfileCmdExecAfterConnectOptionsWidget->ExcuteCmdAfterConnectCheckBox->isChecked()));
	GlobalConfig->currentProfile->setExecuteCmdBeforeDisconnect( (ProfileCmdExecBeforeDisconnectOptionsWidget->ExcuteCmdBeforeDisconnectCheckBox->isChecked()));
	GlobalConfig->currentProfile->setExecuteCmdAfterDisconnect( (ProfileCmdExecAfterDisconnectOptionsWidget->ExcuteCmdAfterDisconnectCheckBox->isChecked()));

	GlobalConfig->currentProfile->setCommandBeforeConnect(ProfileCmdExecBeforeConnectOptionsWidget->CmdBeforeConnectTextEdit->text());
	GlobalConfig->currentProfile->setCommandAfterConnect(ProfileCmdExecAfterConnectOptionsWidget->CmdAfterConnectTextEdit->text());
	GlobalConfig->currentProfile->setCommandBeforeDisconnect(ProfileCmdExecBeforeDisconnectOptionsWidget->CmdBeforeDisconnectTextEdit->text());
	GlobalConfig->currentProfile->setCommandAfterDisconnect(ProfileCmdExecAfterDisconnectOptionsWidget->CmdAfterDisconnectTextEdit->text());

	GlobalConfig->currentProfile->setUseAdditionalNetworkRoutes(ProfileNetworkRouteOptionsWidget->UseExtraNetworkRoutesCheckbox->isChecked());

	if (ProfileNetworkRouteOptionsWidget->UseExtraNetworkRoutesCheckbox->isChecked() && ProfileNetworkRouteOptionsWidget->NetworkListView->childCount() > 0)
	{
		QStringList AdditionalNetworkRoutes;
		QListViewItemIterator it( ProfileNetworkRouteOptionsWidget->NetworkListView );
		for ( ; it.current(); ++it )
		{
			// example entry:
			// <network>/<netmask>#<gateway>
			QString network = QString(it.current()->text(0)+"/"+it.current()->text(1));
			network.append("#");
			network.append(it.current()->text(2));
			AdditionalNetworkRoutes.append(network);
		}
		GlobalConfig->currentProfile->setAdditionalNetworkRoutes(AdditionalNetworkRoutes);
	}

	GlobalConfig->currentProfile->setUseSpecialServerCertificate(ProfileCertPskOptionsWidget->UseSpecialServerCertificateCheckBox->isChecked());
	if ( ProfileCertPskOptionsWidget->UseSpecialServerCertificateCheckBox->isChecked())
	{
		if (!ProfileCertPskOptionsWidget->SpecialServerCertificateURLRequester->url().isEmpty())
			GlobalConfig->currentProfile->setSpecialServerCertificate(ProfileCertPskOptionsWidget->SpecialServerCertificateURLRequester->url());
		else
		{
			KMessageBox::error ( this, i18n( "Special server certificate can't be empty!" ), i18n( "No server certificate" ) );
			GlobalConfig->appendLogEntry( i18n( "Special server certificate can't be empty!" ) ,GlobalConfig->error);
		}
	}

	GlobalConfig->currentProfile->setUseNsCertType(ProfileOpenvpnOptionsWidget->UseNsCertTypeCheckBox->isChecked());

	if (ProfileOpenvpnOptionsWidget->NsCertTypeComboBox->currentText() == "client")
		GlobalConfig->currentProfile->setNsCertType("client");
	else
		GlobalConfig->currentProfile->setNsCertType("server");

	GlobalConfig->currentProfile->setRefuseEap(ProfilePptpOptionsWidget->RefuseEapCheckbox->isChecked() );
	GlobalConfig->currentProfile->setRequireMppe(ProfilePptpOptionsWidget->RequireMppeCheckbox->isChecked()  );
	GlobalConfig->currentProfile->setRefuse128BitEncryption(ProfilePptpOptionsWidget->Refuse128BitEncryptionCheckbox->isChecked() );
	GlobalConfig->currentProfile->setRefuse40BitEncryption(ProfilePptpOptionsWidget->Refuse40BitEncryptionCheckbox->isChecked() );
	GlobalConfig->currentProfile->setDisableMPPEComp(ProfilePptpOptionsWidget->UseNoMPPECompressionCheckbox->isChecked() );
	GlobalConfig->currentProfile->setUseGetDnsFromPeer(ProfilePptpOptionsWidget->GetDnsFromPeerCheckbox->isChecked());
	GlobalConfig->currentProfile->setUseDnsServer(ProfilePptpOptionsWidget->DnsServerCheckbox->isChecked() );
	GlobalConfig->currentProfile->setDnsServer(ProfilePptpOptionsWidget->DnsServerLineedit->text() );
	GlobalConfig->currentProfile->setUseNoBsdComp(ProfilePptpOptionsWidget->UseNoBsdCompCheckbox->isChecked());
	GlobalConfig->currentProfile->setUseNoDeflate(ProfilePptpOptionsWidget->UseNoDeflateCheckbox->isChecked());
	GlobalConfig->currentProfile->setSetDefaultRoute(ProfilePptpOptionsWidget->SetDefaultRouteCheckbox->isChecked());
	GlobalConfig->currentProfile->setReplaceDefaultRoute(ProfilePptpOptionsWidget->ReplaceDefaultRouteCheckbox->isChecked());
	GlobalConfig->currentProfile->setUseMtu(ProfilePptpOptionsWidget->MtuCheckbox->isChecked());
	GlobalConfig->currentProfile->setMtu(ProfilePptpOptionsWidget->MtuSpinbox->value());
	GlobalConfig->currentProfile->setAllowStatefulMode(ProfilePptpOptionsWidget->AllowStatefulModeCheckbox->isChecked());
	GlobalConfig->currentProfile->setUseNoIpDefault(ProfilePptpOptionsWidget->UseNoIpDefaultCheckbox->isChecked());
	GlobalConfig->currentProfile->setDisableMPPEComp(ProfilePptpOptionsWidget->UseNoMPPECompressionCheckbox->isChecked());



	GlobalConfig->appendLogEntry( i18n( "Profile \"%1\" saved." ).arg( GlobalConfig->currentProfile->getName() ) ,GlobalConfig->debug);
}

void PreferencesDialog::deleteSessionClicked()
{
	QString Name = ProfileGeneralOptionsWidget->ProfileComboBox->currentText();
	if ( !ProfileGeneralOptionsWidget->ProfileComboBox->currentText().isEmpty() )
	{
		int result = KMessageBox::questionYesNo ( this, i18n( "Really delete \"%1\"?" ).arg( Name ), i18n( "Delete?" ) );
		//LogOutput->append( "Result: "+ QString().setNum(result) ) ;
		if ( result == 3) // Yes
		{
			VpnAccountData * it;
			if (!GlobalConfig->AccountList->isEmpty())
			{
				for ( it = GlobalConfig->AccountList->first(); it; it = GlobalConfig->AccountList->next() )
				{
					if ( ProfileGeneralOptionsWidget->ProfileComboBox->currentText().isEmpty() )
					{
						// 					this->deleteSessionAction->setEnabled ( FALSE );
						//			this->advancedSessionAction->setEnabled ( FALSE );
						// 					this->saveSessionAction->setEnabled ( FALSE );
					}
					else
					{
						if ( it->getName() == Name )
						{
							GlobalConfig->removeEntry(GlobalConfig->currentProfile->getName());
							GlobalConfig->currentProfile=0L;
							ProfileGeneralOptionsWidget->ProfileComboBox->removeItem( ProfileGeneralOptionsWidget->ProfileComboBox->currentItem() );
							ProfileNetworkRouteOptionsWidget->ProfileComboBox->removeItem( ProfileGeneralOptionsWidget->ProfileComboBox->currentItem() );
							ProfileNetworkNatOptionsWidget->ProfileComboBox->removeItem( ProfileGeneralOptionsWidget->ProfileComboBox->currentItem() );
							ProfileNetworkVirtualIpOptionsWidget->ProfileComboBox->removeItem( ProfileGeneralOptionsWidget->ProfileComboBox->currentItem() );
							ProfileCertPskOptionsWidget->ProfileComboBox->removeItem( ProfileGeneralOptionsWidget->ProfileComboBox->currentItem() );
							ProfileUserOptionsWidget->ProfileComboBox->removeItem( ProfileGeneralOptionsWidget->ProfileComboBox->currentItem() );
							ProfileOpenvpnOptionsWidget->ProfileComboBox->removeItem( ProfileGeneralOptionsWidget->ProfileComboBox->currentItem() );
							ProfilePptpOptionsWidget->ProfileComboBox->removeItem( ProfileGeneralOptionsWidget->ProfileComboBox->currentItem() );
							ProfileRacoonOptionsWidget->ProfileComboBox->removeItem( ProfileGeneralOptionsWidget->ProfileComboBox->currentItem() );
							ProfileCiscoOptionsWidget->ProfileComboBox->removeItem( ProfileGeneralOptionsWidget->ProfileComboBox->currentItem() );
							ProfileCmdExecBeforeConnectOptionsWidget->ProfileComboBox->removeItem( ProfileGeneralOptionsWidget->ProfileComboBox->currentItem() );
							ProfileCmdExecBeforeDisconnectOptionsWidget->ProfileComboBox->removeItem( ProfileGeneralOptionsWidget->ProfileComboBox->currentItem() );
							ProfileCmdExecAfterConnectOptionsWidget->ProfileComboBox->removeItem( ProfileGeneralOptionsWidget->ProfileComboBox->currentItem() );
							ProfileCmdExecAfterDisconnectOptionsWidget->ProfileComboBox->removeItem( ProfileGeneralOptionsWidget->ProfileComboBox->currentItem() );
							break;
						}
					}
				}
			}

			if ( !GlobalConfig->AccountList->isEmpty() )
			{
				GlobalConfig->currentProfile = GlobalConfig->AccountList->first();
				ProfileGeneralOptionsWidget->ProfileComboBox->setCurrentText(GlobalConfig->AccountList->first()->getName());
				//ConnectOptionsWidget->ProfileGeneralOptionsWidget->ProfileComboBox->setSelected(0, true);
				profileChanged ( GlobalConfig->AccountList->first()->getName());
				connectionTypeChanged( GlobalConfig->AccountList->first()->getConnectionType() );
				authTypeChanged( GlobalConfig->AccountList->first()->getAuthType() );
				// 				buttonCancel->setEnabled( true );
				// 				buttonOk->setEnabled( true );
			}
			else
			{
				ProfileGeneralOptionsWidget->DeleteSessionPushButton->setEnabled ( FALSE );
				ProfileGeneralOptionsWidget->RenameSessionPushButton->setEnabled ( FALSE );
				ProfileGeneralOptionsWidget->SaveSessionPushButton->setEnabled ( FALSE );
				ProfileGeneralOptionsWidget->AdvancedSettingsPushButton->setEnabled( false );
				// 				CiscoPptpGroupBox->setEnabled( false );
				//				FreeswanRacoonGroupBox->setEnabled( false );
				// 				OpenvpnGroupBox->setEnabled( false );
				// 				GeneralGroupbox->setEnabled( false );
				//				CommandExecutionGroupBox->setEnabled( false );
			}

			//		slotStatusMsg ( i18n( "Profile \"%1\" deleted." ).arg( Name ), ID_FLASH_MSG );

			GlobalConfig->appendLogEntry ( i18n( "Profile \"%1\" deleted." ).arg( Name ),GlobalConfig->debug );

			profileAddedOrDeleted=true;
			//saveOptions(); // TODO save, currently after closing dialog
			//			sessionToggled();
			//if ( ConnectOptionsWidget->ProfileGeneralOptionsWidget->ProfileComboBox->currentText().isEmpty() )
			//	ConnectOptionsWidget->ProfileGeneralOptionsWidget->ProfileComboBox->setEnabled ( FALSE );
		}
	}

}

void PreferencesDialog::newSessionClicked()
{

	// call new profile dialog...
	NewProfileDialog newdlg( GlobalConfig->appPointer,this, i18n("New profile"),GlobalConfig);
	newdlg.exec();
	if ( newdlg.newProfileCreated )
	{
		QString Name = newdlg.profileData->getName();
		VpnAccountData * it;
		for ( it = GlobalConfig->AccountList->first(); it; it = GlobalConfig->AccountList->next() )
		{
			if ( it->getName() == Name )
			{

				ProfileGeneralOptionsWidget->ProfileComboBox->insertItem( Name );
				ProfileNetworkRouteOptionsWidget->ProfileComboBox->insertItem( Name );
				ProfileNetworkNatOptionsWidget->ProfileComboBox->insertItem( Name );
				ProfileNetworkVirtualIpOptionsWidget->ProfileComboBox->insertItem( Name );
				ProfileCertPskOptionsWidget->ProfileComboBox->insertItem( Name );
				ProfileUserOptionsWidget->ProfileComboBox->insertItem( Name );
				ProfileOpenvpnOptionsWidget->ProfileComboBox->insertItem( Name );
				ProfilePptpOptionsWidget->ProfileComboBox->insertItem( Name );
				ProfileRacoonOptionsWidget->ProfileComboBox->insertItem( Name );
				ProfileCiscoOptionsWidget->ProfileComboBox->insertItem( Name );
				ProfileCmdExecBeforeConnectOptionsWidget->ProfileComboBox->insertItem( Name );
				ProfileCmdExecBeforeDisconnectOptionsWidget->ProfileComboBox->insertItem( Name );
				ProfileCmdExecAfterConnectOptionsWidget->ProfileComboBox->insertItem( Name );
				ProfileCmdExecAfterDisconnectOptionsWidget->ProfileComboBox->insertItem( Name );

				ProfileGeneralOptionsWidget->ProfileComboBox->setCurrentItem ( Name );
				ProfileNetworkRouteOptionsWidget->ProfileComboBox->setCurrentItem ( Name );
				ProfileNetworkNatOptionsWidget->ProfileComboBox->setCurrentItem ( Name );
				ProfileNetworkVirtualIpOptionsWidget->ProfileComboBox->setCurrentItem ( Name );
				ProfileCertPskOptionsWidget->ProfileComboBox->setCurrentItem ( Name );
				ProfileUserOptionsWidget->ProfileComboBox->setCurrentItem ( Name );
				ProfileOpenvpnOptionsWidget->ProfileComboBox->setCurrentItem ( Name );
				ProfilePptpOptionsWidget->ProfileComboBox->setCurrentItem ( Name );
				ProfileRacoonOptionsWidget->ProfileComboBox->setCurrentItem ( Name );
				ProfileCiscoOptionsWidget->ProfileComboBox->setCurrentItem ( Name );
				ProfileCmdExecBeforeConnectOptionsWidget->ProfileComboBox->setCurrentItem ( Name );
				ProfileCmdExecBeforeDisconnectOptionsWidget->ProfileComboBox->setCurrentItem ( Name );
				ProfileCmdExecAfterConnectOptionsWidget->ProfileComboBox->setCurrentItem ( Name );
				ProfileCmdExecAfterDisconnectOptionsWidget->ProfileComboBox->setCurrentItem ( Name );

				GlobalConfig->currentProfile = it;
				break;
			}
		}

		ProfileGeneralOptionsWidget->AdvancedSettingsPushButton->setEnabled( TRUE );
		ProfileGeneralOptionsWidget->RenameSessionPushButton->setEnabled( TRUE );
		ProfileGeneralOptionsWidget->DeleteSessionPushButton->setEnabled( TRUE );
		ProfileGeneralOptionsWidget->SaveSessionPushButton->setEnabled ( TRUE );

		// 		CiscoPptpGroupBox->setEnabled( true );
		// 		//		FreeswanRacoonGroupBox->setEnabled( true );
		// 		OpenvpnGroupBox->setEnabled( true );
		// 		GeneralGroupbox->setEnabled( true );
		// 		CommandExecutionGroupBox->setEnabled( true );

		KMessageBox::information ( this, i18n( "Profile \"%1\" added.\nNow set the right type,\n fill in the fields\nand press \"Save\" to complete the profile." ).arg( Name ), i18n( "Complete profile" ) );
		//slotStatusMsg ( i18n( "Profile \"%1\" added." ).arg( Name ), ID_FLASH_MSG );

		GlobalConfig->appendLogEntry ( i18n( "Profile \"%1\" added." ).arg( Name ),GlobalConfig->debug );
		profileAddedOrDeleted=true;
		NewProfileName=Name;
		profileChanged ( Name );
		connectionTypeChanged( ProfileGeneralOptionsWidget->ConnectionTypeComboBox->currentItem() );
		authTypeChanged( ProfileCertPskOptionsWidget->AuthTypeComboBox->currentItem() );
		saveSessionClicked();
	}
	else
	{

		GlobalConfig->appendLogEntry ( i18n( "Creation of the new profile canceled." ),GlobalConfig->debug );
	}

}


void PreferencesDialog::renameSessionClicked()
{
	bool ok=false;
	QString oldName= GlobalConfig->currentProfile->getName();
	QString newName = KInputDialog::getText ( i18n("New name"),i18n("Enter new name for profile:"), oldName, &ok,this);

	if (newName.contains(' '))
	{
		KMessageBox::error ( this, i18n( "Blanks are not allowed in profile names!" ), i18n( "Illegal charachter in name" ) );
		GlobalConfig->appendLogEntry(i18n( "Blanks are not allowed in profile names!" ) ,GlobalConfig->error);
		ok = false;
	}

	if (ok)
	{
		GlobalConfig->removeEntry(GlobalConfig->currentProfile->getName());
		GlobalConfig->currentProfile->setName(newName);
		int currIndex = ProfileGeneralOptionsWidget->ProfileComboBox->currentItem();
		ProfileGeneralOptionsWidget->ProfileComboBox->removeItem(currIndex);
		ProfileGeneralOptionsWidget->ProfileComboBox->insertItem(newName, currIndex);
		ProfileGeneralOptionsWidget->ProfileComboBox->setCurrentItem(currIndex);

		ProfileNetworkRouteOptionsWidget->ProfileComboBox->removeItem(currIndex);
		ProfileNetworkRouteOptionsWidget->ProfileComboBox->insertItem(newName, currIndex);
		ProfileNetworkRouteOptionsWidget->ProfileComboBox->setCurrentItem(currIndex);

		ProfileNetworkNatOptionsWidget->ProfileComboBox->removeItem(currIndex);
		ProfileNetworkNatOptionsWidget->ProfileComboBox->insertItem(newName, currIndex);
		ProfileNetworkNatOptionsWidget->ProfileComboBox->setCurrentItem(currIndex);

		ProfileNetworkVirtualIpOptionsWidget->ProfileComboBox->removeItem(currIndex);
		ProfileNetworkVirtualIpOptionsWidget->ProfileComboBox->insertItem(newName, currIndex);
		ProfileNetworkVirtualIpOptionsWidget->ProfileComboBox->setCurrentItem(currIndex);

		ProfileCertPskOptionsWidget->ProfileComboBox->removeItem(currIndex);
		ProfileCertPskOptionsWidget->ProfileComboBox->insertItem(newName, currIndex);
		ProfileCertPskOptionsWidget->ProfileComboBox->setCurrentItem(currIndex);

		ProfileUserOptionsWidget->ProfileComboBox->removeItem(currIndex);
		ProfileUserOptionsWidget->ProfileComboBox->insertItem(newName, currIndex);
		ProfileUserOptionsWidget->ProfileComboBox->setCurrentItem(currIndex);

		ProfileOpenvpnOptionsWidget->ProfileComboBox->removeItem(currIndex);
		ProfileOpenvpnOptionsWidget->ProfileComboBox->insertItem(newName, currIndex);
		ProfileOpenvpnOptionsWidget->ProfileComboBox->setCurrentItem(currIndex);

		ProfilePptpOptionsWidget->ProfileComboBox->removeItem(currIndex);
		ProfilePptpOptionsWidget->ProfileComboBox->insertItem(newName, currIndex);
		ProfilePptpOptionsWidget->ProfileComboBox->setCurrentItem(currIndex);

		ProfileRacoonOptionsWidget->ProfileComboBox->removeItem(currIndex);
		ProfileRacoonOptionsWidget->ProfileComboBox->insertItem(newName, currIndex);
		ProfileRacoonOptionsWidget->ProfileComboBox->setCurrentItem(currIndex);

		ProfileCiscoOptionsWidget->ProfileComboBox->removeItem(currIndex);
		ProfileCiscoOptionsWidget->ProfileComboBox->insertItem(newName, currIndex);
		ProfileCiscoOptionsWidget->ProfileComboBox->setCurrentItem(currIndex);

		ProfileCmdExecBeforeConnectOptionsWidget->ProfileComboBox->removeItem(currIndex);
		ProfileCmdExecBeforeConnectOptionsWidget->ProfileComboBox->insertItem(newName, currIndex);
		ProfileCmdExecBeforeConnectOptionsWidget->ProfileComboBox->setCurrentItem(currIndex);

		ProfileCmdExecBeforeDisconnectOptionsWidget->ProfileComboBox->removeItem(currIndex);
		ProfileCmdExecBeforeDisconnectOptionsWidget->ProfileComboBox->insertItem(newName, currIndex);
		ProfileCmdExecBeforeDisconnectOptionsWidget->ProfileComboBox->setCurrentItem(currIndex);

		ProfileCmdExecAfterConnectOptionsWidget->ProfileComboBox->removeItem(currIndex);
		ProfileCmdExecAfterConnectOptionsWidget->ProfileComboBox->insertItem(newName, currIndex);
		ProfileCmdExecAfterConnectOptionsWidget->ProfileComboBox->setCurrentItem(currIndex);

		ProfileCmdExecAfterDisconnectOptionsWidget->ProfileComboBox->removeItem(currIndex);
		ProfileCmdExecAfterDisconnectOptionsWidget->ProfileComboBox->insertItem(newName, currIndex);
		ProfileCmdExecAfterDisconnectOptionsWidget->ProfileComboBox->setCurrentItem(currIndex);

		ConnectOptionsWidget->AutoConnectProfileComboBox->clear();
		for (uint i=0; i < GlobalConfig->AccountList->count();i++)
			ConnectOptionsWidget->AutoConnectProfileComboBox->insertItem(GlobalConfig->AccountList->at(i)->getName());

		profileAddedOrDeleted=true;
		saveSessionClicked();
		GlobalConfig->appendLogEntry( i18n( "Profile \"%1\" renamed to \"%2\"." ).arg(oldName).arg( GlobalConfig->currentProfile->getName() ),GlobalConfig->debug );
	}

}

void PreferencesDialog::importCertificate()
{
	//FIXME make path dynamiclly
	ImportCertificateDialog dlg( this, i18n("Import certificate..."),GlobalConfig );
	//int result =
	dlg.exec();
}

void PreferencesDialog::pageChanged(QWidget*)
{
	//std::cout << "page changed, new profile: "<< lastProfileName << std::endl;
	profileChanged(lastProfileName);
}

#include "preferencesdialog.moc"
