/***************************************************************************
 *   Copyright (C) 2004 by Christoph Thielecke                             *
 *   crissi99@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "profilenetworkrouteoptions.h"

#include <qcheckbox.h>
#include <klineedit.h>
#include <klistview.h>
#include <qpushbutton.h>
#include <kpushbutton.h>
#include <kmessagebox.h>
#include <qstring.h>
#include <klocale.h>

#include "addnetworkroutedialog.h"

ProfileNetworkRouteOptions::ProfileNetworkRouteOptions(QWidget *parent)
		: ProfileNetworkRouteOptionsBase(parent)
{
}


ProfileNetworkRouteOptions::~ProfileNetworkRouteOptions()
{}

void ProfileNetworkRouteOptions::additionalNetworkRoutesToggled(bool)
{
	if (UseExtraNetworkRoutesCheckbox->isChecked())
	{
		NetworkListView->setEnabled(TRUE);
		DeleteNetworkRoutePushButton->setEnabled(TRUE);
		AddRoutePushButton->setEnabled(TRUE);
	}
	else
	{
		NetworkListView->setEnabled(FALSE);
		DeleteNetworkRoutePushButton->setEnabled(FALSE);
		AddRoutePushButton->setEnabled(FALSE);
	}
}

void ProfileNetworkRouteOptions::delNetworkRouteClicked()
{
	if ( NetworkListView->childCount() > 0 && NetworkListView->currentItem()!= 0 )
	{
		QListViewItem *item = NetworkListView->currentItem();
		QString Network = item->text(0);
		QString Netmask = item->text(1);
		int result = KMessageBox::questionYesNo ( this, i18n( "Do you really want to delete the network \"%1/%2\"?" ).arg( Network ).arg(Netmask), i18n( "Delete?" ) );
		//LogOutput->append( "Result: "+ QString().setNum(result) ) ;
		if ( result == 3) // Yes
		{
			NetworkListView->removeItem(item);
		}
	}
}


void ProfileNetworkRouteOptions::addNetworkRouteClicked()
{
	AddNetworkRouteDialog dlg(this, i18n("Add network route..."));
	if (dlg.exec())
	{
		QString gateway = dlg.getGateway();
		if (!dlg.getUseGateway())
			gateway="-";
		NetworkListView->insertItem( new QListViewItem(NetworkListView, dlg.getNetwork(),dlg.getNetmask(), gateway));
	}
}




