/***************************************************************************
*   Copyright (C) 2004 by Christoph Thielecke                             *
*   crissi99@gmx.de                                                       *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#include "vpnaccountdata.h"

VpnAccountData::VpnAccountData( ConnectionType ConnType, QString Name)
{
	this->RemoteNet = "";
	this->CertPath = "";
	this->doPingIP = false;
	this->pingHostIP = "";
	this->PrivateKeyPass="";
	this->PrivateKey="";
	this->NetworkDevice="";
	this->connectiontype = ConnType;
	this->Name = Name;

	Gateway="";
	ID="";
	Username="";
	UserPassword="";
	IkeGroup="";
	PerfectForwardSecrecy="";
	NtDomainName="";
	ApplicationVersion="";
	RemoteNet="";
	PreSharedKey="";
	x509Certificate="";
	CaCertificate="";
	NetworkDevice="";
	PrivateKeyPass="";
	PrivateKey="";
	CertPath="";
	AuthType="";
	pingHostIP="";
	SpecialRemoteID="";
	LocalVirtualIP="";
	RemoteVirtualIP="";
	PreSharedKeyFile="";
	HashAlgo="md5";
	Description="";
	saveUserPassword=false;
	savePsk=false;
	useAdvancedSettings=false;
	useIkeGroup=false;
	usePerfectForwardSecrety=false;
	useNtDomainName=false;
	useApplicationVersion=false;
	useLocalPort=false;
	useSingleDes=false;
	useGlobalIpsecSecret=false;
	doPingIP=false;
	useSpecialRemoteID=false;
	LocalPort=500;
	UserdefinedPort=10000;
	useUdp=true;
	useUdpPort=false;
	UdpPort=4500;
	useDnsServer=false;
	DnsServer="";
	useGetDnsFromPeer=true;
	refuse40BitEncryption=false;
	refuse128BitEncryption=false;
	allowStatefulMode=false;
	requireMppe=true;
	refuseEap=false;
	useNoIpDefault=false;
	;
	disableMPPEComp=false;
	;
	executeCmdBeforeConnect=false;
	executeCmdAfterConnect=false;
	executeCmdBeforeDisconnect=false;
	executeCmdAfterDisconnect=false;
	CommandBeforeConnect="";
	CommandAfterConnect="";
	CommandBeforeDisconnect="";
	CommandAfterDisconnect="";
	useNoBsdComp=false;
	useNoDeflate=false;
	setDefaultRoute=false;
	replaceDefaultRoute=false;
	useMtu=false;
	Mtu=1500;
	useVirtualIP=false;
	VirtualIP="";
	PskIsInFile=false;
	useAdditionalNetworkRoutes=false;

	SpecialServerCertificate="";
	useSpecialServerCertificate=false;
	TunnelDeviceType="tun";

}


VpnAccountData::~VpnAccountData()
{}

QString VpnAccountData::getName()
{
	return Name;
}

VpnAccountData::ConnectionType VpnAccountData::getConnectionType()
{
	return connectiontype;
}

QString VpnAccountData::getGateway()
{
	return Gateway;
}

QString VpnAccountData::getID()
{
	return ID;
}

QString VpnAccountData::getTunnelDeviceType()
{
	return TunnelDeviceType;
}

QString VpnAccountData::getUserName()
{
	return Username;
}

QString VpnAccountData::getUserPassword()
{
	return UserPassword;
}

bool VpnAccountData::getSaveUserPassword()
{
	return saveUserPassword;
}

bool VpnAccountData::getSavePsk()
{
	return savePsk;
}

QString VpnAccountData::getIkeGroup()
{
	return IkeGroup;
}

QString VpnAccountData::getPerfectForwardSecrety()
{
	return PerfectForwardSecrecy;
}

QString VpnAccountData::getNtDomainName()
{
	return NtDomainName;
}

QString VpnAccountData::getApplicationVersion()
{
	return ApplicationVersion;
}

bool VpnAccountData::getUseSingleDes()
{
	return useSingleDes;

}

bool VpnAccountData::getUseIkeGroup()
{
	return useIkeGroup;
}

bool VpnAccountData::getUsePerfectForwardSecrety()
{
	return usePerfectForwardSecrety;
}

bool VpnAccountData::getUseNtDomainName()
{
	return useNtDomainName;
}

bool VpnAccountData::getUseApplicationVersion()
{
	return useApplicationVersion;
}
bool VpnAccountData::getUseLocalPort()
{
	return useLocalPort;
}

bool VpnAccountData::getUseAdvancedSettings()
{
	return useAdvancedSettings;
}

bool VpnAccountData::getUseGlobalIpsecSecret()
{
	return useGlobalIpsecSecret;
}

int VpnAccountData::getLocalPort()
{
	return LocalPort;
}

QString VpnAccountData::getRemoteNet()
{
	return RemoteNet;
}

QString VpnAccountData::getPreSharedKey()
{
	return PreSharedKey;
}

QString VpnAccountData::getX509Certificate()
{
	return x509Certificate;
}

QString VpnAccountData::getCaCertificate()
{
	return CaCertificate;
}

QString VpnAccountData::getNetworkDevice()
{
	if (NetworkDevice)
		return NetworkDevice;
	else
		return QString("");
}

QString VpnAccountData::getCertPath()
{
	return CertPath;
}

VpnAccountData::AuthenticationType VpnAccountData::getAuthType()
{
	return authtype;
}

bool VpnAccountData::getDoPingIP()
{
	return doPingIP;
}

QString VpnAccountData::getPingHostIP()
{
	return pingHostIP;
}

QString VpnAccountData::getPrivateKeyPass()
{
	return PrivateKeyPass;
}

QString VpnAccountData::getPrivateKey()
{
	return PrivateKey;
}

bool VpnAccountData::getUseSpecialRemoteID()
{
	return useSpecialRemoteID;
}

QString VpnAccountData::getSpecialRemoteID()
{
	return SpecialRemoteID;
}

bool VpnAccountData::getUseUdp()
{
	return useUdp;
}

bool VpnAccountData::getUseUdpPort()
{
	return useUdpPort;
}

int VpnAccountData::getUdpPort()
{
	return UdpPort;
}

bool VpnAccountData::getUseDnsServer()
{
	return useDnsServer;
}

QString VpnAccountData::getDnsServer()
{
	return DnsServer;
}

bool VpnAccountData::getUseGetDnsFromPeer()
{
	return useGetDnsFromPeer;
}

bool VpnAccountData::getRefuse40BitEncryption()
{
	return refuse40BitEncryption;
}

bool VpnAccountData::getRefuse128BitEncryption()
{
	return refuse128BitEncryption;
}

bool VpnAccountData::getAllowStatefulMode()
{
	return allowStatefulMode;
}

bool VpnAccountData::getRequireMppe()
{
	return requireMppe;
}

bool VpnAccountData::getRefuseEap()
{
	return refuseEap;
}

bool VpnAccountData::getUseNoIpDefault()
{
	return useNoIpDefault;
}

bool VpnAccountData::getDisableMPPEComp()
{
	return disableMPPEComp;
}

bool VpnAccountData::getUseSpecialServerCertificate()
{
	return useSpecialServerCertificate;
}

QString VpnAccountData::getSpecialServerCertificate()
{
	return SpecialServerCertificate;
}

QString VpnAccountData::getLocalVirtualIP()
{
	return LocalVirtualIP;
}
QString VpnAccountData::getRemoteVirtualIP()
{
	return RemoteVirtualIP;
}

QString VpnAccountData::getPreSharedKeyFile()
{
	return PreSharedKeyFile;
}

bool VpnAccountData::getExecuteCmdBeforeConnect()
{
	return executeCmdBeforeConnect;
}

bool VpnAccountData::getExecuteCmdAfterConnect()
{
	return executeCmdAfterConnect;
}

bool VpnAccountData::getExecuteCmdBeforeDisconnect()
{
	return executeCmdBeforeDisconnect;
}

bool VpnAccountData::getExecuteCmdAfterDisconnect()
{
	return executeCmdAfterDisconnect;
}

QString VpnAccountData::getCommandBeforeConnect()
{
	return CommandBeforeConnect;
}

QString VpnAccountData::getCommandAfterConnect()
{
	return CommandAfterConnect;
}

QString VpnAccountData::getCommandBeforeDisconnect()
{
	return CommandBeforeDisconnect;
}

QString VpnAccountData::getCommandAfterDisconnect()
{
	return CommandAfterDisconnect;
}

bool VpnAccountData::getUseNoBsdComp()
{
	return useNoBsdComp;
}

bool VpnAccountData::getUseNoDeflate()
{
	return useNoDeflate;
}

bool VpnAccountData::getSetDefaultRoute()
{
	return setDefaultRoute;
}

bool VpnAccountData::getReplaceDefaultRoute()
{
	return replaceDefaultRoute;
}

bool VpnAccountData::getUseMtu()
{
	return useMtu;
}

int VpnAccountData::getMtu()
{
	return Mtu;
}

bool VpnAccountData::getUseVirtualIP()
{
	return useVirtualIP;
}

QString VpnAccountData::getVirtualIP()
{
	return VirtualIP;
}

bool VpnAccountData::getPskIsInFile()
{
	return PskIsInFile;
}

bool VpnAccountData::getUseAdditionalNetworkRoutes()
{
	return useAdditionalNetworkRoutes;
}

QStringList VpnAccountData::getAdditionalNetworkRoutes()
{
	return AdditionalNetworkRoutes;
}

QString VpnAccountData::getHashAlgo()
{
	return HashAlgo;
}

bool VpnAccountData::getUseUserdefinedPort()
{
	return useUserdefinedPort;
}

int VpnAccountData::getUserdefinedPort()
{
	return UserdefinedPort;
}

bool VpnAccountData::getKeepDefaultRoute()
{
	return keepDefaultRoute;
}

QString VpnAccountData::getDescription()
{
	return Description;
}

QString VpnAccountData::getNsCertType()
{
	return NsCertType;
}

bool VpnAccountData::getUseNsCertType()
{
	return useNsCertType;
}

bool VpnAccountData::getUseConnectionStatusCheck()
{
	return useConnectionStatusCheck;
}

int VpnAccountData::getConnectionStatusCheckSuccessCount()
{
	return connectionStatusCheckSuccessCount;
}

int VpnAccountData::getConnectionStatusInterval()
{
	return connectionStatusInterval;
}

bool VpnAccountData::getDoReconnectAfterConnectionLost()
{
	return doReconnectAfterConnectionLost;
}

bool VpnAccountData::getDisableLzoCompression()
{
	return disableLzoCompression;
}

/* set methods */
void VpnAccountData::setConnectionType( ConnectionType type )
{
	this->connectiontype = type;
}

void VpnAccountData::setName( QString Name )
{
	this->Name = Name;
}

void VpnAccountData::setGateway( QString Gateway )
{
	this->Gateway = Gateway;
}
void VpnAccountData::setID( QString ID )
{
	this->ID = ID;
}

void VpnAccountData::setUserName( QString Username )
{
	this->Username = Username;
}

void VpnAccountData::setUserPassword( QString UserPassword )
{
	this->UserPassword = UserPassword;
}

void VpnAccountData::setSaveUserPassword( bool saveUserPassword )
{
	this->saveUserPassword = saveUserPassword;
}

void VpnAccountData::setSavePsk( bool savePsk )
{
	this->savePsk = savePsk;
}

void VpnAccountData::setIkeGroup( QString IkeGroup )
{
	this->IkeGroup = IkeGroup;
}

void VpnAccountData::setPerfectForwardSecrety( QString PerfectForwardSecrecy )
{
	this->PerfectForwardSecrecy = PerfectForwardSecrecy;
}

void VpnAccountData::setNtDomainName( QString Name )
{
	this->NtDomainName = Name;
}

void VpnAccountData::setApplicationVersion( QString version )
{
	this->ApplicationVersion = version;
}

void VpnAccountData::setUseSingleDes( bool useSingleDes )
{
	this->useSingleDes = useSingleDes;
}

void VpnAccountData::setUseIkeGroup( bool useIkeGroup )
{
	this->useIkeGroup = useIkeGroup;
}

void VpnAccountData::setUsePerfectForwardSecrety( bool usePerfectForwardSecrety )
{
	this->usePerfectForwardSecrety = usePerfectForwardSecrety;
}

void VpnAccountData::setUseNtDomainName( bool useNtDomainName )
{
	this->useNtDomainName = useNtDomainName;
}

void VpnAccountData::setUseApplicationVersion( bool useApplicationVersion )
{
	this->useApplicationVersion = useApplicationVersion;
}

void VpnAccountData::setUseLocalPort( bool useLocalPort )
{
	this->useLocalPort = useLocalPort;
}

void VpnAccountData::setUseAdvancedSettings( bool useAdvancedSettings )
{
	this->useAdvancedSettings = useAdvancedSettings;
}

void VpnAccountData::setUseGlobalIpsecSecret( bool useGlobalIpsecSecret )
{
	this->useGlobalIpsecSecret = useGlobalIpsecSecret;
}

void VpnAccountData::setLocalPort( int port )
{
	this->LocalPort = port;
}

void VpnAccountData::setRemoteNet( QString RemoteNet )
{
	this->RemoteNet = RemoteNet;
}

void VpnAccountData::setPreSharedKey( QString PreSharedKey )
{
	this->PreSharedKey = PreSharedKey;
}

void VpnAccountData::setX509Certificate( QString x509Certificate )
{
	this->x509Certificate = x509Certificate;
}

void VpnAccountData::setCaCertificate( QString CaCertificate )
{
	this->CaCertificate = CaCertificate;
}

void VpnAccountData::setNetworkDevice( QString NetworkDevice )
{
	this->NetworkDevice = NetworkDevice;
}

void VpnAccountData::setCertPath( QString CertPath )
{
	this->CertPath = CertPath;
}

void VpnAccountData::setAuthType( VpnAccountData::AuthenticationType authtype )
{
	this->authtype = authtype;
}

void VpnAccountData::setDoPingIP(bool doPingIP)
{
	this->doPingIP=doPingIP;
}

void VpnAccountData::setPingHostIP(QString pingHostIP)
{
	this->pingHostIP = pingHostIP;
}

void VpnAccountData::setPrivateKeyPass(QString PrivateKeyPass)
{
	this->PrivateKeyPass = PrivateKeyPass;
}

void VpnAccountData::setPrivateKey(QString PrivateKey)
{
	this->PrivateKey = PrivateKey;
}

void VpnAccountData::setUseSpecialRemoteID(bool useSpecialRemoteID)
{
	this->useSpecialRemoteID = useSpecialRemoteID;
}

void VpnAccountData::setSpecialRemoteID(QString SpecialRemoteID)
{
	this->SpecialRemoteID = SpecialRemoteID;
}

void VpnAccountData::setUseUdp(bool useUdp)
{
	this->useUdp = useUdp;
}

void VpnAccountData::setUseUdpPort(bool useUdpPort)
{
	this->useUdpPort = useUdpPort;
}

void VpnAccountData::setUdpPort(int UdpPort)
{
	this->UdpPort = UdpPort;
}

void VpnAccountData::setUseDnsServer(bool useDnsServer )
{
	this->useDnsServer = useDnsServer;
}

void VpnAccountData::setDnsServer(QString DnsServer )
{
	this->DnsServer = DnsServer;
}

void VpnAccountData::setUseGetDnsFromPeer(bool useGetDnsFromPeer )
{
	this->useGetDnsFromPeer = useGetDnsFromPeer;
}

void VpnAccountData::setRefuse40BitEncryption(bool refuse40BitEncryption )
{
	this->refuse40BitEncryption = refuse40BitEncryption;
}

void VpnAccountData::setRefuse128BitEncryption(bool refuse128BitEncryption )
{
	this->refuse128BitEncryption = refuse128BitEncryption;
}

void VpnAccountData::setAllowStatefulMode(bool allowStatefulMode )
{
	this->allowStatefulMode = allowStatefulMode;
}

void VpnAccountData::setRequireMppe(bool requireMppe )
{
	this->requireMppe = requireMppe;
}

void VpnAccountData::setRefuseEap(bool refuseEap )
{
	this->refuseEap = refuseEap;
}

void VpnAccountData::setUseNoIpDefault(bool useNoIpDefault )
{
	this->useNoIpDefault = useNoIpDefault;
}

void VpnAccountData::setDisableMPPEComp(bool disableMPPEComp )
{
	this->disableMPPEComp = disableMPPEComp;
}

void VpnAccountData::setLocalVirtualIP( QString LocalVirtualIP )
{
	this->LocalVirtualIP = LocalVirtualIP;
}

void VpnAccountData::setRemoteVirtualIP( QString RemoteVirtualIP )
{
	this->RemoteVirtualIP = RemoteVirtualIP;
}

void VpnAccountData::setPreSharedKeyFile( QString PreSharedKeyFile)
{
	this->PreSharedKeyFile = PreSharedKeyFile;
}

void VpnAccountData::setExecuteCmdBeforeConnect(bool executeCmdBeforeConnect)
{
	this->executeCmdBeforeConnect = executeCmdBeforeConnect;
}

void VpnAccountData::setExecuteCmdAfterConnect(bool executeCmdAfterConnect)
{
	this->executeCmdAfterConnect = executeCmdAfterConnect;
}

void VpnAccountData::setExecuteCmdBeforeDisconnect( bool executeCmdBeforeDisconnect)
{
	this->executeCmdBeforeDisconnect = executeCmdBeforeDisconnect;
}

void VpnAccountData::setExecuteCmdAfterDisconnect( bool executeCmdAfterDisconnect)
{
	this->executeCmdAfterDisconnect = executeCmdAfterDisconnect;
}

void VpnAccountData::setCommandBeforeConnect(QString CommandBeforeConnect)
{
	this->CommandBeforeConnect = CommandBeforeConnect;
}

void VpnAccountData::setCommandAfterConnect(QString CommandAfterConnect)
{
	this->CommandAfterConnect = CommandAfterConnect;
}

void VpnAccountData::setCommandBeforeDisconnect(QString CommandBeforeDisconnect)
{
	this->CommandBeforeDisconnect = CommandBeforeDisconnect;
}

void VpnAccountData::setCommandAfterDisconnect(QString CommandAfterDisconnect)
{
	this->CommandAfterDisconnect = CommandAfterDisconnect;
}

void VpnAccountData::setUseNoBsdComp(bool useNoBsdComp)
{
	this->useNoBsdComp = useNoBsdComp;
}

void VpnAccountData::setUseNoDeflate(bool useNoDeflate)
{
	this->useNoDeflate = useNoDeflate;
}

void VpnAccountData::setSetDefaultRoute(bool setDefaultRoute)
{
	this->setDefaultRoute = setDefaultRoute;
}

void VpnAccountData::setReplaceDefaultRoute(bool replaceDefaultRoute)
{
	this->replaceDefaultRoute = replaceDefaultRoute;
}

void VpnAccountData::setUseMtu(bool useMtu)
{
	this->useMtu = useMtu;
}

void VpnAccountData::setMtu(int Mtu)
{
	this->Mtu = Mtu;
}

void VpnAccountData::setUseVirtualIP(bool useVirtualIP )
{
	this->useVirtualIP = useVirtualIP;
}

void VpnAccountData::setVirtualIP(QString VirtualIP )
{
	this->VirtualIP = VirtualIP;
}

void VpnAccountData::setPskIsInFile(bool PskIsInFile)
{
	this->PskIsInFile = PskIsInFile;
}

void VpnAccountData::setUseAdditionalNetworkRoutes( bool useAdditionalNetworkRoutes )
{
	this->useAdditionalNetworkRoutes  = useAdditionalNetworkRoutes;
}

void VpnAccountData::setAdditionalNetworkRoutes( QStringList AdditionalNetworkRoutes )
{
	this->AdditionalNetworkRoutes = AdditionalNetworkRoutes;
}

void VpnAccountData::setUseSpecialServerCertificate(bool useSpecialServerCertificate)
{
	this->useSpecialServerCertificate = useSpecialServerCertificate;
}

void VpnAccountData::setSpecialServerCertificate(QString SpecialServerCertificate)
{
	this->SpecialServerCertificate = SpecialServerCertificate;
}

void VpnAccountData::setHashAlgo(QString HashAlgo)
{
	this->HashAlgo = HashAlgo;
}

void VpnAccountData::setTunnelDeviceType(QString TunnelDeviceType)
{
	this->TunnelDeviceType = TunnelDeviceType;
}

void VpnAccountData::setUseUserdefinedPort(bool useUserdefinedPort)
{
	this->useUserdefinedPort = useUserdefinedPort;
}
void VpnAccountData::setUserdefinedPort(int UserdefinedPort)
{
	this->UserdefinedPort = UserdefinedPort;
}

void VpnAccountData::setKeepDefaultRoute(bool keepDefaultRoute)
{
	this->keepDefaultRoute = keepDefaultRoute;
}

void VpnAccountData::setDescription(QString Description)
{
	this->Description = Description;
}

void VpnAccountData::setNsCertType(QString NsCertType)
{
	this->NsCertType = NsCertType;
}

void VpnAccountData::setUseNsCertType(bool useNsCertType)
{
	this->useNsCertType = useNsCertType;
}

void VpnAccountData::setUseConnectionStatusCheck(bool useConnectionStatusCheck)
{
	this->useConnectionStatusCheck=useConnectionStatusCheck;
}

void VpnAccountData::setConnectionStatusCheckSuccessCount(int connectionStatusCheckSuccessCount)
{
	this->connectionStatusCheckSuccessCount=connectionStatusCheckSuccessCount;
}

void VpnAccountData::setConnectionStatusInterval(int connectionStatusInterval)
{
	this->connectionStatusInterval=connectionStatusInterval;
}

void VpnAccountData::setDoReconnectAfterConnectionLost( bool doReconnectAfterConnectionLost )
{
	this->doReconnectAfterConnectionLost = doReconnectAfterConnectionLost;
}

void VpnAccountData::setDisableLzoCompression(bool disableLzoCompression )
{
	this->disableLzoCompression = disableLzoCompression;
}

