/*****************************************************************************
 * Copyright (C) 2004-2009 Christoph Thielecke <crissi99@gmx.de>             *
 *                                                                           *
 * This program is free software; you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation; either version 2 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * This package is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this package; if not, write to the Free Software               *
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA *
 *****************************************************************************/

#ifndef OPENVPNMANAGEMENTHANDLER_H
#define OPENVPNMANAGEMENTHANDLER_H

#include <QTcpSocket>
#include <QtCore/QTimer>

#include <cstdlib>

#include "kvpncconfig.h"

class QTcpSocket;

class OpenvpnManagementHandler : public QObject
{
    Q_OBJECT

public:
    OpenvpnManagementHandler(QObject *parent, KVpncConfig *GlobalConfig);
    ~OpenvpnManagementHandler();

    void closeConnection();
    bool isConnectedToManagementPort();
    bool doConnect();
    QTimer *greetingtimer;

protected slots:
    void socketConnected();
    void socketConnectionClosed();
    void socketError(QAbstractSocket::SocketError socketError);
    void socketReadyRead();
    void socketClosed();
    void hostFound();
    void greetingTimedOut();

public slots:
    void sendToServer(QString cmd);

private:
    KVpncConfig *GlobalConfig;
    bool fInHold;
    bool gotGreeting;
    bool connectedToManagementPort;
    QTcpSocket *socket;
    QString errormsg;

signals:
    void terminate_openvpn();

};

#endif
