/*****************************************************************************
 * Copyright (C) 2004-2009 Christoph Thielecke <crissi99@gmx.de>             *
 *                                                                           *
 * This program is free software; you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation; either version 2 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * This package is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this package; if not, write to the Free Software               *
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA *
 *****************************************************************************/

#include "profilenetworkvirtualipoptions.h"

#include <QtGui/QCheckBox>
#include <QtGui/QLabel>

#include <klineedit.h>

#include "widgetnotifyhelper.h"

ProfileNetworkVirtualIpOptions::ProfileNetworkVirtualIpOptions(QWidget *parent) : QWidget(parent)
{
    setupUi(this);
    WidgetNotifyHelper h;
    h.setupChangedAction(this);
    dialogModified = false;
}


ProfileNetworkVirtualIpOptions::~ProfileNetworkVirtualIpOptions()
{}

void ProfileNetworkVirtualIpOptions::useVirtualIpAddressToggled(bool)
{
    if (UseVirtualIPCheckBox->isChecked()) {
        LocalVirtualIpEdit->setEnabled(true);
        LabelLocalVirtualIp->setEnabled(true);
        RemoteVirtualIpLineEdit->setEnabled(true);
        LabelRemoteVirtualIp->setEnabled(true);
    } else {
        LocalVirtualIpEdit->setEnabled(false);
        LabelLocalVirtualIp->setEnabled(false);
        RemoteVirtualIpLineEdit->setEnabled(false);
        LabelRemoteVirtualIp->setEnabled(false);
    }
}

void ProfileNetworkVirtualIpOptions::dialogChanged()
{
    dialogModified = true;
}

void ProfileNetworkVirtualIpOptions::useLeftSourceIpToggeled(bool)
{
    if (UseLeftSourceIpCheckBox->isChecked())
        LeftSourceIpLineEdit->setEnabled(true);
    else
        LeftSourceIpLineEdit->setEnabled(false);
}

void ProfileNetworkVirtualIpOptions::useRightSourceIpToggeled(bool)
{
    if (UseRightSourceIpCheckBox->isChecked())
        RightSourceIpLineEdit->setEnabled(true);
    else
        RightSourceIpLineEdit->setEnabled(false);
}

void ProfileNetworkVirtualIpOptions::useVirtualSubnetsToggled(bool)
{
    if (UseVirtualSubnetsCheckBox->isChecked())
        VirtualSubnetsLineEdit->setEnabled(true);
    else
        VirtualSubnetsLineEdit->setEnabled(false);
}


