/*****************************************************************************
 * Copyright (C) 2004-2009 Christoph Thielecke <crissi99@gmx.de>             *
 *                                                                           *
 * This program is free software; you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation; either version 2 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * This package is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this package; if not, write to the Free Software               *
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA *
 *****************************************************************************/

#include "profileopenvpnoptions.h"

#include <QtGui/QCheckBox>
#include <QtGui/QLabel>
#include <QtGui/QSpinBox>

#include <kcombobox.h>
#include <knuminput.h>
#include <kpassworddialog.h>
#include <kurlrequester.h>

#include "widgetnotifyhelper.h"

ProfileOpenvpnOptions::ProfileOpenvpnOptions(QWidget *parent)
{
    Q_UNUSED(parent);

    setupUi(this);
    NsCertTypeComboBox->insertItem(0, "client");
    NsCertTypeComboBox->insertItem(1, "server");

    if (UseTlsAuthCheckBox ->isChecked()) {
        TlsAuthURLRequester->setEnabled(true);
        UseTlsRemoteHostCheckBox->setEnabled(true);
    } else {
        TlsAuthURLRequester->setEnabled(false);
        UseTlsRemoteHostCheckBox->setEnabled(false);
    }
    WidgetNotifyHelper h;
    h.setupChangedAction(this);
    dialogModified = false;

}


ProfileOpenvpnOptions::~ProfileOpenvpnOptions()
{}

void ProfileOpenvpnOptions::userdefinedPortToggled(bool)
{
    if (UseUserdefinedPortCheckBox->isChecked())
        UserdefinedPortSpinBox->setEnabled(true);
    else
        UserdefinedPortSpinBox->setEnabled(false);
}

void ProfileOpenvpnOptions::useNsCertTypeToggled(bool)
{
    if (UseNsCertTypeCheckBox->isChecked())
        NsCertTypeComboBox->setEnabled(true);
    else
        NsCertTypeComboBox->setEnabled(false);
}

void ProfileOpenvpnOptions::useUserdefiniedCipherToggled(bool)
{
    if (UseUserdefiniedCipherCheckBox->isChecked())
        UserdefiniedCipherComboBox->setEnabled(true);
    else
        UserdefiniedCipherComboBox->setEnabled(false);
}

void ProfileOpenvpnOptions::useTlsAuthToggled(bool)
{
    if (UseTlsAuthCheckBox ->isChecked()) {
        TlsAuthURLRequester->setEnabled(true);
        UseTlsRemoteHostCheckBox->setEnabled(true);
    } else {
        TlsAuthURLRequester->setEnabled(false);
        UseTlsRemoteHostCheckBox->setEnabled(false);
    }
}


void ProfileOpenvpnOptions::useTlsRemoteHostToggled(bool)
{
    if (UseTlsRemoteHostCheckBox->isChecked())
        TlsRemoteHostLineEdit->setEnabled(true);
    else
        TlsRemoteHostLineEdit->setEnabled(false);
}

void ProfileOpenvpnOptions::userdefinedRemotePortToggled(bool)
{
    if (UseUserdefinedRemotePortCheckBox->isChecked())
        UserdefinedRemotePortSpinBox->setEnabled(true);
    else
        UserdefinedRemotePortSpinBox->setEnabled(false);
}

void ProfileOpenvpnOptions::userdefiniedPacketSizeToggled(bool)
{
    if (UseUserdefinedPacketSizeCheckBox->isChecked())
        UserdefinedPacketSizeSpinBox->setEnabled(true);
    else
        UserdefinedPacketSizeSpinBox->setEnabled(false);
}

void ProfileOpenvpnOptions::userdefiniedFragmentationSizeToggled(bool)
{
    if (UseUserdefinedFragmentationSizeCheckBox->isChecked())
        UserdefinedFragmentSizeSpinBox->setEnabled(true);
    else
        UserdefinedFragmentSizeSpinBox->setEnabled(false);
}

void ProfileOpenvpnOptions::authenticateWithUsernameAndPasswordToggled(bool)
{
    if (AuthWithUsernameAndPasswordCheckBox->isChecked())
        UseOnlyCaCertAndUserAuthCheckBox->setEnabled(true);
    else
        UseOnlyCaCertAndUserAuthCheckBox->setEnabled(false);
}

void ProfileOpenvpnOptions::useAuthenticationAlgorithmToggled(bool)
{
    if (UseAuthenticationAlgorithmCheckBox->isChecked())
        UserdefiniedDigestComboBox->setEnabled(true);
    else
        UserdefiniedDigestComboBox->setEnabled(false);
}

void ProfileOpenvpnOptions::tunnelPingToggeled(bool)
{
    if (TunnelPingCheckBox->isChecked())
        TunnelPingSpinBox->setEnabled(true);
    else
        TunnelPingSpinBox->setEnabled(false);
}


void ProfileOpenvpnOptions::tunnelPingRestartToggeled(bool)
{
    if (TunnelPingRestartCheckBox->isChecked())
        TunnelPingRestartSpinBox->setEnabled(true);
    else
        TunnelPingRestartSpinBox->setEnabled(false);
}


void ProfileOpenvpnOptions::renegSecToggled(bool)
{
    if (RenegSecCheckBox->isChecked())
        RenegSecSpinBox->setEnabled(true);
    else
        RenegSecSpinBox->setEnabled(false);
}


void ProfileOpenvpnOptions::dialogChanged()
{
    dialogModified = true;
}
