# - Try to find libgcrypt library
# Once done this will define
#
#  LIBGCRYPT_FOUND - System has libgcrypt
#  LIBGCRYPT_INCLUDE_DIR - The libgcrypt include directory
#  LIBGCRYPT_LIBRARIES - The libraried needed to use libgcrypt
#  LIBGCRYPT_DEFINITIONS - Compiler switches required for using libgcrypt

# Copyright (c) 2007, Laurent Montel, <montel@kde.org>
#
# Redistribution and use is allowed according to the terms of the BSD license.
# For details see the accompanying COPYING-CMAKE-SCRIPTS file.

if(LIBGCRYPT_INCLUDE_DIR AND LIBGCRYPT_LIBRARIES)
    # in cache already
    set(libgcrypt_FIND_QUIETLY TRUE)
endif(LIBGCRYPT_INCLUDE_DIR AND LIBGCRYPT_LIBRARIES)

find_path(LIBGCRYPT_INCLUDE_DIR
    NAMES gcrypt.h)

find_library(LIBGCRYPT_LIBRARIES
    NAMES gcrypt)

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(libgcrypt DEFAULT_MSG LIBGCRYPT_INCLUDE_DIR LIBGCRYPT_LIBRARIES)

# show the LIBGCRYPT_INCLUDE_DIR and LIBGCRYPT_LIBRARIES variables only in the advanced view
mark_as_advanced(LIBGCRYPT_INCLUDE_DIR LIBGCRYPT_LIBRARIES)

