###
### $Rev: 42 $
### $Release: 0.5.1 $
### copyright(c) 2005 kuwata-lab all rights reserved.
###

unless defined?(TESTDIR)
   TESTDIR = File.dirname(__FILE__)
   libdir  = File.dirname(TESTDIR) + "/lib"
   $LOAD_PATH << libdir << TESTDIR
end

require 'test/unit'
require 'test/unit/ui/console/testrunner'
require 'kwalify'
require 'kwalify/util/assert-diff'
require 'kwalify/main.rb'
require 'yaml'

module Kwalify
   class Main
      public :_parse_argv
   end
end

class File
   def self.move(filename, dirname)
      File.rename(filename, "#{dirname}/filename")
   end
end

class MainTest < Test::Unit::TestCase

   ## define test methods
   filename = __FILE__.sub(/\.rb$/, ".yaml")
   str = File.read(filename)
   @@docs = {}
   YAML.load_documents(str) do |doc|
      name = doc['name']
      !@@docs.key?(name) or raise "*** test name '#{name}' is duplicated."
      @@docs[name] = doc
      doc.each do |key, val|
         doc[$1] ||= val['ruby'] if key =~ /\A(.*)\*\z/
      end
      s = <<-END
         def test_#{name}
            doc = @@docs['#{name}']
            @name      = doc['name']
            @desc      = doc['desc']
            @args      = doc['args']
            @inspect   = doc['inspect']
            @exception = #{doc['exception'] ? "Kwalify::" + doc['exception'] : 'nil'}
            @error_symbol = doc['error_symbol']
            @expected  = doc['expected']
            @schema    = doc['schema']
            @document  = doc['document']
            @valid     = doc['valid']
            @invalid   = doc['invalid']
            @valid_out = doc['valid-out']
            @invalid_out = doc['invalid-out']
            @method    = doc['method']
            # @options   = doc['options']

            case @method
            when 'parseOptions'
               _test_parse_options()
            when 'execute'
               raise "*** #{doc['name']}: args is not defined."    unless doc['args']
               raise "*** #{doc['name']}: expected is not defined."  unless doc['expected']
               _test_execute()
            when 'validation'
               _test_validation()
               raise "*** #{doc['name']}: schema is not defined."  unless doc['schema']
               raise "*** #{doc['name']}: valid is not defined."   unless doc['valid']
               raise "*** #{doc['name']}: invalid is not defined." unless doc['invalid']

            else
               raise "*** #{@method}: invalid method name."
            end
         end
      END
      eval s
   end


   ## temporary directory
   @@tmpdir = "tmp.dir"
   Dir.mkdir(@@tmpdir) unless test(?d, @@tmpdir)


   ## validation test
   def _test_validation()
      return if $target && $target != @name
      raise "*** schema is not defined." unless @schema
      raise "*** valid is not defined." unless @valid
      raise "*** invalid is not defined." unless @invalid
      #
      schema_filename  = @name + ".schema"
      valid_filename   = @name + ".valid"
      invalid_filename = @name + ".invalid"
      #
      begin
         #
         File.open(schema_filename,  'w') { |f| f.write(@schema) }
         File.open(valid_filename,   'w') { |f| f.write(@valid) }
         File.open(invalid_filename, 'w') { |f| f.write(@invalid) }
         #
         main = Kwalify::Main.new('kwalify')
         args = [ "-lf", schema_filename, valid_filename ]
         output = main.execute(args)
         assert_equal_with_diff(@valid_out, output)
         #
         main = Kwalify::Main.new('kwalify')
         args = [ "-lf", schema_filename, invalid_filename ]
         output = main.execute(args)
         assert_equal_with_diff(@invalid_out, output)
         #
      ensure
         File.move(schema_filename,  @@tmpdir)
         File.move(valid_filename,   @@tmpdir)
         File.move(invalid_filename, @@tmpdir)
      end
   end

   ## execute test
   def _test_execute()
      return if $target && $target != @name
      raise "*** args is required when method is 'execute'." unless @args
      raise "*** expected is required when method is 'execute'." unless @expected
      #
      File.open("#{@name}.schema", 'w')   { |f| f.write(@schema)   } if @schema
      File.open("#{@name}.document", 'w') { |f| f.write(@document) } if @document
      #
      begin
         main = Kwalify::Main.new("kwalify")
         if (! @exception)
            actual = main.execute(@args)
            assert_equal_with_diff(@expected, actual)
         else
            assert_raise(@exception) do
               main.execute(@args)
            end
         end
      ensure
         File.move("#{@name}.schema",   @@tmpdir) if @schema
         File.move("#{@name}.document", @@tmpdir) if @document
      end
   end
   
   ## command option test
   def _test_parse_options()
      return if $target && $target != @name
      main = Kwalify::Main.new("kwalify")
      begin
         filenames = main._parse_argv(@args)
         s = main._inspect()
         s << "filenames:\n"
         filenames.each do |filename|
            s << "  - #{filename}\n"
         end
         actual = s
         assert_equal_with_diff(@inspect, actual)
      rescue => ex
         #klass = @exception
         if @exception && ex.class == @exception
            # OK
            assert_equal(@error_symbol, ex.error_symbol) if ex.respond_to?(:error_symbol)
         else
            # NG
            raise ex
         end
      end
   end

end

#if $0 == __FILE__
#   Test::Unit::UI::Console::TestRunner.run(ValidatorTest)
#end
