###
### $Rev: 42 $
### $Release: 0.5.1 $
### copyright(c) 2005 kuwata-lab all rights reserved.
###

unless defined?(TESTDIR)
   TESTDIR = File.dirname(__FILE__)
   libdir  = File.dirname(TESTDIR) + "/lib"
   $LOAD_PATH << libdir << TESTDIR
end

require 'test/unit'
require 'test/unit/ui/console/testrunner'
require 'kwalify'
require 'kwalify/util/assert-diff'
require 'yaml'


class MetaValidatorTest < Test::Unit::TestCase

   ## define test methods
   filename = __FILE__.sub(/\.rb$/, '.yaml')
   str = File.read(filename)
   @@docs = {}
   YAML.load_documents(str) do |doc|
      #doc.default = ''
      name = doc['name']
      !@@docs.key?(name) or raise "*** test name '#{name}' is duplicated."
      doc.each do |key, val|
         if key =~ /(.*)\*$/
            doc[$1] = val['ruby']
         end
      end
      @@docs[name] = doc
      s = <<-END
         def test_meta_#{name}
            doc = @@docs['#{name}']
            @name    = doc['name']
            @desc    = doc['desc']
            @schema  = doc['schema']
            @meta_msg = doc['meta-msg']
            # @rule_msg = doc['rule-msg']
            _test(:meta)
         end
      END
      eval s if doc['meta-msg']
      s = <<-END
         def test_rule_#{name}
            doc = @@docs['#{name}']
            @name    = doc['name']
            @desc    = doc['desc']
            @schema  = doc['schema']
            # @meta_msg = doc['meta-msg']
            @rule_msg = doc['rule-msg']
            _test(:rule)
         end
      END
      eval s if doc['rule-msg']
   end

   ## execute test
   def _test(test_type)
      return if $target && $target != @name
      #schema = YAML.load(@schema)
      parser = Kwalify::YamlParser.new(@schema)
      schema = parser.parse()
      case test_type
      when :meta
         meta_validator = Kwalify::MetaValidator.instance()
         errors = meta_validator.validate(schema)
         parser.set_errors_linenum(errors)
         errors.sort!
         expected = @meta_msg
      when :rule
         errors = []
         begin
            rule = Kwalify::Validator.new(schema)
         rescue Kwalify::KwalifyError => error
            errors << error
         end
         expected = @rule_msg
      end
      actual = ''
      errors.each do |error|
         raise error if error.is_a?(Kwalify::AssertionError)
         actual << "%-20s: [%s] %s\n" % [error.error_symbol.inspect, error.path, error.message]
      end
      if $print
         print actual
      else
         assert_equal_with_diff(expected, actual)
      end
   end

end

#if $0 == __FILE__
#   Test::Unit::UI::Console::TestRunner.run(MetaValidatorTest)
#end
