/***************************************************************************
                          options.cpp  -  description
                             -------------------
    begin                : Sam Nov 23 2002
    copyright            : (C) 2002 by Matthias Reif
    email                : matthias.reif@informatik.tu-chemnitz.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "options.h"

#include <kstandarddirs.h>

Options::Options() : QObject()
{
  device = new QString();
  device->setLength(15);

  kwcDir = new QString;
      
  loadOptions();

//  *kwcDir = KGlobal::dirs()->findResourceDir( "appdata", "kwaveq0.png" );
  *kwcDir = "//opt/.kwavecontrol/";
  notString = new QString("<" + i18n ("not a wlan-device") + ">");
  pollingChanged(polling);
}

Options::~Options(){
}

/** returns the used device */
QString* Options::getDevice()
{
  return device;
}

/** returns the polling-time */
int Options::getPolling()
{
  return polling;
}

/** sets the string shown when the device is not a wavelan device */
bool Options::setNotString(QString value)
{
  *notString = value;
  return true;                               
}
/** returns the string shown when the device is not a wavelan device */
QString* Options::getNotString()
{
  return notString;
}
/** when the polling time was changed */
void Options::slotPolling(int value)
{
  savePolling(value);
  pollingChanged(polling);
}

/** returns the dir. where the icons, .. are located */
QString* Options::getKwcDir()
{
  return kwcDir;
}
  
/** saves the device */
void Options::saveDevice(QString sDevice)
{
	KGlobal::config()->setGroup("KWaveControl");
	KGlobal::config()->writeEntry("device", sDevice);
	*device = sDevice;
}

/** saves the polling time */
void Options::savePolling(int value)
{
	KGlobal::config()->setGroup("KWaveControl");
	KGlobal::config()->writeEntry("polling", value);
	polling = value;
}

/** restores device and polling time */
void Options::loadOptions()
{
	KGlobal::config()->setGroup("KWaveControl");
	*device = KGlobal::config()->readEntry("device", "eth1");
	polling = KGlobal::config()->readNumEntry("polling", 5);
}

/** saves the position of the "only link" widget */
void Options::saveSmallPos(int x, int y)
{
	KGlobal::config()->setGroup("KWaveControl");
	KGlobal::config()->writeEntry("smallX", x);
	KGlobal::config()->setGroup("KWaveControl");
	KGlobal::config()->writeEntry("smallY", y);
}

/** returns the saved position of the "only link" widget */
void Options::getSmallPos(int &x, int &y)
{
	KGlobal::config()->setGroup("KWaveControl");
	x = KGlobal::config()->readNumEntry("smallX", 0);
	y = KGlobal::config()->readNumEntry("smallY", 0);	
}
