

#include "kwlanmainwin.h"
#include "wlanlib.h"
#include "kprofileconfigdlg.h"
#include "kstartsupplicantdlg.h"
#include "wpa_ctrl.h"
#include "keventhistorydlg.h"
#include "kscandlg.h"
#include "kuserdatarequestdlg.h"
#include "kwlansettingsdlg.h"
#include "kwlansuprocess.h"
#include "kwlaninterface.h"



#include <iostream>
#include <kstdaction.h>
#include <kaction.h>
#include <qlistbox.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qapplication.h>
#include <qtimer.h>
#include <qlabel.h>
#include <qaction.h>
#include <unistd.h>
#include <dirent.h>
#include <klocale.h>
#include <qstringlist.h>
#include <qfile.h>
#include <qfileinfo.h>
#include <kaboutapplication.h>
#include <qcstring.h>
#include <kpassdlg.h>
#include <kmessagebox.h>
#include <ktempfile.h>
#include <kstandarddirs.h>
#include <kpassdlg.h>
#include <kdebug.h>
#include <qcheckbox.h>
#include <qspinbox.h>
#include <qpushbutton.h>

KWlanMainWin::KWlanMainWin(QWidget* parent, const char* name, WFlags fl)
    : Kwlan(parent,name,fl)
{
}

int KWlanMainWin::init(QString interface) 
{
    // set Title of window
    setCaption(QString("Kwlan - ") + interface);
    QStringList binDirs;

    // initialise variables
    m_confFile = QString("kwlanrc.") + interface;
    kdDebug() << "Configuration file " <<m_confFile << endl;;
    m_configuration = new Configuration(m_confFile);

    m_messageNotifier = NULL;
    m_scanDlg = NULL;
    m_controlInterfaceDir = strdup ("/var/run/wpa_supplicant");
    m_eventHistory = NULL;
    m_userDataRequest = NULL;
    m_ssid = "";
    // create interface object
    m_interface = new KWlanInterface();
    m_interface->setConfiguration(m_configuration);
    // start systray window
    m_tray = new KWlanTrayWin( this, "KWlan" );
    if (!m_tray) {
        KMessageBox::sorry(this,i18n("Could not create Kicker applet!"));
        fileExit();
    }
    m_tray->setInterface(m_interface);
    m_tray->setInterfaceName(interface);
    m_tray->show();
    connect( m_tray, SIGNAL( quitSelected() ), this, SLOT( fileExit() ) );
    connect(m_tray, SIGNAL (aboutSelected()),this,SLOT(helpAbout()));
    connect(m_tray, SIGNAL(profileChanged(QString )),this,SLOT(profileSelect(QString )));
    connect(m_interface, SIGNAL(ipChanged( const QString& )),m_tray, SLOT(setIpAddress(const QString &)));
    connect(m_interface, SIGNAL(connectionStatusChanged( bool )),m_tray, SLOT(setConnectionStatus(bool)));
    connect(m_interface, SIGNAL(networksChanged()),this, SLOT(updateNetworks()));
    connect(m_interface, SIGNAL(wpaStatusChanged(bool)),this,SLOT(enableStartWpaMenu(bool)));
    connect(m_interface, SIGNAL(networksChanged()),m_tray, SLOT(updateNetworks()));
    m_interface->init(interface);
    if (!m_configuration->m_startMinimized) 
        show();
    if (!m_interface->getInterfaceData().wirelessDevice) pbScan->setEnabled(FALSE);

    //updateNetworks();
    return 0;
}

KWlanMainWin::~KWlanMainWin()
{
    m_configuration->writeSettings();
}

void KWlanMainWin::cleanTemporaryFiles()
{
    resolvconf->unlink();
    if (resolvconf) {
        delete resolvconf;
        resolvconf = 0;
    }
}

/*$SPECIALIZATION$*/






void KWlanMainWin::editSettings()
{
    KWlanSettingsDlg *settings = new KWlanSettingsDlg();
    settings->cbWpa->setChecked(m_configuration->m_startWpa);
    settings->cbWpaNoQuestion->setChecked(m_configuration->m_startWpaNoQuestion);
    settings->cbMinimized->setChecked(m_configuration->m_startMinimized);
    settings->sbPasswordTime->setValue(PasswordCache().m_pwexpire);
    settings->setConfiguraton( m_configuration);

    if (!settings) return;
    settings->show();
    settings->exec();
}



void KWlanMainWin::toolsLogViewer()
{
    if (m_eventHistory) {
        m_eventHistory->close();
        delete m_eventHistory;
    }

    m_eventHistory = new KEventHistoryDlg();
    if (m_eventHistory == NULL)
        return;
    connect (m_interface, SIGNAL (wpaEvent(WpaMsg)), m_eventHistory,SLOT (addEvent(WpaMsg)));
    connect (m_interface, SIGNAL (wpaEvents(WpaMsgList)), m_eventHistory,SLOT (addEvents(WpaMsgList)));
    m_interface->initLogViewer();
    m_eventHistory->show();
    m_eventHistory->exec();
    
}

void KWlanMainWin::scan()
{
    if (m_scanDlg) {
        m_scanDlg->close();
        delete m_scanDlg;
    }

    m_scanDlg = new KScanDlg();
    if (m_scanDlg == NULL)
        return;
    m_scanDlg->setInterface(m_interface);
    m_scanDlg->show();
    m_scanDlg->exec();
}


void KWlanMainWin::fileStopWpaSupplicant()
{
    m_interface->stopWpa();
    // User stopped wpa_suppliant, so suppress warning
    m_wpaWarned = true;
}



void KWlanMainWin::fileStartWpaSupplicant()
{
    QString driver, interface;
    interface = m_interface->getInterfaceName();
    if (m_interface->getInterfaceData().wirelessDevice)
    {
        kdDebug() << interface << " is a wireless device" << endl;
        KStartSupplicantDlg *startSupplicant = new KStartSupplicantDlg();
        if (!startSupplicant) return;
        if (!m_configuration) return;
        m_configuration->readDriver(driver);
        startSupplicant->setData( & interface ,& driver);
        startSupplicant->show();
        startSupplicant->exec();
        if (startSupplicant->m_start){
            m_interface->startWpa(startSupplicant->getDriver());
        }
    }

    else {
        //wired device, so drvier is wired
        kdDebug() << interface << " is a wired device" << endl;
        m_interface->startWpa(QString("wired"));
    }
}

void KWlanMainWin::updateNetworks()
{
    QStringList networks;
    //kdDebug() << "Updating profile list..." << endl;
    lbProfiles->clear();
    //m_tray->clearProfiles();
    networks= m_interface->listProfiles();
    for (QStringList::Iterator it=networks.begin();it != networks.end();it++){
        lbProfiles->insertItem(*it);
        //m_tray->insertProfile(&(*it));
    }
}



void KWlanMainWin::profileDelete()
{
    // get Profile
    QListBoxItem *selected = lbProfiles->selectedItem();
    // check if a profile is selected
    if (!selected) {
        KMessageBox::sorry(this,i18n("No Profile selected!"));
        return;
    }
    
    
    int answer = KMessageBox::warningYesNo(this,i18n("Do you really want to delete this profile?"));
    if (answer==KMessageBox::Yes){
        m_interface->profileDelete(lbProfiles->currentText());
    }
}

void KWlanMainWin::profileModify()
{
    int wpaId;
    // get Profile
    QListBoxItem *selected = lbProfiles->selectedItem();
    // check if a profile is selected
    if (!selected) {
        KMessageBox::sorry(this,i18n("No Profile selected!"));
        return;
    }
    
    wpaId = m_interface->getWpaId( lbProfiles->currentText());    
    
    // Open Config Dialog
    KProfileConfigDlg *profileDlg = new KProfileConfigDlg();
    if (!profileDlg) return;
    profileDlg->setInterface( m_interface);
    kdDebug() << "Modify profile: " << wpaId << endl;
    profileDlg->paramsFromConfig(m_interface, lbProfiles->currentText());
    profileDlg->show();
    profileDlg->exec();
    
}

void KWlanMainWin::profileNew()
{
    // Open Config Dialog
    KProfileConfigDlg *profileDlg = new KProfileConfigDlg();
    if (!profileDlg) return;
    profileDlg->setInterface( m_interface);
    profileDlg->newNetwork();
    profileDlg->show();
    profileDlg->exec();
    updateNetworks();
}

void KWlanMainWin::profileActivate()
{
    // get Profile
    QListBoxItem *selected = lbProfiles->selectedItem();
    // check if a profile is selected
    if (!selected) {
        KMessageBox::sorry(this,i18n("No Profile selected!"));
        return;
    }
    
    QString sel(lbProfiles->currentText());
    profileSelect(sel);
}

void KWlanMainWin::profileSelect(QString profile)
{
    kdDebug() << "Activating profile " << profile << endl;
    m_interface->profileActivate(profile);
}

void KWlanMainWin::helpAbout()
{
    KAboutApplication about(this);
    about.exec();
}


void KWlanMainWin::fileExit()
{
    //delete m_tray;
    m_configuration->writeSettings();
    kdDebug() << "Exiting..." << endl;
    kapp->quit();
}


void KWlanMainWin::enableStartWpaMenu(bool enable)
{
    fileStartWpaAction->setEnabled(!enable);
    fileStopWpaAction->setEnabled(enable);
}

#include "kwlanmainwin.moc"




















