#ifndef CONFIGURATION_H
#define CONFIGURATION_H

/** Kwlan
 *
 *  This File is part of Kwlan, a network Manager for KDE.
 *  Kwlan is distributed under LGPL license.
 *
 *	@author Thomas Michel <tom.michel@arcor.de>
 */


#include <qcstring.h>
#include <qstring.h>
#include <kconfig.h>


class Configuration: public QObject {
    Q_OBJECT
    
public:
    virtual ~Configuration();
    Configuration(QString confFile);
    /// Reads all the configuration data from the application config file.
    void readSettings();
    /// Writes the configuration data to the application config file.
    void writeSettings();
    /// Reads IP Settings for a given SSID
    int readIpSettings(QString ssid, bool &useDhcp, QString  &ipaddress, QString &netmask, QString & gateway, QString & dns1, QString & dns2, QString & domain, bool & dontOverrideGw, bool & dontOverrideDns,QStringList & dnsSearchlist);
    /// Writes IP Settings for a given SSID
    int writeIpSettings(QString ssid, bool useDhcp, QString ipaddress, QString netmask, QString gateway, QString dns1, QString dns2, QString domain,bool dontOverrideGw,bool dontOverrideDns,QStringList searchlist);
    /// Sets encryption mode for given SSID
    void writeEncryption (QString ssid, bool encryption);
    /// Gets encryption mode for given SSID
    void readEncryption (QString ssid, bool & encryption);
    void readScriptAfterConnect(QString ssid, QString &script, bool &useRootRights);
    void writeScriptAfterConnect(QString ssid, QString script, bool useRootRights);
    void readScriptBeforeDisconnect(QString ssid, QString &script, bool &useRootRights);
    void writeScriptBeforeDisconnect(QString ssid, QString script, bool useRootRights);
    /// Gets default driver for given interface
    void readDriver(QString &driver);
    void writeDriver(QString driver);
    /// Gets last ssid for interface
    void readLastSsid(QString & ssid);
    /// writes last ssid for interface
    void writeLastSsid(QString ssid);
    /// Returns all Networks configured in the config file
    QStringList getNetworks();
    /// Deletes network for given SSID
    void deleteNetwork(QString ssid);
    //bool m_startDhcp;
    bool m_startWpa;
    bool m_startWpaNoQuestion;
    bool m_startMinimized;
    bool m_useCustomWpaConf;
    QString m_customWpaConf;
    
private:
    QString m_confFile;
    
};


class mainConfigurationClass: public QObject {
    Q_OBJECT
    
    public:
        virtual ~mainConfigurationClass();
        bool readMonitorInterface(QString interface);
        void writeMonitorInterface(QString interface, bool monitored);
        bool readConfigureInterface(QString interface);
        void writeConfigureInterface(QString interface, bool configure);
        void writeStartMinimized(bool startMinimized);
        bool readStartMinimized();
        KConfig *m_configuration;
    private:
        mainConfigurationClass();
        QString m_confFile;
        friend mainConfigurationClass& mainConfiguration();

    
};

mainConfigurationClass& mainConfiguration();

// Class to cache passwords
class PasswordCacheClass : public QObject{
    Q_OBJECT
            
    public:
        virtual ~PasswordCacheClass();
        /// Cache the password for m_pwexpire seconds
        void setPassword(const QCString &password);
        /// Retrive cached password
        const QCString& password() const;
        void writePasswordExpire();
        void readPasswordExpire();
        int m_pwexpire;
    
    private:
        PasswordCacheClass();
        PasswordCacheClass(const PasswordCacheClass&);

    // allow this function to create one instance
        friend PasswordCacheClass& PasswordCache();

    //Runtime-only field. Should be empty to indicate no password cached
        QCString m_password;
    
    private slots:    
        void wipePassword();
};
// use this function to access the settings
PasswordCacheClass& PasswordCache();

#endif
