#include "kwlanapplication.h"
#include "kwlanmainwin.h"
#include "kwlaninterface.h"
#include "kwlansuprocess.h"
#include "dialup.h"

#include <klocale.h>
#include <qstringlist.h>
#include <kprocess.h>
#include <qdir.h>
#include <kdebug.h>
#include <kmessagebox.h>

#include <pwd.h>
#include <grp.h>

bool dialupUser; // defines whether user is member of dialup group

KwlanApplication::KwlanApplication(bool allowStyles, bool GUIenabled, bool configUnique)
    : KUniqueApplication(allowStyles, GUIenabled, configUnique)
{
    KMessageBox::setDontShowAskAgainConfig(mainConfiguration().m_configuration);
}

 KwlanApplication::~KwlanApplication()
{
}

void KwlanApplication::init()
{
    QDir dir;
    KConfig* config = KGlobal::config();
    config->setGroup("super-user-command");
    QString suCommand = config->readEntry("super-user-command", DEFAULT_SUPER_USER_COMMAND);
    if ( suCommand != "sudo" && suCommand != "su" ) {
        KMessageBox::error(0,i18n("No valid super-user command found. Kwlan won't be able to do any configurations"));
    } else 
    {
        QString suPath = getPath(suCommand);
        if (suPath.isEmpty())
        {
            KMessageBox::error(0,QString(i18n("Cannot find %1 in the path. Kwlan won't be able to do any configuration.")).arg(suCommand));
        }   
    }
    // Check if user is in dip group to have access to dialup networking
    uid_t uid;
    QString user;
    QStringList groupusers;
    struct passwd *pw;
    struct group *grp;
    uid = geteuid ();
    pw = getpwuid (uid);
    bool ok = TRUE;
    if (pw)
    {
        user = QString(pw->pw_name);
        grp = getgrnam("dip");
        if (grp)
        {
            char **actuser = grp->gr_mem;
            while (*actuser)
            {
                groupusers.append(*actuser);
                actuser++;
            }
        }
        else ok = FALSE;
    }
    else ok = FALSE;
    if (!ok)
    {
        KMessageBox::sorry(0,i18n("Could not find out your username. Cannot determine your access rights."));
    }
    kdDebug() << "Groupuser: " << groupusers << endl;
    QString dontShowAgain="nodialupuserwarning";
    if (groupusers.findIndex(user)==-1 )
    {
        // User not member of dip group
        if (KMessageBox::shouldBeShownContinue(dontShowAgain))
        {
            KMessageBox::information(0,QString(i18n("You are not a member or the dialup (dip) group. Dialup networking will not work.")),"Kwlan",dontShowAgain);
            KMessageBox::saveDontShowAgainContinue(dontShowAgain);
        }
        dialupUser = FALSE;
    }
    else
    {
        dialupUser = TRUE;
    }
    // check for existing directory for dialup networking
    if (dialupUser)
    {
        if (dir.exists("/etc/ppp/peers"))
        {
        // ppp peers directory exists, now check for kwlan dir
            if (!dir.exists(PPP_PEERS))
            {
                KProcess *proc = new KProcess;
                *proc << "mkdir" << "-m" << "770" << PPP_PEERS;
                proc->start();
            }

        } else kdDebug() <<   i18n("/etc/ppp/peers does not exist. Dialup networking will not work.") << endl;
    }
    KwlanMainWin *mainWin = new KwlanMainWin();
    mainWin->init();
}


