

#include "kwlanmainsettingsdlg.h"
#include "configuration.h"

#include "qspinbox.h"
#include "qcheckbox.h"

#include <kmessagebox.h>

KwlanMainSettingsDlg::KwlanMainSettingsDlg(QWidget* parent, const char* name, bool modal, WFlags fl)
: KwlanMainSettings(parent,name, modal,fl)
{
    int res;
    KMessageBox::setDontShowAskAgainConfig(mainConfiguration().m_configuration);
    cbMinimized->setChecked(mainConfiguration().readStartMinimized());
    res = KMessageBox::shouldBeShownContinue("newinterfacewizard");
    if (res) cbNewInterfaceWizard->setEnabled(FALSE);
    res = KMessageBox::shouldBeShownContinue("dontwarnnowpa");
    if (res) cbWpaWarning->setEnabled(FALSE);
    res = KMessageBox::shouldBeShownContinue("nodialupuserwarning");
    if (res) cbDialupUserWarning->setEnabled(FALSE);
    sbPasswordTime->setValue(PasswordCache().m_pwexpire);
}

KwlanMainSettingsDlg::~KwlanMainSettingsDlg()
{
}


/*$SPECIALIZATION$*/
void KwlanMainSettingsDlg::Cancel()
{
    QWidget::close(true);
}

void KwlanMainSettingsDlg::Ok()
{
    mainConfiguration().writeStartMinimized(cbMinimized->isChecked());
    if (cbNewInterfaceWizard->isChecked())
    {
        KMessageBox::enableMessage("newinterfacewizard");
    }
    if (cbWpaWarning->isChecked())
    {
        KMessageBox::enableMessage("dontwarnnowpa");
    }
    if (cbDialupUserWarning->isChecked())
    {
        KMessageBox::enableMessage("nodialupuserwarning");
    }
    PasswordCache().m_pwexpire = sbPasswordTime->value();
    PasswordCache().writePasswordExpire();
    QWidget::close(true);

}



#include "kwlanmainsettingsdlg.moc"

