#ifndef __KWLANMAINTRAYWIN__
#define  __KWLANMAINTRAYWIN__
/** Kwlan
 *
 *  This File is part of Kwlan, a network Manager for KDE.
 *  Kwlan is distributed under LGPL license.
 *
 *	@author Thomas Michel <tom.michel@arcor.de>
 */

#include <ksystemtray.h>
#include <qtooltip.h>

class QWidget;
class QPopupMenu;
class KwlanToolTip;
class KAction;


class KwlanMainToolTip : public QToolTip {

    public:
        KwlanMainToolTip(QWidget *parent);
        virtual ~KwlanMainToolTip();
	
    protected:
        void maybeTip(const QPoint &);
};


class KwlanMainTrayWin : public KSystemTray
{
    Q_OBJECT
    public:
        KwlanMainTrayWin(QWidget *parent=0, const char *name=0);
        virtual ~KwlanMainTrayWin();
        void contextMenuAboutToShow( KPopupMenu *r );
    public slots:
        void slotHandleInterfacesMenu(int id);
        void slotHandleConfigureInterfacesMenu(int);
        void slotSettingsMenu();
    signals:
        void aboutSelected();
        void sigMonitorInterface(QString interface, bool showWin);
        void sigConfigureInterface(QString interface, bool configure);
    protected:
        KAction *m_quit, *m_about;
        KwlanMainToolTip *m_tooltip;
    private:
        KPopupMenu *m_interfacesMenu;
        KPopupMenu *m_configureInterfacesMenu;
        KAction *m_settingsMenu;
  
};


#endif
