#ifndef SUPROCESSBASE_H
#define SUPROCESSBASE_H

#include <qobject.h>
#include <qcstring.h>
#include <qstring.h>

class KProcess;



/** SuProcessBase - basic su(1) process class.
 *
 *  This class provides a KProcess-like interface to run commands in priviledged mode
 *  It is simple and contains only minimum subset of KProcess interface which is needed for Kwlan.
 *  But SuProcessBase is not bound to Kwlan - it is general-purpose abstaract class.
 *
 *  This implementation shares some ideas and code with KExtProcess: Copyright (c) 2005 by Martijn Klingens <klingens@kde.org>
 *  KExtProcess is distributed under LGPL license.
 *
 *  SuProcessBase is Copyright (c) 2006 by Valentine Sinitsyn <e_val@inbox.ru>. Distributed under terms of LGPL.
 */

#define DEFAULT_SUPER_USER_COMMAND "sudo"

class SuProcessBase: public QObject {
  Q_OBJECT
  
  public:
    enum Communication {NoCommunication = 0, Stdin = 1, Stdout = 2, Stderr = 4};  
    enum RunMode {DontCare, NotifyOnExit, Block};
    
    SuProcessBase(QObject *parent = 0, const char *name = 0);
    virtual ~SuProcessBase();
    
    SuProcessBase& operator << (const QString &arg);
    void clearArguments();
    
    virtual bool start(RunMode runmode = NotifyOnExit, 
                       Communication comm = NoCommunication);
    
    bool isRunning() const;    
    int exitStatus() const;

    static QString quote(const QString &arg);    
    QString m_suCommand;
    bool authFailed() const;
    
    bool m_useSudo;
  signals:
    void processExited(SuProcessBase *);
    void receivedStdout(SuProcessBase *, char *, int);
    void receivedStderr(SuProcessBase *, char *, int);
    
  public slots:
    void restart();
    
  protected:
    virtual bool getPassword(QCString &password) = 0;  

  private:
    enum State {NotRunning, StartingUp, Launching, Running, ShuttingDown};
    enum OutputType {TypeStdout, TypeStderr};
    
    class Private;
    Private *d;
    
    void prepareStart();
    bool handlePasswordRequest(const QString &buffer);
    void incorrectPassword();
    void handleOutput(OutputType type, char *buffer, int buflen);
    
  private slots:
    void slotWroteStdin(KProcess *);
    void slotReceivedStdout(KProcess *, char *, int);
    void slotReceivedStderr(KProcess *, char *, int);
    void slotProcessExited(KProcess *);
};

#endif
