/*
   
        (c) 2006 by Thomas Michel <tom.michel@arcor.de>

        Kwlan is free software; you can redistribute it and/or modify
        it under the terms of the GNU Library General Public License as
        published by the Free Software Foundation; either version 2 of
        the License, or (at your option) any later version.

        Kwlan is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU Library General Public License for more details.

        You should have received a copy of the GNU Library General Public License
        along with this library; see the file COPYING.LIB.  If not, write to
        the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
        Boston, MA 02110-1301, USA.
*/

#include "kwlanapplication.h"
#include "kwlanmainwin.h"
#include "kwlaninterface.h"
#include "kwlansuprocess.h"
#include "dialup.h"
#include "globals.h"

#include <klocale.h>
#include <qstringlist.h>
#include <kprocess.h>
#include <qdir.h>
#include <kdebug.h>
#include <kmessagebox.h>

#include <pwd.h>
#include <grp.h>

bool dialupUser; // defines whether user is member of dialup group

KwlanApplication::KwlanApplication(bool allowStyles, bool GUIenabled, bool configUnique)
    : KUniqueApplication(allowStyles, GUIenabled, configUnique)
{
    KMessageBox::setDontShowAskAgainConfig(mainConfiguration().m_configuration);
}

 KwlanApplication::~KwlanApplication()
{
}

void KwlanApplication::init()
{
    QDir dir;
    KConfig* config = KGlobal::config();
    config->setGroup("super-user-command");
    // Check if user is in dip group to have access to dialup networking
    uid_t uid;
    QString user;
    QStringList groupusers;
    struct passwd *pw;
    struct group *grp;
    uid = geteuid ();
    if (::debugOutput) kdDebug() << "User uid is: " << uid << endl;
    pw = getpwuid (uid);
    bool ok = TRUE;
    if (pw)
    {
        user = QString(pw->pw_name);
        if (::debugOutput) kdDebug() << "Your username is: " << user << endl;
        grp = getgrnam("dip");
        if (grp)
        {
            char **actuser = grp->gr_mem;
            while (*actuser)
            {
                groupusers.append(*actuser);
                actuser++;
            }
        }
        else ok = FALSE;
    }
    else ok = FALSE;
    if (!ok)
    {
        KMessageBox::sorry(0,i18n("Could not find out your username. Cannot determine your access rights."));
    }
    kdDebug() << "Groupuser: " << groupusers << endl;
    QString dontShowAgain="nodialupuserwarning";
    if (groupusers.findIndex(user)==-1 )
    {
        // User not member of dip group
        if (KMessageBox::shouldBeShownContinue(dontShowAgain))
        {
            KMessageBox::information(0,QString(i18n("You are not a member of the dialup (dip) group. Dialup networking will not work.")),"Kwlan",dontShowAgain);
            KMessageBox::saveDontShowAgainContinue(dontShowAgain);
        }
        dialupUser = FALSE;
    }
    else
    {
        dialupUser = TRUE;
    }
    // check for existing directory for dialup networking
    if (dialupUser)
    {
        if (dir.exists("/etc/ppp/peers"))
        {
        // ppp peers directory exists, now check for kwlan dir
            if (!dir.exists(PPP_PEERS))
            {
                KwlanSuProcess *proc = new KwlanSuProcess;
                *proc << "mkdir" << "-m" << "770" << PPP_PEERS;
                proc->start();
            }

        } else kdDebug() <<   i18n("/etc/ppp/peers does not exist. Dialup networking will not work.") << endl;
    }
    KwlanMainWin *mainWin = new KwlanMainWin();
    mainWin->init();
}


