/*
   
        (c) 2006 by Thomas Michel <tom.michel@arcor.de>

        Kwlan is free software; you can redistribute it and/or modify
        it under the terms of the GNU Library General Public License as
        published by the Free Software Foundation; either version 2 of
        the License, or (at your option) any later version.

        Kwlan is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU Library General Public License for more details.

        You should have received a copy of the GNU Library General Public License
        along with this library; see the file COPYING.LIB.  If not, write to
        the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
        Boston, MA 02110-1301, USA.
*/

#ifndef _KWLANKICKER_H_
#define _KWLANKICKER_H_


#include <sys/types.h>
#include <ksystemtray.h>
#include <qtooltip.h>
#include <qstring.h>
#include <qptrlist.h>
#include <kpopupmenu.h>
#include <qtimer.h>
#include <qmap.h>

#include "kwlnetworklist.h"


class QWidget;
class KAction;
class KwlanInterface;
class Configuration;
class QProgressBar;

// IDs for WPA MEnu
#define WPASTARTID 1
#define WPASTOPID 2
#define WPALOGID 3
#define WPASETTINGSID 4

// Custom menu class to display signal strength

class KWirelessMenu : public QCustomMenuItem
{
    public:
        KWirelessMenu  (QWidget*, const kwlNetwork & prof, bool active);
        ~KWirelessMenu ();

        QWidget*      m_parent;
        QProgressBar* m_strengthGraph;

        void  paint    (QPainter*, const QColorGroup&, bool, bool, int, int, int, int);
        QSize sizeHint ();

    private:
        QString m_ssid;
        int     m_strength;
        bool    m_adhoc;
        bool    m_isConfigured;
        bool    m_isEncrypted;

        /* menu item */
        int m_width;
        int m_height;
        int m_border;

        /* elements */
        int m_textHeight;
        int m_widgetHeight;

        int m_space;
};

// Tooltip class to show extended link information - "KGet approach"

class KwlanToolTip : public QToolTip {

    public:
     	KwlanToolTip(QWidget *parent);
    virtual ~KwlanToolTip();
	
    protected:
       void maybeTip(const QPoint &);
};


// Class to show status in systray

class KwlanTrayWin : public KSystemTray
{
    Q_OBJECT
    public:
        KwlanTrayWin(QWidget *parent=0, const char *name=0);
        virtual ~KwlanTrayWin();
        void contextMenuAboutToShow ( KPopupMenu * );
        bool isConnected() const;
        const QString & getInterfaceName() const;
        //void clearProfiles();
        void setInterface(KwlanInterface *interface);
        KwlanInterface* getInterface()
        {
            return m_interface;
        }
        void setProfile(QString profile)
        {
            m_profile = profile;
        }
        QString getProfile()
        {
            return m_profile;
        }
        void setInterfaceName(const QString &ifname);
        QString getIcon();

    signals:
        void sigMonitorInterface(QString interface, bool showWin);
        void sigConfigureInterface(QString interface, bool configure);
        void clicked();
        void aboutSelected();
        void profileChanged(QString profile);
        void interfaceEnable(bool enable);
        void viewLog();
        void editProfiles();
        void scan();
        void sigTrayWinClicked(QString);

        
    public slots:
        void updateIcon();
        void setIpAddress(const QString &ipaddress);
        void updateNetworks();
        void setInterfaceEnableMenu(bool up);
        void interfaceEnable();
        void wpaStart();
        void wpaStop();
        void handleWpaMenuEvent(int menu);
        void enableStartWpaMenu(bool enable);
        void slotInterfaceGone(KwlanInterface  *interface);
        void slotShowTrayWin(QString interface, bool showWin);
        void slotHandleInterfacesMenu(int id);
        void slotHandleConfigureInterfacesMenu(int);
        void mousePressEvent ( QMouseEvent * event );
        void slotSettings();
        void say (QString message);
        //void slotClicked(QMouseEvent*);

    protected:
        //void mouseReleaseEvent( QMouseEvent * );
        QString m_ifname;
        QString m_ipaddress;
        KAction *m_quit, *m_about,  *m_interfaceEnableMenu;
        KwlanToolTip *m_tooltip;
        QTimer *m_timer;
    private slots:
        void selectProfile(int id);
    private:
        kwlNetworkList m_profiles;
        //bool m_interfaceUp;
        KPopupMenu *m_profileMenu, *m_wpaMenu;
        KPopupMenu *m_configureInterfacesMenu;
        KPopupMenu *m_interfacesMenu;
        KwlanInterface *m_interface;
        QString m_profile;
        QString m_confFile;
        Configuration *m_configuration;
        QMap<int, kwlNetwork >       m_networkMap;
        //KwlanMainWin *m_mainWin;
};

#endif
