/***************************************************************************
 *   Copyright (C) 2006 by Tomasz Sałaciński   *
 *   distortion@vp.pl   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

//KDE Includes
#include <kmainwindow.h>
#include <klocale.h>
#include <kiconloader.h>
#include <klistbox.h>
#include <kpushbutton.h>
#include <kmessagebox.h>
#include <kaboutdialog.h>
#include <kaboutapplication.h>
#include <kfiledialog.h>

//QT Includes
#include <qfile.h>
#include <qdir.h>
#include <qlabel.h>

//kX Generator Includes
#include "kxgenerator.h"
#include "GlobalFunctions.h"
#include "properties.h"


kXGeneratorMain :: kXGeneratorMain(QString PathToXorg, QString PathToVideo, QString PathToInput, QString PathToHwconf)
    : KDialog( 0, "Main Window" )
{

X = new Xorg();
X->LoadConfig (PathToXorg, PathToVideo, PathToInput, PathToHwconf);

QString sec = "  Section \"ServerLayout\""
      "Screen \"Screen0\""
      "Identifier     \"Default Layout\""
      "InputDevice    \"Keyboard\" \"CoreKeyboard\""
      "InputDevice    \"Mouse\""
  "EndSection";


//  Declaring...
    KIconLoader *Icons = new KIconLoader();
    KListBox *Menu = new KListBox(this);
    QFrame *Line = new QFrame(this);
    KPushButton *SaveButton = new KPushButton(this);
    KPushButton *QuitButton = new KPushButton(this);
    KPushButton *AboutButton = new KPushButton(this);

//Window settings
if (LOGO) {
     setMinimumSize(800, 580);
     setMaximumSize(800, 580);
}
else
{
     setMinimumSize(800, 408);
     setMaximumSize(800, 408);
}

     setPlainCaption(Locale(500));
     setIcon(Icons->loadIcon("kxgenerator", KIcon::Small));

if (LOGO) {
QPixmap LogoPixmap;
LogoPixmap.load("/usr/share/pixmaps/kxgenerator-logo.png");

QLabel *LogoLabel = new QLabel (this);
LogoLabel->setGeometry(0, 0, 800, 172);
LogoLabel->setPixmap(LogoPixmap);


}
//We need to create graphical ListBox-Menu

if (LOGO) { Menu->setGeometry(10, 182, 210, 388); }
else
{ Menu->setGeometry(10, 10, 210, 388); }
       Menu->insertItem(Icons->loadIcon("looknfeel", KIcon::Desktop, KIcon::SizeHuge), Locale(0));
       Menu->insertItem(Icons->loadIcon("mouse", KIcon::Panel, KIcon::SizeHuge), Locale(1));
       Menu->insertItem(Icons->loadIcon("keyboard", KIcon::Desktop, KIcon::SizeHuge), Locale(2));
       Menu->insertItem(Icons->loadIcon("kcmpci", KIcon::Desktop, KIcon::SizeHuge), Locale(3));
       Menu->insertItem(Icons->loadIcon("background", KIcon::Desktop, KIcon::SizeHuge), Locale(4));
       Menu->insertItem(Icons->loadIcon("system", KIcon::Desktop, KIcon::SizeHuge), Locale(5));
       Menu->setSelected(0, TRUE);


//Horizontal Line
if (LOGO) { Line->setGeometry(QRect(240, 531, 550, 5)); }
else
{ Line->setGeometry(QRect(240, 359, 550, 5)); }

       Line->setFrameShape( QFrame::HLine );
       Line->setFrameShadow( QFrame::Sunken );
// Push buttons

if (LOGO) { SaveButton->setGeometry(660, 541, 130, 29); }
else
{ SaveButton->setGeometry(660, 369, 130, 29); }

       SaveButton->setText(Locale(6));
       SaveButton->setIconSet(Icons->loadIcon("apply", KIcon::Toolbar, KIcon::SizeSmall));

if (LOGO) { QuitButton->setGeometry(520, 541, 130, 29); }
else
{ QuitButton->setGeometry(520, 369, 130, 29); }

       QuitButton->setText(Locale(7));
       QuitButton->setIconSet(Icons->loadIcon("exit", KIcon::Toolbar, KIcon::SizeSmall));

if (LOGO) { AboutButton->setGeometry(240, 541, 130, 29); }
else
{ AboutButton->setGeometry(240, 369, 130, 29); }

       AboutButton->setText(Locale(10));
       AboutButton->setIconSet(Icons->loadIcon("info", KIcon::Toolbar, KIcon::SizeSmall));


//Connecting
       connect (Menu, SIGNAL(highlighted(int)), this, SLOT(MenuItemSelected(int)));
       connect (SaveButton, SIGNAL(clicked()), this, SLOT(accept()));
       connect (QuitButton, SIGNAL(clicked()), this, SLOT(reject()));
       connect (AboutButton, SIGNAL(clicked()), this, SLOT(about()));

//Showing MainWidget
       Main = new MainWidget(this, X);


//Starting with ServerLayout widget by default
       Main->ShowServerLayoutWidget();




}


void kXGeneratorMain :: MenuItemSelected(int SelectedItem)
{
if (SelectedItem == 0) { Main->ShowServerLayoutWidget(); }
if (SelectedItem == 1) { Main->ShowMouseWidget(); }
if (SelectedItem == 2) { Main->ShowKeyboardWidget(); }
if (SelectedItem == 3) { Main->ShowVideocardWidget(); }
if (SelectedItem == 4) { Main->ShowMonitorWidget(); }
if (SelectedItem == 5) { Main->ShowAdvancedWidget(); }
}

void kXGeneratorMain :: reject()
{

  int Quit = KMessageBox::questionYesNo(this, 
                                        Locale(8),
                                        Locale(9),
                                        KStdGuiItem::yes(),
                                        KStdGuiItem::no());


    if (Quit == KMessageBox::Yes) { hide(); close(); }
    if (Quit == KMessageBox::No) { return; }

}

void kXGeneratorMain :: about()
{
KIconLoader *AboutIcon = new KIconLoader();
KAboutApplication *About = new KAboutApplication(this, "About Dialog", TRUE);
About->setProgramLogo(AboutIcon->loadIcon("kxgenerator", KIcon::Toolbar, KIcon::SizeHuge));
About->show();

}

void kXGeneratorMain :: accept()
{
GlobalFunctions Global;
QString DefaultServerLayout = Global.GetServerLayout(X);

if (DefaultServerLayout == "") { return; }

X->WriteOption(Xorg::ServerFlags, 1, "DefaultServerLayout", DefaultServerLayout);


QString File = X->DumpConfiguration();
QString FileToOpen = KFileDialog::getSaveFileName(QDir::homeDirPath(), QString::null, this, QString::null);

if (FileToOpen == "")
{
KMessageBox::sorry(this, "Sorry, no file name specified.", "Error");
return;
}


QFile *TempFile = new QFile("/tmp/xtemp");

TempFile->open(IO_WriteOnly);
TempFile->writeBlock(File, File.length());
TempFile->close();





QFile *XorgFile = new QFile(FileToOpen);


XorgFile->open(IO_WriteOnly);






XorgFile->writeBlock(File, File.length());
XorgFile->close();
hide();
close();
return;




}




#include "kxgenerator.moc"
