/***************************************************************************
                          commands_edit  -  description
                             -------------------
    begin                : Wed Nov 26 2003
    copyright            : (C) 2003 by The KXMLEditor Team
    email                : a_charytoniuk@user.sourceforge.net
 ***************************************************************************/

 /***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef COMMANDS_EDIT_H
#define COMMANDS_EDIT_H

#include <qobjectlist.h>

#include <klocale.h>

#include "kxecommand.h"

/**
@author The KXMLEditor Team
*/


class KXEDeleteNodeCommand : public KXECommand
{
	public:
		KXEDeleteNodeCommand(KXMLEditorPart*, QDomNode &);
		~KXEDeleteNodeCommand();
		virtual void execute();
		virtual void unexecute();
		virtual QString name() const { return i18n("Delete node"); }
	protected:
		QDomNode m_domParentNode;
		QDomNode m_domNode;
		QDomNode m_afterNode;
};

class KXEDeleteAttrCommand : public KXECommand
{
	public:
		KXEDeleteAttrCommand(KXMLEditorPart*, QDomElement &, QDomAttr &);
		~KXEDeleteAttrCommand();
		virtual void execute();
		virtual void unexecute();
		virtual QString name() const { return i18n("Delete attribute"); }

  protected:
    QDomElement m_domOwnerElement;
    QDomAttr m_domAttr;
};

class KXEDeleteAllAttribCommand : public KXECommand
{
	public:
		KXEDeleteAllAttribCommand(KXMLEditorPart*, QDomElement &);
		~KXEDeleteAllAttribCommand();
		virtual void execute();
		virtual void unexecute();
		virtual QString name() const { return i18n("Delete all attributes"); }

  protected:
    QDomElement m_domOwnerElement;
    QPtrList<QDomAttr> m_listRemovedAttributes;
};

class KXECutCommand : public KXEDeleteNodeCommand
{
	public:
		KXECutCommand(KXMLEditorPart*, QDomNode &);
		~KXECutCommand();
		virtual QString name() const { return i18n("Cut node"); }
};

class KXEPasteToDocumentCommand : public KXECommand
{
	public:
		KXEPasteToDocumentCommand(KXMLEditorPart*, QDomDocument *, QDomElement &);
    ~KXEPasteToDocumentCommand();
		virtual void execute();
		virtual void unexecute();
		virtual QString name() const { return i18n("Paste node to document"); }

  protected:
    QDomDocument * m_pDomTargetDoc;
    QDomElement m_domSourceElement;
};

class KXEPasteToElementCommand : public KXECommand
{
	public:
		KXEPasteToElementCommand(KXMLEditorPart*, QDomElement &, QDomNode &);
    ~KXEPasteToElementCommand();
		virtual void execute();
		virtual void unexecute();
		virtual QString name() const { return i18n("Paste node to element"); }

  protected:
    QDomElement m_domTargetElement;
    QDomNode m_domSourceNode;
};

class KXEPasteToProcInstrCommand : public KXECommand
{
	public:
		KXEPasteToProcInstrCommand(KXMLEditorPart*, QDomProcessingInstruction &, QDomProcessingInstruction &);
    ~KXEPasteToProcInstrCommand();
		virtual void execute();
		virtual void unexecute();
		virtual QString name() const { return i18n("Paste node to proc. instruction"); }

  protected:
    QDomProcessingInstruction m_domTargetProcInstr;
    QString m_strNewData;
    QString m_strOldData;
};

class KXEPasteToCharDataCommand : public KXECommand
{
	public:
		KXEPasteToCharDataCommand(KXMLEditorPart*, QDomCharacterData &, QDomCharacterData &);
    ~KXEPasteToCharDataCommand();
		virtual void execute();
		virtual void unexecute();
		virtual QString name() const { return i18n("Paste node to char. data"); }

  protected:
    QDomCharacterData m_domTargetCharData;
    QString m_strNewData;
    QString m_strOldData;
};

class KXEDragDropMoveCommand : public KXECommand
{
	public:
		KXEDragDropMoveCommand(KXMLEditorPart*, QDomElement &, QDomNode &);
    ~KXEDragDropMoveCommand();
		virtual void execute();
		virtual void unexecute();
		virtual QString name() const { return i18n("Drag&&drop node"); }

  protected:
    QDomElement m_domTargetElement;
    QDomNode m_domSourceNode;
    QDomNode m_domPreviousParentNode;
};

class KXEUpCommand : public KXECommand
{
	public:
		KXEUpCommand(KXMLEditorPart*, QDomNode &);
		~KXEUpCommand();
		virtual void execute();
		virtual void unexecute();
		virtual QString name() const { return i18n("Move node up"); }

  protected:
    QDomNode m_domParentNode;
    QDomNode m_domNode;
};

class KXEDownCommand : public KXECommand
{
	public:
		KXEDownCommand(KXMLEditorPart*, QDomNode &);
		~KXEDownCommand();
		virtual void execute();
		virtual void unexecute();
		virtual QString name() const { return i18n("Move node down"); }

  protected:
    QDomNode m_domParentNode;
    QDomNode m_domNode;
};

class KXEEditCharDataCommand : public KXECommand
{
	public:
		KXEEditCharDataCommand(KXMLEditorPart*, QDomCharacterData &, const QString);
		~KXEEditCharDataCommand();
		virtual void execute();
		virtual void unexecute();
		virtual QString name() const { return i18n("Editing character data"); }

  protected:
    QDomCharacterData m_domCharacterData;
    QString m_strNewContents;
    QString m_strOldContents;
};

class KXEEditProcInstrCommand : public KXECommand
{
	public:
		KXEEditProcInstrCommand(KXMLEditorPart*, QDomProcessingInstruction &, const QString);
		~KXEEditProcInstrCommand();
		virtual void execute();
		virtual void unexecute();
		virtual QString name() const { return i18n("Editing proc. instruction"); }

  protected:
    QDomProcessingInstruction m_domProcInstr;
    QString m_strNewData;
    QString m_strOldData;
};

class KXEEditElementCommand : public KXECommand
{
	public:
		KXEEditElementCommand(KXMLEditorPart*, QDomElement &, const QString, const QString);
		~KXEEditElementCommand();
		virtual void execute();
		virtual void unexecute();
		virtual QString name() const { return i18n("Editing element"); }

  protected:
    QDomElement m_domElement;
    QString m_strNewPrefix;
    QString m_strNewName;
    QString m_strOldPrefix;
    QString m_strOldName;
};

class KXEEditAttrValueCommand : public KXECommand
{
	public:
		KXEEditAttrValueCommand(KXMLEditorPart*, const QDomAttr &, const QString);
		~KXEEditAttrValueCommand();
		virtual void execute();
		virtual void unexecute();
		virtual QString name() const { return i18n("Edit attribute value"); }

  protected:
    QDomAttr m_domAttr;
    QString m_strNewValue;
    QString m_strOldValue;
};

class KXEEditAttrNameCommand : public KXECommand
{
	public:
		KXEEditAttrNameCommand(KXMLEditorPart*, const QDomAttr &, const QString);
		~KXEEditAttrNameCommand();
		virtual void execute();
		virtual void unexecute();
		virtual QString name() const { return i18n("Edit attribute name"); }

  protected:
    QDomElement m_domOwnerElement;
    QString m_strNewName;
    QString m_strOldName;
    QString m_strValue;
    QString m_strNamespaceURI;
};

class KXEEditRawXmlCommand : public KXECommand
{
	public:
		KXEEditRawXmlCommand(KXMLEditorPart*, QDomElement &, QDomElement &);
		~KXEEditRawXmlCommand();
		virtual void execute();
		virtual void unexecute();
		virtual QString name() const { return i18n("Editing raw XML"); }

  protected:
    QDomElement m_domOldElement;
    QDomNode m_domParentNode;
    QDomElement m_domNewElement;
    QDomNode m_afterNode;
};


#endif
