/***************************************************************************
                          kxe_treeview.h  -  description
                             -------------------
    begin                : Thu Sep 20 2001
    copyright            : (C) 2001, 2002, 2003 by The KXMLEditor Team
    email                : OleBowle@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KXE_TREEVIEW_H
#define KXE_TREEVIEW_H

#include <klistview.h>
#include <qstrlist.h>

class KXESearchDialog;

class QDomDocument;
class QDomNode;
class QDomElement;
class QDomCharacterData;
class QDomProcessingInstruction;

class QMouseEvent;
class QTimer;
class QKeyEvent;
class KXMLGUIClient;
class KXE_TreeViewItem;

/**
 * This is a listview, which displays the XML tree structure.
 * @short shows XML tree
 */
class KXE_TreeView : public KListView
{
		Q_OBJECT

public:
	KXE_TreeView( KXMLGUIClient * pGUIClient, QWidget * pParent = 0, const char * pszName = 0 );

	/** Changes the behaviour of this view to readonly or readwrite. */
	void setReadWrite( bool fReadWrite );

	/** Selects the given item. */
	void selectItem( KXE_TreeViewItem * const pItem );

	/** Selects the item corresponding to the given node.
		 *  Returns true on success, false otherwise. */
	bool selectNode( const QDomNode & node );
	
	/** Returns the a pointer to the selected items node or a null pointer (if no item is selected). */
	QDomNode * getSelectedNode() const;

	/** Returns the a pointer to the special processing instruction or a null pointer for (if no item is exists). */
	QDomNode * getSpecProcInstrNode(const QString& target) const;

	/** Returns the selected items path or an empty string, if no item is selected. */
	QString getSelectedPath() const;
	
	/** Returns true, if this tree view contains bookmarked tree items and false otherwise. */
	bool containsBookmarkedItems() const { return (m_nBookmarkedItems>0); }

	/** Drop or paste text into item */
	bool drop(QListViewItem *, QDropEvent *);

	/** toggles bookmark on the selected item */
	void bookmarksToggle();

	/** searches for the next bookmarked item */
	void bookmarksPrev();

	/** searches for the previous bookmarked item */
	void bookmarksNext();

	/** deselects currently selected item */
	void editDeselect();

	/** Selects the selected item's parent item. */
	void viewNodeUp();

	/** Expands the selected tree item's subtree to the given level (see @ref KXE_TreeViewItem::expandSubTree). */
	void viewExpNode( int nLevel );

	/** Collapses the selected tree item's subtree to the given level (see @ref KXE_TreeViewItem::collapseSubTree). */
	void viewColNode( int nLevel );

 /**
	 * Creates new item(s) to the given node (and its child nodes)
	 * and inserts it (or them) in the tree.
	 */
	void updateNodeCreated( const QDomNode & node );

  /** Changes the item corresponding to the given node. */
	void updateNodeChanged( const QDomNode & node );

  /** Removes the item corresponding to the given node. */
	void updateNodeDeleted( const QDomNode & node );

	/** Moves the item corresponding to the given node. */
	void updateNodeMoved( const QDomNode & node );

	/** Clears the whole tree. */
	void updateClear();

 /**
	* Handles inplace-renaming of items, because in our case
	* only items representing XML elements are to be renameable.
	* For the actual renaming of the items text, the base
	* class functionality is used and the signal
	* @ref sigItemRenamedInplace emitted.
	*/
	virtual void rename( QListViewItem * pItem, int nColumn );

	/** Returns info, is root element is already created */
	bool hasRootNode();
	/** Returns last top-level child on the tree. If there are no chold in the tree, null is returned. */
	KXE_TreeViewItem* lastChild();

public slots:

	// configuration slots
	//////////////////////////////////////////////////////////////

	/**
	 * Changes this tree view's settings according to the current
	 * configuration.
	 */
	void slotTreeViewSettingsChanged();

signals:
	/** emitted, when no item is selected */
	void sigSelectionCleared(bool);

	/** emitted, when an XML element item is selected */
	void sigSelectionChanged( const QDomElement & );

	/** emitted, when an XML Content item is selected */
	void sigSelectionChanged( const QDomCharacterData & );

	/** emitted, when an XML proc.instr. item is selected */
	void sigSelectionChanged( const QDomProcessingInstruction & );

	/**
	 * Signals the change of bookmark status.
	 * true -  item(s) bookmarked
	 * false - no item bookmarked
	 */
	void sigNewBookmarkStatus( bool fStatus );

	/** Emitted, when a context menu is requested */
	void sigContextMenuRequested( const QString & szMenuName, const QPoint & pos );
	/** Emitted when user presses a key. */
	void sigKeyPressed(QKeyEvent* e);

protected:
	/** if RMB shows the popupmenu corresponding to the selected item */
	void contentsMousePressEvent( QMouseEvent * );

	/** Finds the corresponding treeview item to the given node. */
	KXE_TreeViewItem * findCorrespondingItem( const QDomNode & node );

	/** Overrides KListView::contentsMouseReleaseEvent */
	void contentsMouseReleaseEvent(QMouseEvent *);

	/** Overrides KListView::contentsMouseMoveEvent */
	void contentsMouseMoveEvent(QMouseEvent *);

	/** Overrides QScrollView::contentsDragEnterEvent */
	void contentsDragEnterEvent(QDragEnterEvent *);

	/** Overrides QScrollView::contentsDragMoveEvent */
	void contentsDragMoveEvent(QDragMoveEvent *);

	/** Overrides QScrollView::contentsDragLeaveEvent */
	void contentsDragLeaveEvent(QDragLeaveEvent *);

	/** Overrides QScrollView::contentsDropEvent */
	void contentsDropEvent(QDropEvent *);
    virtual void keyPressEvent(QKeyEvent *e);

protected slots:
	/** Checks, which type of item was selected an emits the corresponding signal. */
	void slotSelectionChanged();

private slots:

	/** Called, when m_autoOpenTimer timeout occured */
	void slotAutoOpenFolder();

protected:

	/** the GUI client, needed for the popupmenus */
	KXMLGUIClient * m_pGUIClient;

	/** number of bookmarked items */
	unsigned int m_nBookmarkedItems;	

	/** True if drag&drop operation started, otherwise is false */
	bool m_bDrag;

	/** Contain mouse position of drag operation */
	QPoint m_dragPos;

	/** The item that was current before the drag-enter event happened */
	QListViewItem *m_pCurrentBeforeDropItem;

	/** The item we are moving the mouse over (during a drag) */
	QListViewItem *m_pDropItem;

	/** List of avalilable drop formats */
	QStrList m_lstDropFormats;

	/** Timer for counting time to auto open fselected folder while drag */
	QTimer *m_autoOpenTimer;
};

#endif
