/***************************************************************************
                          kxeelementdialog.cpp  -  description
                             -------------------
    begin                : Mit Apr 17 2002
    copyright            : (C) 2002, 2003 by The KXMLEditor Team
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kxeelementdialog.h"

#include <qlabel.h>
#include <qcombobox.h>
#include <qpushbutton.h>

#include <klineedit.h>
#include <kdebug.h>
#include <klocale.h>

KXEElementDialog::KXEElementDialog( QWidget * pParent, const char * pszName, bool fModal, WFlags fl )
	: KXEElementDialogBase( pParent, pszName, fModal, fl )
{
	connect( m_pEditNsURI, SIGNAL(textChanged(const QString&)), this, SLOT(slotNsURIChanged(const QString&)) );
	connect( m_pEditName, SIGNAL(textChanged(const QString&)), this, SLOT(slotNameChanged(const QString&)) );
}

void KXEElementDialog::clearDialog()
{
	m_pEditNsURI->clear();
	m_pEditNsURI->setEnabled(true);
	m_pEditNsURI->show();
	m_pLblNsURI->setEnabled(true);
	m_pLblNsURI->show();

	m_pEditPrefix->clear();
	m_pEditPrefix->setDisabled(true);
	m_pEditPrefix->show();
	m_pLblPrefix->setEnabled(true);
	m_pLblPrefix->show();

	m_pEditName->clear();

	m_pComboInsert->setCurrentItem(0);
}

void KXEElementDialog::fillDialog( bool bNsURIIsNull )
{
	m_pEditNsURI->setDisabled(true);

	if ( bNsURIIsNull )
	{
		m_pEditNsURI->hide();
		m_pLblNsURI->hide();
		m_pLblNsURI->setDisabled(true);

		m_pEditPrefix->setDisabled(true);
		m_pEditPrefix->hide();
		m_pLblPrefix->hide();
		m_pLblPrefix->setDisabled(true);
	}
	else
	{
		m_pEditNsURI->setText( m_strNsURI );
		m_pEditNsURI->show();
		m_pLblNsURI->show();
		m_pLblNsURI->setEnabled(true);

		m_pEditPrefix->setText( m_strPrefix );
		m_pEditPrefix->setEnabled(true);
		m_pEditPrefix->show();
		m_pLblPrefix->show();
		m_pLblPrefix->setEnabled(true);
	}

	m_pComboInsert->hide();
	m_pComboInsert->setDisabled(true);
	m_pLblInsert->hide();
	m_pLblInsert->setDisabled(true);

	m_pEditName->setText( m_strName );
}

int KXEElementDialog::exec( bool bEditExisting, bool bRootElement, bool bNsURIIsNull )
{
  if(bEditExisting)
  {
    fillDialog( bNsURIIsNull );
  }
  else
  {
    if( bRootElement )
    {
      m_pComboInsert->hide();
      m_pComboInsert->setDisabled(true);
      m_pLblInsert->hide();
      m_pLblInsert->setDisabled(true);
    }
  
    clearDialog();
  }

	int iReturn = exec();
	if ( iReturn == Accepted )
	{
		m_strNsURI = m_pEditNsURI->text();
    m_strPrefix = m_pEditPrefix->text();
    m_strName = m_pEditName->text();

    m_bAtTop = ( m_pComboInsert->currentItem() == 0 );
	}

	return iReturn;
}

int KXEElementDialog::exec()
{
	if ( m_pEditName->text().isEmpty() )
		m_pBtnOK->setEnabled(false);
	else
		m_pBtnOK->setEnabled(true);
		
	m_pEditName->setFocus();
	m_pBtnOK->setDefault(true);

	return KXEElementDialogBase::exec();
}

void KXEElementDialog::slotNsURIChanged( const QString & strNewNsURI )
{
	if ( strNewNsURI.isEmpty() )
		m_pEditPrefix->setEnabled(false);
	else
		m_pEditPrefix->setEnabled(true);
}

void KXEElementDialog::slotNameChanged( const QString & strNewName )
{
  QString strMessage = checkName(strNewName);

  m_pTextLabelMessage->setText(strMessage);
  
	if ( strNewName.isEmpty()  || (strMessage.length() > 0))
		m_pBtnOK->setEnabled(false);
	else
		m_pBtnOK->setEnabled(true);
}

// Check, if XML element name is OK
QString KXEElementDialog::checkName(const QString strElementName)
{
  if(strElementName.length() == 0)
    return  "";
    
  // test for space
  if(strElementName.find(' ') >= 0)
    return i18n("Element name cannot contain space !");

  // test for xml, XML ... on start   
  if(strElementName.find("xml", 0, false) >= 0)
    return i18n("Element name cannot start with 'xml' or 'XML' !");

  // check first character
  QChar firstChar(strElementName[0]);
  if((firstChar != '_') && !firstChar.isLetter())
  {
    return i18n("Element name must starts with underscore or letter !");
  }
    
  // Forbidden characters
  QString strForbiddenChars("&@#$%^()%+?=:<>;\"'*");
  for(unsigned int i = 0; i < strForbiddenChars.length(); i++)
  {
    QChar ch = strForbiddenChars[i];

    if(strElementName.find(ch) >= 0)
      return i18n("Element name cannot contain character: %1 !").arg(ch);
  }

  return "";
}

