/***************************************************************************
 *   Copyright (C) 2006 by Stephen Allewell                                *
 *   stephen@mirramar.fsnet.co.uk                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include <kdebug.h>
#include "charselectordialog.h"
#include "charselecttable.h"
#include "configuration.h"

CharSelectorDialog::CharSelectorDialog(QWidget* parent, QMap<int,QChar>* usedSymbols, QValueList<int>* usedFlosses)
  : CharSelectorDlg(parent, "CharacterSelector", true),
    m_usedSymbols(usedSymbols),
    m_usedFlosses(usedFlosses)
{
  charSelectTable->setUsed(m_usedSymbols);
  connect(charSelectTable, SIGNAL(focusItemChanged(const QChar&)), this, SLOT(characterSelected(const QChar&)));
  connect(this, SIGNAL(charSelected()), this, SLOT(accept()));
}

CharSelectorDialog::~CharSelectorDialog()
{
}

void CharSelectorDialog::setSelectedChar(const QChar c)
{
  charSelectTable->setChar(c);
  m_currentChar = c;
}

QChar CharSelectorDialog::selectedChar()
{
  return m_currentChar;
}

void CharSelectorDialog::characterSelected(const QChar& c)
{
  if (!c.isPrint() || c.isSpace()) return;
  QMapIterator<int,QChar> it;
  for ( it = m_usedSymbols->begin() ; it != m_usedSymbols->end() ; ++it )
  {
    if (it.data() == c) return;
  }
  m_currentChar = c;
  emit charSelected();
}

