/***************************************************************************
 *   Copyright (C) 2005 by Roland Weigert                                  *
 *   roweigert@t-online.de                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "cdparanoia-interface.h"

extern rcdatei settingsfile;
extern mysqldatabase *database;

compactdisc::compactdisc()
{
  cdcontent=new cdrominfo();
  if (cdcontent->trackcount)
    {
      discid=cdcontent->discid;
      cddbquery=cdcontent->cddbquery;
    }
}

compactdisc::~compactdisc()
{
  delete cdcontent;
}

void compactdisc::getTrack(int number,QString trackname,progressmainwindow *progresswindow)
{
  startsector=cdcontent->cdtoc[number-1].frameoffset*1176;
  long numberframes=(cdcontent->cdtoc[number].frameoffset)-cdcontent->cdtoc[number-1].frameoffset;
  cdparanoiaProcess=new KProcess;
  processedsectors=0;
  *cdparanoiaProcess<<"cdparanoia"<<"-e"<<QString::number(number)<<trackname;
  connect(cdparanoiaProcess,SIGNAL(receivedStderr(KProcess *,char *,int)),SLOT(readprogressinfo(KProcess *,char *,int)));
  cdparanoiaProcess->start(KProcess::RunMode(1),KProcess::Communication(4));
  progress=progresswindow->startProgress(QString(i18n("reading in track %1 from CD")).arg(QString::number(number)),numberframes,cdparanoiaProcess);
  progresswindow->show();
  while (cdparanoiaProcess->isRunning())
    kapp->processEvents();
  progresswindow->killProgress(progress);
  delete cdparanoiaProcess;
}

void compactdisc::readprogressinfo(KProcess  *proc,char *text,int length)
{
  QString buffer=text;
  while (buffer.contains('\n'))
    {
      QString line=buffer.left(buffer.find('\n'));
      buffer=buffer.remove(0,buffer.find('\n')+1);
      if (line.find("[read]"))
        {
          //extract block out of line
          line=line.remove(0,line.find("@")+1);
          if (processedsectors<line.toLong())
            {
              processedsectors=line.toLong();
              progress->setProgress((processedsectors-startsector)/1176);
            }
        }
    }
}

#include "cdparanoia-interface.moc"
