/***************************************************************************
 *   Copyright (C) 2005 by Roland Weigert   *
 *   roweigert@t-online.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
using namespace std;

#ifndef _PROGRESS_H_
#define _PROGRESS_H_

#include <iostream>

#include <qstring.h>
#include <qwidget.h>
#include <qprogressbar.h>
#include <qpushbutton.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <klocale.h>
#include <kapp.h>
#include <qvbox.h>
#include <qdialog.h>
#include <qlayout.h>
#include <kprocess.h>

class progressinfo;
class progressinfoonly;
class progresswithbar;

//Motherwidget for all running processes
class progressmainwindow : public QDialog
  {
    Q_OBJECT
  public:
    progressmainwindow(bool);
    ~progressmainwindow()
    {}
    int runningprogresses;
    bool isChancelled;
  private:
    QVBox *progresslayout;
    QGroupBox * taskslayout;
    QPushButton *chancelallbutton;
  public slots:
    progresswithbar * startProgress(QString,long,KProcess *);
    progresswithbar * startProgress(QString,long);
    progressinfo * startInfo(QString);
    progressinfoonly * startInfoOnly(QString);
    void killProgress(progresswithbar *);
    void killProgress(progressinfo *);
    void killProgress(progressinfoonly *);
    void chancelAll();
  signals:
    void chancelprogresses();
    void chancelled();
  }
;

//Processes with a countable result
class progresswithbar : public QWidget
  {
    Q_OBJECT
  public:
    progresswithbar(QString,long,QWidget *,KProcess *);
    progresswithbar(QString,long,QWidget *);
    ~progresswithbar();
    bool isChancelled;
    void setProgress(long);
    QGroupBox *barbox;
    QGroupBox *line1box;
    QLabel *barlabel;
    QPushButton *chancelbutton;
    QProgressBar *bar;
    KProcess *progressedProcess;
  public slots:
    void chancelProcess();
  signals:
    void chancelled();
  }
;

//Processes that can only be shown as active
class progressinfo : public QWidget
  {
    Q_OBJECT
  public:
    progressinfo(QString,QWidget *);
    ~progressinfo();
    void setText(QString);
    QGroupBox *infobox;
    QLabel *infolabel;
    QPushButton *chancelbutton;
    bool isChancelled;
  public slots:
    void chancelProcess();
  signals:
    void chancelled();
  }
;

//Processes that can only be shown as active without Chancelbutton
class progressinfoonly : public QWidget
  {
    Q_OBJECT
  public:
    progressinfoonly(QString,QWidget *);
    ~progressinfoonly();
    void setText(QString);
    QGroupBox *infobox;
    QLabel *infolabel;
  }
;

#endif //_PROGRESS_H_

